package jp.groupsession.v2.cht.restapi.entities.messages.reactions;

import java.sql.SQLException;
import java.util.List;

import jp.co.sjts.util.struts.RequestLocal;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtBiz;
import jp.groupsession.v2.cht.biz.ChtSendViewBiz;
import jp.groupsession.v2.cht.model.ChtAdmConfModel;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.model.EnumReactionFlg;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesInfoBiz;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cht.restapi.entities.messages.ChtEntitiesMessageBiz;
import jp.groupsession.v2.cht.restapi.entities.messages.ChtEntitiesMessagesResultModel;
import jp.groupsession.v2.cht.restapi.entities.messages.MessagesResultModelConverter;
import jp.groupsession.v2.cht.restapi.entities.messages.reactions.users.ChtReactionUsersGetBiz;
import jp.groupsession.v2.cht.search.ChatMessageSearchFilter;
import jp.groupsession.v2.cht.search.ChatMessageSearchFilter.EnumType;
import jp.groupsession.v2.cht.search.ChatMessageSearchRequest;
import jp.groupsession.v2.cht.search.ChatMessageSearchResult;
import jp.groupsession.v2.cht.search.ChatMessageSearcher;
import jp.groupsession.v2.cht.search.TargetMessageWrongException;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.struts.msg.GsMessage;

public class ChtReactionPutBiz {
    /** パラメータモデル*/
    private final ChtReactionPutParamModel param__;
    /** RESTAPIコンテキスト*/
    private final RestApiContext ctx__;

    /** 検索結果*/
    private ChtEntitiesMessagesResultModel result__ = null;

    /**チャットグループ */
    private ChtGroupInfModel gmdl__ = null;

    /**チャット相手ユーザ情報 */
    private CmnUsrmModel umdl__ = null;



    private ChtReactionPutBiz(ChtReactionPutParamModel param,
            RestApiContext ctx) {
        param__ = param;
        ctx__ = ctx;
    }

    /**
     * リクエスト内でビジネスロジックをシングルトンオブジェクトとして取得する
     * 一度もアクセスしていない場合、新規作成
     * @param param
     * @param ctx
     * @return リクエスト毎のビジネスロジック
     */
    public static ChtReactionPutBiz getInstance(
        ChtReactionPutParamModel param,
        RestApiContext ctx) {

            ChtReactionPutBiz ret = RequestLocal.get(
            ChtReactionPutBiz.class,
            ChtReactionPutBiz.class);
        if (ret == null) {
            ret = new ChtReactionPutBiz(param, ctx);
            RequestLocal.put(ChtReactionUsersGetBiz.class,
            ret);
        }
        return ret;

    }

    /**
     * ビジネスロジックの実行
     * @throws SQLException
     */
    public void execute() throws SQLException {

        __putReaction();

        // 実行結果レスポンス取得
        __createResult();
    }
    /**
     * リアクション変更を実行する
     * @throws SQLException
     */
    private void __putReaction() throws SQLException {

        EnumChatType type = param__.getType();
        long messageSid = param__.getMessageSid();
        int reactionSid = param__.getReactionCodeNum().getValue();
        EnumReactionFlg enumReactionFlg = param__.getFlg();

        ChtSendViewBiz sendBiz = new ChtSendViewBiz(ctx__.getRequestModel(), ctx__.getCon());

        int kbn = 0;
        int partnerSid = 0;
        if (type == EnumChatType.group) {
            kbn = GSConstChat.CHAT_KBN_GROUP;
            partnerSid = __getGmdl().getCgiSid();
        }
        if (type == EnumChatType.user) {
            kbn = GSConstChat.CHAT_KBN_USER;
            partnerSid = __getUmdl().getUsrSid();
        }

        sendBiz.putReaction(
            kbn,
            partnerSid,
            messageSid,
            reactionSid,
            enumReactionFlg);
    }

    /** 結果モデルの生成
     * @throws SQLException */
    private void __createResult() throws SQLException {
        ChatMessageSearchRequest searchReq;
        if (param__.getType() == EnumChatType.group) {

            searchReq =
                ChatMessageSearchRequest.createGroupChatSearchModel(
                    ctx__.getRequestModel(),
                    __getGmdl().getCgiSid());

        } else {
            searchReq =
                ChatMessageSearchRequest.createUserChatSearchModel(
                    ctx__.getCon(),
                    ctx__.getRequestModel(),
                    __getUmdl().getUsrSid());
        }

        searchReq.setFilterList(
            List.of(
                new ChatMessageSearchFilter(
                    EnumType.message,
                    String.valueOf(
                        param__.getMessageSid()
                    )
                )
            )
        );
        //管理者設定の取得
        ChtBiz chtBiz = new ChtBiz(ctx__.getCon());
        ChtAdmConfModel adminMdl = chtBiz.getChtAconf();
        try {
            ChatMessageSearchResult searchResult =
            new ChatMessageSearcher(
                ctx__.getCon(),
                searchReq,
                adminMdl)
                .execute();

            if (searchResult.getHitCount() == 0) {
                result__ = null;
                return;
            }

            MessagesResultModelConverter converter =
                new MessagesResultModelConverter(ctx__);

            List<ChtEntitiesMessagesResultModel> resultList =
                converter.execute(searchResult.getList());

            result__ = resultList.get(0);
        } catch (TargetMessageWrongException e) {
            result__ = null;
            return;
        }

    }
    /**
     *
     * @return チャット対象のユーザ情報を返す
     * @throws SQLException
    */
    private CmnUsrmModel __getUmdl()
            throws SQLException {

        if (umdl__ != null) {
            return umdl__;
        }
        CmnUsrmDao usrDao = new CmnUsrmDao(ctx__.getCon());
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        umdl__ = usrDao.select(param__.getUserId());

        if (umdl__ == null) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                    "errors.free.msg",
                    gsMsg.getMessage("cht.cht010.48")
            );
        }
        return umdl__;
    }
    /**
     *
     * @return チャットグループ情報を返す
     * @throws SQLException
     */
    private ChtGroupInfModel __getGmdl()
            throws SQLException {
        if (gmdl__ != null) {
            return gmdl__;
        }

        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
        ChtEntitiesInfoBiz infoBiz = new ChtEntitiesInfoBiz(ctx__.getCon(), gsMsg);

        gmdl__ = infoBiz.getGroupChatInf(param__.getChatGroupId(), ctx__.getRequestUserSid());
        return gmdl__;
    }


    /**
     * @return the result
     */
    public ChtEntitiesMessagesResultModel getResult() {
        return result__;
    }
    /**
     * 入力チェック
     * @throws RestApiPermissionException アクセス権限例外
     * @throws SQLException SQL実行時例外
     */
    public void validate() throws RestApiPermissionException, SQLException {
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        ChtSendViewBiz biz = new ChtSendViewBiz(ctx__.getRequestModel(), ctx__.getCon());
        ChtEntitiesMessageBiz mesBiz = new ChtEntitiesMessageBiz(
            ctx__.getCon(), gsMsg, ctx__.getRequestUserSid());
        //送信権限のチェック
        String errorMsg = "";
            if (param__.getType() == EnumChatType.group) {
                try {
                    ChtGroupInfModel gmdl = __getGmdl();

                    mesBiz.getGroupChatMessage(__getGmdl(), param__.getMessageSid());

                    errorMsg = biz.sendCheck(
                        gmdl.getCgiSid(), GSConstChat.CHAT_KBN_GROUP,
                        param__.getMessageSid(), true);
                    //チャットの指定が不正な場合はメッセージアクセス権限エラーとする
                } catch (RestApiPermissionException e) {
                    errorMsg = gsMsg.getMessage("cht.cht010.43");
                }

            } else {
                CmnUsrmDao usrDao = new CmnUsrmDao(ctx__.getCon());
                if (usrDao.isDeleteUser(param__.getUserId())) {
                    throw new RestApiPermissionException(
                        ChtEnumReasonCode.RESOURCE_USER_DELETE,
                        "errors.free.msg",
                        gsMsg.getMessage("cht.cht010.07"));
                }

                try {
                    CmnUsrmModel umdl =  __getUmdl();

                    mesBiz.getUserChatMessage(__getUmdl(), param__.getMessageSid());

                    errorMsg = biz.sendCheck(
                        umdl.getUsrSid(), GSConstChat.CHAT_KBN_USER,
                        param__.getMessageSid(), true);
                    //チャットの指定が不正な場合はメッセージアクセス権限エラーとする
                } catch (RestApiPermissionException e) {
                    errorMsg = gsMsg.getMessage("cht.cht010.43");
                }
            }

        //エラー内容のハンドリング
        new ChtEntitiesMessageBiz(ctx__.getCon(), gsMsg, ctx__.getRequestUserSid())
            .handleSendException(errorMsg);

    }


}
