package jp.groupsession.v2.cht.restapi.entities.messages.reactions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.groupsession.v2.cht.model.EnumReactionFlg;
import jp.groupsession.v2.cht.model.EnumReactioneCode;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.exception.RestApiValidateExceptionNest;
import jp.groupsession.v2.restapi.parameter.annotation.Default;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;

@ParamModel
public class ChtReactionPutParamModel {
    /** チャットタイプ */
    private EnumChatType type__;

    /** チャット相手ログインID */
    private String userId__;

    /** チャットグループID */
    private String chatGroupId__;

    /** メッセージSID */
    private long messageSid__;

    /** リアクションコード */
    private EnumReactioneCode reactionCodeNum__;

    /** リアクションフラグ */
    @Default("0")
    private EnumReactionFlg flg__;

    /**
     * @return the type
     */
    public EnumChatType getType() {
        return type__;
    }

    /**
     * @param type the type to set
     */
    public void setType(EnumChatType type) {
        type__ = type;
    }

    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }

    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }

    /**
     * @return the chatGroupId
     */
    public String getChatGroupId() {
        return chatGroupId__;
    }

    /**
     * @param chatGroupId the chatGroupId to set
     */
    public void setChatGroupId(String chatGroupId) {
        chatGroupId__ = chatGroupId;
    }

    /**
     * @return the messageSid
     */
    public long getMessageSid() {
        return messageSid__;
    }

    /**
     * @param messageSid the messageSid to set
     */
    public void setMessageSid(long messageSid) {
        messageSid__ = messageSid;
    }

    /**
     * @return the reactionCodeNum
     */
    public EnumReactioneCode getReactionCodeNum() {
        return reactionCodeNum__;
    }

    /**
     * @param reactionCodeNum the reactionCodeNum to set
     */
    public void setReactionCodeNum(EnumReactioneCode reactionCodeNum) {
        reactionCodeNum__ = reactionCodeNum;
    }

    /**
     * @return the flg
     */
    public EnumReactionFlg getFlg() {
        return flg__;
    }

    /**
     * @param flg the flg to set
     */
    public void setFlg(EnumReactionFlg flg) {
        flg__ = flg;
    }

    /**
     * パラメータ入力チェック
     * @param ctx
     * @throws SQLException
    */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {
        List<RestApiValidateException> valErrors = new ArrayList<>();

        ChtReactionPutBiz biz =
        ChtReactionPutBiz.getInstance(this, ctx);

        biz.validate();


        if (valErrors.size() > 0) {
            throw new RestApiValidateExceptionNest(valErrors);
        }

    }

}
