package jp.groupsession.v2.cht.restapi.entities.messages.reactions.users;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;

@Plugin(GSConstChat.PLUGIN_ID_CHAT)
public class ChtReactionUsersAction extends AbstractRestApiAction {

    /**
     * リアクションしたメンバーを一覧取得するAPI アクションメソッド
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @throws SQLException
     */
    @Get
    public void doGet(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtReactionUsersGetParamModel param,
        RestApiContext ctx) throws SQLException {


        ChtReactionUsersGetBiz biz = ChtReactionUsersGetBiz.getInstance(
            param,
            ctx);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
        .addResultList(biz.getResult())
        .setMax(biz.getMax())
        .build().execute();

    }

}
