package jp.groupsession.v2.cht.restapi.entities.messages.reactions.users;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import jp.co.sjts.util.struts.RequestLocal;
import jp.groupsession.v2.cht.biz.ChtReactionBiz;
import jp.groupsession.v2.cht.model.ChtReactionModel;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cht.restapi.entities.messages.ChtEntitiesMessageBiz;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiValidateExceptionNest;
import jp.groupsession.v2.restapi.response.MinimalUserInfoModel;
import jp.groupsession.v2.struts.msg.GsMessage;

public class ChtReactionUsersGetBiz {
    /** パラメータモデル*/
    private final ChtReactionUsersGetParamModel param__;
    /** RESTAPIコンテキスト*/
    private final RestApiContext ctx__;

    /** 検索結果*/
    private List<MinimalUserInfoModel> result__ = List.of();
    /** 検索結果件数*/
    private int max__ = 0;


    /**
     * コンストラクタ
     * @param param
     * @param ctx
     */
    private ChtReactionUsersGetBiz(ChtReactionUsersGetParamModel param, RestApiContext ctx) {
        param__ = param;
        ctx__ = ctx;
    }

    /**
     * リクエスト内でビジネスロジックをシングルトンオブジェクトとして取得する
     * 一度もアクセスしていない場合、新規作成
     * @param param
     * @param ctx
     * @return リクエスト毎のビジネスロジック
     */
    public static ChtReactionUsersGetBiz getInstance(
            ChtReactionUsersGetParamModel param, RestApiContext ctx) {

            ChtReactionUsersGetBiz ret = RequestLocal.get(
                ChtReactionUsersGetBiz.class,
                ChtReactionUsersGetBiz.class);
        if (ret == null) {
            ret = new ChtReactionUsersGetBiz(param, ctx);
            RequestLocal.put(ChtReactionUsersGetBiz.class,
            ret);
        }
        return ret;
    }

    /**
     * パラメータ入力チェック
     * @throws SQLException
     * @throws RestApiValidateExceptionNest 入力チェック例外
    */
    public void validate() throws SQLException, RestApiValidateExceptionNest {
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        ChtEntitiesMessageBiz mesBiz = new ChtEntitiesMessageBiz(
            ctx__.getCon(), gsMsg, ctx__.getRequestUserSid());
        //メッセージアクセス権限チェック
        if (param__.getType() == EnumChatType.group) {
            mesBiz.getGroupChatMessage(
                param__.getChatGroupId(),
                param__.getMessageSid());
        } else if (param__.getDeleteUserSid() > 0) {
            mesBiz.getDeleteUserChatMessage(
                param__.getUserId(),
                param__.getDeleteUserSid(),
                param__.getMessageSid());
        } else {
            mesBiz.getUserChatMessage(
                param__.getUserId(),
                param__.getMessageSid());
        }
    }
    /**
     * ビジネスロジックの実行
     * @throws SQLException
     */
    public void execute() throws SQLException {

        ChtReactionBiz reactionBiz = new ChtReactionBiz();
        Map<Long, List<ChtReactionModel>> reactionMap = Map.of();
        if (param__.getType() == EnumChatType.group) {
            reactionMap = reactionBiz.getGroupReactionData(
                List.of(param__.getMessageSid()),
                ctx__.getCon());
        } else {
            reactionMap = reactionBiz.getUserReactionData(
                List.of(param__.getMessageSid()),
                ctx__.getCon());
        }

        Set<Integer> usrSids =
            reactionMap.values()
                .stream()
                .flatMap(l -> l.stream())
                .filter(m -> (m.getRacSid() == param__.getReactionCodeNum().getValue()))
                .flatMap(m -> m.getUsrSidList().stream())
                .collect(Collectors.toSet());

        max__ = usrSids.size();
        //取得位置が最大件数を超えている
        int offset = param__.getOffset();
        if (offset >= max__) {
            result__ = List.of();
            return;
        }
        if (offset < 0) {
            offset = 0;
        }
        //ユーザSIDからユーザ情報を取得
        UserSearchDao userDao = new UserSearchDao(ctx__.getCon());
        result__ = userDao.getUsersDataList(usrSids, true, param__.getLimit(), offset)
            .stream()
            .map(u -> new MinimalUserInfoModel(ctx__.getRequestUserSid(), u))
            .collect(Collectors.toList());

    }

    /**
     * @return the result
     */
    public List<MinimalUserInfoModel> getResult() {
        return result__;
    }

    /**
     * @return the max
     */
    public int getMax() {
        return max__;
    }



}
