package jp.groupsession.v2.cht.restapi.entities.messages.reactions.users;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.groupsession.v2.cht.model.EnumReactioneCode;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.exception.RestApiValidateExceptionNest;
import jp.groupsession.v2.restapi.parameter.annotation.Default;
import jp.groupsession.v2.restapi.parameter.annotation.MaxValue;
import jp.groupsession.v2.restapi.parameter.annotation.MinValue;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;

@ParamModel
public class ChtReactionUsersGetParamModel {
    /** チャットタイプ */
    private EnumChatType type__;

    /** チャット相手ログインID */
    private String userId__;

    /** 削除済みユーザSID */
    private int deleteUserSid__ = -1;

    /** チャットグループID */
    private String chatGroupId__;

    /** メッセージSID */
    private long messageSid__;

    /** リアクションコード */
    private EnumReactioneCode reactionCodeNum__;

    /** 取得件数 */
    @Default("50")
    @MaxValue(100)
    @MinValue(1)
    private int limit__;

    /** 取得開始位置 */
    @Default("0")
    @MinValue(0)
    private int offset__;

    /**
     * @return the type
     */
    public EnumChatType getType() {
        return type__;
    }

    /**
     * @param type the type to set
     */
    public void setType(EnumChatType type) {
        type__ = type;
    }

    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }

    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }

    /**
     * @return the deleteUserSid
     */
    public int getDeleteUserSid() {
        return deleteUserSid__;
    }

    /**
     * @param deleteUserSid the deleteUserSid to set
     */
    public void setDeleteUserSid(int deleteUserSid) {
        deleteUserSid__ = deleteUserSid;
    }

    /**
     * @return the chatGroupId
     */
    public String getChatGroupId() {
        return chatGroupId__;
    }

    /**
     * @param chatGroupId the chatGroupId to set
     */
    public void setChatGroupId(String chatGroupId) {
        chatGroupId__ = chatGroupId;
    }

    /**
     * @return the messageSid
     */
    public long getMessageSid() {
        return messageSid__;
    }

    /**
     * @param messageSid the messageSid to set
     */
    public void setMessageSid(long messageSid) {
        messageSid__ = messageSid;
    }

    /**
     * @return the reactionCodeNum
     */
    public EnumReactioneCode getReactionCodeNum() {
        return reactionCodeNum__;
    }

    /**
     * @param reactionCodeNum the reactionCodeNum to set
     */
    public void setReactionCodeNum(EnumReactioneCode reactionCodeNum) {
        reactionCodeNum__ = reactionCodeNum;
    }

    /**
     * @return the limit
     */
    public int getLimit() {
        return limit__;
    }

    /**
     * @param limit the limit to set
     */
    public void setLimit(int limit) {
        limit__ = limit;
    }

    /**
     * @return the offset
     */
    public int getOffset() {
        return offset__;
    }

    /**
     * @param offset the offset to set
     */
    public void setOffset(int offset) {
        offset__ = offset;
    }

    /**
     * パラメータ入力チェック
     * @param ctx
     * @throws SQLException
    */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {
        List<RestApiValidateException> valErrors = new ArrayList<>();

        ChtReactionUsersGetBiz biz =
        ChtReactionUsersGetBiz.getInstance(this, ctx);

        biz.validate();


        if (valErrors.size() > 0) {
            throw new RestApiValidateExceptionNest(valErrors);
        }

    }



}
