package jp.groupsession.v2.cht.restapi.entities.messages.viewmessages;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.controller.annotation.Post;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;
/** チャットメッセージを既読する Action */
@Plugin(GSConstChat.PLUGIN_ID_CHAT)
public class ChtEntitiesViewMessagesAction extends AbstractRestApiAction {

    /**
     * チャットメッセージを既読する
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @throws Exception
     */
    @Post
    public void doPost(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtEntitiesViewMessagesPostParamModel param,
        RestApiContext ctx) throws Exception {

        JDBCUtil.autoCommitOff(ctx.getCon());

        ChtEntitiesViewMessagesPostBiz biz =
            ChtEntitiesViewMessagesPostBiz.getInstance(param, ctx);
        biz.execute();

        JDBCUtil.autoCommitOn(ctx.getCon());

        RestApiResponseWriter.builder(res, ctx)
        .addResultList(biz.getResult())
        .build().execute();
    }


}
