package jp.groupsession.v2.cht.restapi.entities.messages.viewmessages;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import jp.co.sjts.util.struts.RequestLocal;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtSendViewBiz;
import jp.groupsession.v2.cht.model.ChtGroupDataModel;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.model.ChtUserDataModel;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesBiz;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesInfoBiz;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesResultModel;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cht.restapi.entities.messages.ChtEntitiesMessageBiz;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmInfDao;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.struts.msg.GsMessage;

/** チャットメッセージを既読する API ビジネスロジック*/
public class ChtEntitiesViewMessagesPostBiz {
    /** パラメータ */
    private final ChtEntitiesViewMessagesPostParamModel param__;

    /** APIコンテキスト */
    private final RestApiContext ctx__;

    /**実行結果 チャットモデル */
    private List<ChtEntitiesResultModel> result__;

    /**チャットグループ */
    private ChtGroupInfModel gmdl__ = null;

    /**チャット相手ユーザ情報 */
    private CmnUsrmModel umdl__ = null;


    /** メッセージ情報(グループ) */
    private ChtGroupDataModel groupMessageMdl__;

    /** メッセージ情報(ユーザ) */
    private ChtUserDataModel userMessageMdl__;


    /**
     * @param param
     * @param ctx
     */
    private ChtEntitiesViewMessagesPostBiz(
            ChtEntitiesViewMessagesPostParamModel param, RestApiContext ctx) {
        param__ = param;
        ctx__ = ctx;
    }

    /**
     * リクエスト内でビジネスロジックをシングルトンオブジェクトとして取得する
     * 一度もアクセスしていない場合、新規作成
     * @param param
     * @param ctx
     * @return クエスト内でシングルトン管理されたビジネスロジッククラス
     */
    public static ChtEntitiesViewMessagesPostBiz getInstance(
            ChtEntitiesViewMessagesPostParamModel param, RestApiContext ctx) {
            ChtEntitiesViewMessagesPostBiz ret = RequestLocal.get(
            ChtEntitiesViewMessagesPostBiz.class,
            ChtEntitiesViewMessagesPostBiz.class);
        if (ret == null) {
            ret = new ChtEntitiesViewMessagesPostBiz(param, ctx);
            RequestLocal.put(ChtEntitiesViewMessagesPostBiz.class,
            ret);
        }
        return ret;
    }
    /**
     * 入力チェック、権限チェック処理
     * @throws SQLException
     */
    public void validate() throws SQLException {
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());


        ChtGroupInfModel gmdl = null;
        CmnUsrmModel umdl = null;
        //チャット指定権限チェック
        try {
            if (param__.getType() == EnumChatType.group) {
                gmdl = __getGmdl();
            } else {
                umdl = __getUmdl();
            }
        } catch (RestApiPermissionException e) {
            throw
                new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                "errors.free.msg",
                gsMsg.getMessage("cht.cht010.43")
                ).setParamName("messageSid");
        }

        //グループメッセージ指定権限チェック
        if (gmdl != null) {
            ChtGroupDataModel mesMdl = null;
            try {
                mesMdl = __getGroupMessageModel();
                if (mesMdl == null) {
                    throw new RestApiPermissionException(
                        ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                        "errors.free.msg", "");
                }

            } catch (RestApiPermissionException e) {
                throw
                    new RestApiPermissionException(
                        ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                        "errors.free.msg",
                        gsMsg.getMessage("cht.cht010.43")
                        ).setParamName("messageSid");
            }

        //ユーザメッセージ指定権限チェック
        } else if (umdl != null) {
            ChtUserDataModel mesMdl = null;
            try {
                mesMdl = __getUserMessageModel();
                if (mesMdl == null) {
                    throw new RestApiPermissionException(
                        ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                        "errors.free.msg", "");
                }
            } catch (RestApiPermissionException e) {
                throw
                    new RestApiPermissionException(
                    ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                    "errors.free.msg",
                    gsMsg.getMessage("cht.cht010.43")
                    ).setParamName("messageSid");
            }

        }
    }
    /**
     * ビジネスロジックを実行する
     * @throws SQLException
    */
    public void execute() throws SQLException {

        long msgSid = param__.getMessageSid();

        int chtPartnerSid = -1;
        int chtKbn = GSConstChat.CHAT_KBN_USER;
        if (param__.getType() == EnumChatType.group) {
            chtPartnerSid = __getGmdl().getCgiSid();
            chtKbn = GSConstChat.CHAT_KBN_GROUP;

        }
        if (param__.getType() == EnumChatType.user) {
            chtKbn = GSConstChat.CHAT_KBN_USER;
            chtPartnerSid = __getUmdl().getUsrSid();
        }




        ChtSendViewBiz sendBiz = new ChtSendViewBiz(
            ctx__.getRequestModel(),
            ctx__.getCon());

        sendBiz.updateViewMessage(chtKbn, chtPartnerSid, msgSid);

        __createResult();
    }
    /**
     * 実行結果モデルの生成
     * @throws SQLException
     */
    private void __createResult() throws SQLException {
        int sessionUsrSid = ctx__.getRequestUserSid();

        if (param__.getType() == EnumChatType.group) {
            List<String> groupIdList = Arrays.asList(new String[]{param__.getChatGroupId()});
            result__ = ChtEntitiesBiz.getChatGroupInfList(ctx__, sessionUsrSid, groupIdList);
        }
        if (param__.getType() == EnumChatType.user) {
            CmnUsrmInfDao uInfDao = new CmnUsrmInfDao(ctx__.getCon());
            ArrayList<CmnUsrmInfModel> userList = new ArrayList<CmnUsrmInfModel>();
            userList.add(uInfDao.select(__getUmdl().getUsrSid()));
            result__ = ChtEntitiesBiz.getChatUserInfList(ctx__, sessionUsrSid, userList);
        }
    }

    /**
     * 対象メッセージモデル(ユーザ)を取得する
     * @return メッセージモデル(ユーザ)
     * @throws RestApiPermissionException
     * @throws SQLException
     */
    private ChtUserDataModel __getUserMessageModel()
        throws RestApiPermissionException, SQLException {
        if (userMessageMdl__ != null) {
            return userMessageMdl__;
        }
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        ChtEntitiesMessageBiz mesBiz = new ChtEntitiesMessageBiz(
            ctx__.getCon(), gsMsg, ctx__.getRequestUserSid());

        userMessageMdl__ = mesBiz.getUserChatMessage(__getUmdl(), param__.getMessageSid(), true);
        return userMessageMdl__;
    }

    /**
     * 対象メッセージモデル(グループ)を取得する
     * @return メッセージモデル(グループ)
     * @throws RestApiPermissionException
     * @throws SQLException
     */
    private ChtGroupDataModel __getGroupMessageModel()
        throws RestApiPermissionException, SQLException {
        if (groupMessageMdl__ != null) {
            return groupMessageMdl__;
        }

        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        ChtEntitiesMessageBiz mesBiz = new ChtEntitiesMessageBiz(
            ctx__.getCon(), gsMsg, ctx__.getRequestUserSid());

        groupMessageMdl__ = mesBiz.getGroupChatMessage(__getGmdl(), param__.getMessageSid(), true);
        return groupMessageMdl__;
    }

    /**
     *
     * @return チャット対象のユーザ情報を返す
     * @throws SQLException
    */
    private CmnUsrmModel __getUmdl()
            throws SQLException {

        if (umdl__ != null) {
            return umdl__;
        }
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        ChtEntitiesInfoBiz infoBiz = new ChtEntitiesInfoBiz(ctx__.getCon(), gsMsg);

        if (param__.getDeleteUserSid() > 0) {
            int partnerUsrSid = param__.getDeleteUserSid();
            umdl__ = infoBiz.getDeletedUserChatInf(partnerUsrSid, param__.getUserId());
        } else {
            umdl__ = infoBiz.getUserChatInf(param__.getUserId());
        }

        if (umdl__ == null) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                    "errors.free.msg",
                    gsMsg.getMessage("cht.cht010.48")
            );
        }
        return umdl__;
    }
    /**
     *
     * @return チャットグループ情報を返す
     * @throws SQLException
     */
    private ChtGroupInfModel __getGmdl()
            throws SQLException {
        if (gmdl__ != null) {
            return gmdl__;
        }

        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
        ChtEntitiesInfoBiz infoBiz = new ChtEntitiesInfoBiz(ctx__.getCon(), gsMsg);

        gmdl__ = infoBiz.getGroupChatInf(param__.getChatGroupId(), ctx__.getRequestUserSid());
        return gmdl__;
    }

    /**
     *
     * @return 実行結果 メッセージモデル
    */
    public List<ChtEntitiesResultModel> getResult() {
        return result__;
    }
}
