package jp.groupsession.v2.cht.restapi.entities.messages.viewmessages;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.exception.RestApiValidateExceptionNest;
import jp.groupsession.v2.restapi.parameter.annotation.NotBlank;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
@ParamModel
public class ChtEntitiesViewMessagesPostParamModel {
    /** チャットタイプ */
    private EnumChatType type__;
    /** チャット相手ログインID */
    private String userId__;
    /** チャット相手ログインID */
    private String chatGroupId__;

    /** 削除済みユーザSID */
    private int deleteUserSid__ = -1;

    /** メッセージSID */
    @NotBlank
    private long messageSid__;

    /**
     * @return the type
     */
    public EnumChatType getType() {
        return type__;
    }
    /**
     * @param type the type to set
     */
    public void setType(EnumChatType type) {
        type__ = type;
    }
    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }
    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }
    /**
     * @return the chatGroupId
     */
    public String getChatGroupId() {
        return chatGroupId__;
    }
    /**
     * @param chatGroupId the chatGroupId to set
     */
    public void setChatGroupId(String chatGroupId) {
        chatGroupId__ = chatGroupId;
    }
    /**
     * @return the deleteUserSid
     */
    public int getDeleteUserSid() {
        return deleteUserSid__;
    }
    /**
     * @param deleteUserSid the deleteUserSid to set
     */
    public void setDeleteUserSid(int deleteUserSid) {
        deleteUserSid__ = deleteUserSid;
    }
    /**
     * @return the messageSid
     */
    public long getMessageSid() {
        return messageSid__;
    }
    /**
     * @param messageSid the messageSid to set
     */
    public void setMessageSid(long messageSid) {
        messageSid__ = messageSid;
    }

    /**
     * パラメータ入力チェック
     * @param ctx
     * @throws SQLException
    */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {
        List<RestApiValidateException> valErrors = new ArrayList<>();

        ChtEntitiesViewMessagesPostBiz biz =
            ChtEntitiesViewMessagesPostBiz.getInstance(this, ctx);

        biz.validate();

        if (valErrors.size() > 0) {
            throw new RestApiValidateExceptionNest(valErrors);
        }

    }
}
