package jp.groupsession.v2.cht.restapi.entities.mute;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.controller.annotation.Put;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;

@Plugin(GSConstChat.PLUGIN_ID_CHAT)
public class ChtEntitiesMuteAction extends AbstractRestApiAction {

    /**
     *
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @throws SQLException
     */
    @Put
    public void doPut(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtEntitiesMutePutParamModel param,
        RestApiContext ctx) throws SQLException {
        ChtEntitiesMutePutBiz biz = new ChtEntitiesMutePutBiz(param, ctx);
        biz.execute();
        RestApiResponseWriter.builder(res, ctx)
            .addResultList(biz.getResult())
            .setMax(biz.getMax())
            .build().execute();
    }
    
}
