package jp.groupsession.v2.cht.restapi.entities.mute;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtUserPairCreateBiz;
import jp.groupsession.v2.cht.dao.ChtGroupInfDao;
import jp.groupsession.v2.cht.dao.ChtGroupUconfDao;
import jp.groupsession.v2.cht.dao.ChtUserUconfDao;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.model.ChtGroupUconfModel;
import jp.groupsession.v2.cht.model.ChtUserUconfModel;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesBiz;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesInfoBiz;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesResultModel;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmInfDao;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiException;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.struts.msg.GsMessage;

public class ChtEntitiesMutePutBiz {

    /** パラメータ*/
    private ChtEntitiesMutePutParamModel param__;
    /** APIコンテキスト*/
    private RestApiContext ctx__;
    /** コネクション*/
    private Connection con__;
    /** 更新結果*/
    private List<ChtEntitiesResultModel> result__ = List.of();
    /** 更新件数*/
    private int max__ = 0;

    /**
     * コンストラクタ
     * @param param
     * @param ctx
     * @throws SQLException
     */
    public ChtEntitiesMutePutBiz(ChtEntitiesMutePutParamModel param,
            RestApiContext ctx) throws SQLException {
        param__ = param;
        ctx__ = ctx;
        con__ = ctx.getCon();
    }

    /**
     * ビジネスロジックを実行する
     * @throws SQLException
     */
    public void execute() throws SQLException {
        if (param__.getType() != null) {
            switch (param__.getType()) {
                case user:
                    __exeUserChatInfo();
                    break;
                case group:
                    __exeGroupChatInfo();
                    break;
                default:
                    break;
            }
            max__ = result__.size();
            return;
        }
    }

    /**
     *  ユーザチャットのミュートを更新する
     * @throws SQLException
     */
    private void __exeUserChatInfo()  throws SQLException {
        //指定したユーザの情報を取得する(取得できない場合エラーを返す)
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
        ChtEntitiesInfoBiz ceiBiz = new ChtEntitiesInfoBiz(con__, gsMsg);
        CmnUsrmModel usrMdl;
        if (param__.getDeleteUserSid() > 0) {
            try {
                usrMdl = ceiBiz.getDeletedUserChatInf(
                                param__.getDeleteUserSid(), param__.getUserId());
            } catch (RestApiException e) {
                throw new RestApiPermissionException(
                    ChtEnumReasonCode.RESOURCE_CANT_ACCESS_CHAT,
                        "errors.free.msg",
                        gsMsg.getMessage("cht.cht010.48")
                );
            }
        } else {
            try {
                usrMdl = ceiBiz.getUserChatInf(param__.getUserId());
            } catch (RestApiException e) {
                throw new RestApiPermissionException(
                    ChtEnumReasonCode.RESOURCE_CANT_ACCESS_CHAT,
                        "errors.free.msg",
                        gsMsg.getMessage("cht.cht010.48")
                );
            }
        }
        //ペア情報取得
        int sessionUsrSid = ctx__.getRequestUserSid();
        ChtUserPairCreateBiz cupBiz = new ChtUserPairCreateBiz();
        int cupSid = 0;
        try {
            cupSid = cupBiz.getCupSidAutoCreate(
                                ctx__.getRequestModel(), con__,
                                sessionUsrSid, usrMdl.getUsrSid());
        } catch (Exception e) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_CHAT,
                    "errors.free.msg",
                    gsMsg.getMessage("cht.cht010.33")
            );
        }
        if (cupSid != 0) {
            con__.setAutoCommit(false);
            //ミュート更新
            ChtUserUconfDao cuuDao = new ChtUserUconfDao(con__);
            ChtUserUconfModel cuuMdl = cuuDao.select(sessionUsrSid, cupSid);
            if (cuuMdl == null) {
                //新規登録
                cuuMdl = new ChtUserUconfModel();
                cuuMdl.setUsrSid(sessionUsrSid);
                cuuMdl.setCupSid(cupSid);
                cuuMdl.setCuucFavoriteKbn(GSConstChat.CHAT_NOT_FAVORITE);
                cuuMdl.setCuucMuteKbn(param__.getMuteFlg());
                cuuDao.insert(cuuMdl);
            } else {
                cuuMdl.setCuucMuteKbn(param__.getMuteFlg());
                cuuDao.update(cuuMdl);
            }
            //ユーザチャット情報の取得
            CmnUsrmInfDao uInfDao = new CmnUsrmInfDao(con__);
            ArrayList<CmnUsrmInfModel> userList = new ArrayList<CmnUsrmInfModel>();
            userList.add(uInfDao.select(usrMdl.getUsrSid()));
            result__ = ChtEntitiesBiz.getChatUserInfList(ctx__, sessionUsrSid, userList);
            con__.setAutoCommit(true);
        }
    }

    /**
     *  グループチャットのミュートを更新する
     * @throws SQLException
     */
    private void __exeGroupChatInfo()  throws SQLException {

        //存在しない/アクセスできないグループの場合、エラーを返す
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
        ChtEntitiesInfoBiz ceiBiz = new ChtEntitiesInfoBiz(con__, gsMsg);
        ceiBiz.getGroupChatInf(param__.getChatGroupId(), ctx__.getRequestUserSid());

        ChtGroupInfDao cgiDao = new ChtGroupInfDao(con__);
        ChtGroupInfModel infMdl = cgiDao.selectWhereCgiId(param__.getChatGroupId());
        if (infMdl != null) {
            con__.setAutoCommit(false);
            //ミュート更新
            int sessionUsrSid = ctx__.getRequestUserSid();
            ChtGroupUconfDao cguDao = new ChtGroupUconfDao(con__);
            ChtGroupUconfModel cguMdl = cguDao.select(sessionUsrSid, infMdl.getCgiSid());
            if (cguMdl == null) {
                //新規登録
                cguMdl = new ChtGroupUconfModel();
                cguMdl.setUsrSid(sessionUsrSid);
                cguMdl.setCgiSid(infMdl.getCgiSid());
                cguMdl.setCgucFavoriteKbn(GSConstChat.CHAT_NOT_FAVORITE);
                cguMdl.setCgucMuteKbn(param__.getMuteFlg());
                cguDao.insert(cguMdl);
            } else {
                cguMdl.setCgucMuteKbn(param__.getMuteFlg());
                cguDao.update(cguMdl);
            }
    
            //チャットグループ情報の取得
            List<String> groupIdList = Arrays.asList(new String[]{param__.getChatGroupId()});
            result__ = ChtEntitiesBiz.getChatGroupInfList(ctx__, sessionUsrSid, groupIdList);
            con__.setAutoCommit(true);
        }
    }

    /**
     *
     * @return APIレスポンスモデル
     */
    public List<ChtEntitiesResultModel> getResult() {
        return result__;
    }

    /**
     *
     * @return 更新件数
     */
    public int getMax() {
        return max__;
    }
}
