package jp.groupsession.v2.cht.restapi.entities.users;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.controller.annotation.Post;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;

/** チャットのメンバー情報を一覧取得する Action */
@Plugin(GSConstChat.PLUGIN_ID_CHAT)
public class ChtEntitiesUsersAction extends AbstractRestApiAction {
    /**
     * チャットのメンバー情報を一覧取得する Action
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @throws Exception
     */
    @Post
    public void doQueryPost(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtEntitiesUsersQueryParamModel param,
        RestApiContext ctx) throws Exception {

        ChtEntitiesUsersQueryBiz biz =
            ChtEntitiesUsersQueryBiz.getInstance(param, ctx);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
        .setMax(biz.getMax())
        .addResultList(biz.getResult())
        .build().execute();
    }

}
