package jp.groupsession.v2.cht.restapi.entities.users;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.struts.RequestLocal;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.dao.ChtGroupUserDao;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesInfoBiz;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.dao.base.CmnBelongmDao;
import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.response.MinimalUserInfoModel;
import jp.groupsession.v2.struts.msg.GsMessage;

public class ChtEntitiesUsersQueryBiz {

    /** パラメータ */
    private final ChtEntitiesUsersQueryParamModel param__;

    /** APIコンテキスト */
    private final RestApiContext ctx__;

    /** 検索結果*/
    private List<MinimalUserInfoModel> result__ = List.of();
    /** 検索結果件数*/
    private int max__ = 0;

    /**チャットグループ */
    private ChtGroupInfModel gmdl__ = null;

    /**チャット相手ユーザ情報 */
    private CmnUsrmModel umdl__ = null;

    /**
     * @param param
     * @param ctx
     */
    private ChtEntitiesUsersQueryBiz(ChtEntitiesUsersQueryParamModel param,
            RestApiContext ctx) {
        param__ = param;
        ctx__ = ctx;
    }

    /**
     * リクエスト内でビジネスロジックをシングルトンオブジェクトとして取得する
     * 一度もアクセスしていない場合、新規作成
     * @param param
     * @param ctx
     * @return リクエスト内でシングルトン管理されたビジネスロジッククラス
     */
    public static ChtEntitiesUsersQueryBiz getInstance(
            ChtEntitiesUsersQueryParamModel param, RestApiContext ctx) {
            ChtEntitiesUsersQueryBiz ret = RequestLocal.get(
            ChtEntitiesUsersQueryBiz.class,
            ChtEntitiesUsersQueryBiz.class);
        if (ret == null) {
            ret = new ChtEntitiesUsersQueryBiz(param, ctx);
            RequestLocal.put(ChtEntitiesUsersQueryBiz.class,
            ret);
        }
        return ret;
    }

    /**
     * ビジネスロジックの実行
     * @throws SQLException
    */
    public void execute() throws SQLException {
        /** メンバーユーザSID */
        Set<Integer> memSids = new HashSet<>();
        Connection con = ctx__.getCon();
        if (param__.getType() == EnumChatType.group) {
            ChtGroupInfModel gmdl = __getGmdl();
            Set<Integer> bgSids = new HashSet<>();
            ChtGroupUserDao cguDao = new ChtGroupUserDao(con);

            cguDao.select(gmdl.getCgiSid())
                .stream()
                .forEach(mem -> {
                    if (mem.getCguKbn() == GSConstChat.CHAT_KBN_USER) {
                        memSids.add(mem.getCguSelectSid());
                    }
                    if (mem.getCguKbn() == GSConstChat.CHAT_KBN_GROUP) {
                        bgSids.add(mem.getCguSelectSid());
                    }
                });
            //グループからメンバーへ変換
            for (int sid: bgSids) {
                memSids.addAll(
                    new CmnBelongmDao(con)
                    .selectBelongLiveUserSid(
                            sid)
                );
            }

        }

        if (param__.getType() == EnumChatType.user) {
            CmnUsrmModel umdl = __getUmdl();
            memSids.add(umdl.getUsrSid());
            memSids.add(ctx__.getRequestUserSid());

        }
        Set<String> keywords = new HashSet<>();
        if (!StringUtil.isNullZeroString(param__.getKeywordText())) {
            keywords.addAll(
                Arrays.asList(param__.getKeywordText().split("((\\s)|(　))"))
            );
        }
        List<CmnUserModel> allList = new UserSearchDao(con)
        .getUsersDataList(memSids, true)
        .stream()
        //検索キーワードによるフィルタリング
        .filter(u -> {
            String name = u.getUsiName();
            for (String keyword : keywords) {
                if (name.indexOf(keyword) < 0) {
                    return false;
                }
            }
            return true;
        })
        .collect(Collectors.toList());

        max__ = allList.size();

        int offset = param__.getOffset();
        //オフセットが結果件数を超える
        if (offset >= max__) {
            return;
        }
        if (offset < 0) {
            offset = 0;
        }
        int end = offset + param__.getLimit();
        if (end >= allList.size()) {
            end = allList.size();
        }

        result__ = allList.subList(offset, end)
        .stream()
        .map(u -> new MinimalUserInfoModel(ctx__.getRequestUserSid(), u))
        .collect(Collectors.toList());

    }

    /**
     * @return the max
     */
    public int getMax() {
        return max__;
    }

    /**
     * ビジネスロジック実行結果を取得する
     * @return ビジネスロジック実行結果
     */
    public List<MinimalUserInfoModel> getResult() {
        return result__;
    }

    /**
     * 入力チェック処理
     * @throws SQLException
     */
    public void validate() throws SQLException {
        //チャット指定権限チェック
        if (param__.getType() == EnumChatType.group) {
            __getGmdl();
        } else {
            __getUmdl();
        }
    }

    /**
     *
     * @return チャット対象のユーザ情報を返す
     * @throws SQLException
    */
    private CmnUsrmModel __getUmdl()
            throws SQLException {

        if (umdl__ != null) {
            return umdl__;
        }
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        ChtEntitiesInfoBiz infoBiz = new ChtEntitiesInfoBiz(ctx__.getCon(), gsMsg);

        umdl__ = infoBiz.getUserChatInf(param__.getUserId());

        return umdl__;
    }
    /**
     *
     * @return チャットグループ情報を返す
     * @throws SQLException
     */
    private ChtGroupInfModel __getGmdl()
            throws SQLException {
        if (gmdl__ != null) {
            return gmdl__;
        }

        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
        ChtEntitiesInfoBiz infoBiz = new ChtEntitiesInfoBiz(ctx__.getCon(), gsMsg);

        gmdl__ = infoBiz.getGroupChatInf(param__.getChatGroupId(), ctx__.getRequestUserSid());
        return gmdl__;
    }

}
