package jp.groupsession.v2.cht.restapi.entities.users;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.exception.RestApiValidateExceptionNest;
import jp.groupsession.v2.restapi.parameter.annotation.Default;
import jp.groupsession.v2.restapi.parameter.annotation.MaxLength;
import jp.groupsession.v2.restapi.parameter.annotation.MaxValue;
import jp.groupsession.v2.restapi.parameter.annotation.MinValue;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.TextField;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;

@ParamModel
public class ChtEntitiesUsersQueryParamModel {

    /** チャットタイプ */
    private EnumChatType type__;

    /** チャット相手ログインID */
    private String userId__;

    /** チャットグループID */
    private String chatGroupId__;

    /** 取得件数 */
    @Default("50")
    @MaxValue(100)
    @MinValue(1)
    private int limit__;

    /** 取得開始位置 */
    @Default("0")
    @MinValue(0)
    private int offset__;

    /** 検索キーワード */
    @MaxLength(50)
    @TextField
    private String keywordText__;

    /**
     * @return the type
     */
    public EnumChatType getType() {
        return type__;
    }

    /**
     * @param type the type to set
     */
    public void setType(EnumChatType type) {
        type__ = type;
    }

    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }

    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }

    /**
     * @return the chatGroupId
     */
    public String getChatGroupId() {
        return chatGroupId__;
    }

    /**
     * @param chatGroupId the chatGroupId to set
     */
    public void setChatGroupId(String chatGroupId) {
        chatGroupId__ = chatGroupId;
    }

    /**
     * @return the limit
     */
    public int getLimit() {
        return limit__;
    }

    /**
     * @param limit the limit to set
     */
    public void setLimit(int limit) {
        limit__ = limit;
    }

    /**
     * @return the offset
     */
    public int getOffset() {
        return offset__;
    }

    /**
     * @param offset the offset to set
     */
    public void setOffset(int offset) {
        offset__ = offset;
    }

    /**
     * @return the keywordText
     */
    public String getKeywordText() {
        return keywordText__;
    }

    /**
     * @param keywordText the keywordText to set
     */
    public void setKeywordText(String keywordText) {
        keywordText__ = keywordText;
    }


    /**
     * パラメータ入力チェック
     * @param ctx
     * @throws SQLException
    */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {
        List<RestApiValidateException> valErrors = new ArrayList<>();

        ChtEntitiesUsersQueryBiz biz =
            ChtEntitiesUsersQueryBiz.getInstance(this, ctx);

        biz.validate();


        if (valErrors.size() > 0) {
            throw new RestApiValidateExceptionNest(valErrors);
        }

    }


}
