package jp.groupsession.v2.cht.restapi.stamps;

import java.io.File;
import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.groupsession.v2.cht.dao.ChtStampDao;
import jp.groupsession.v2.cht.model.ChtStampModel;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Parameter;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.response.RestApiAttachementResponseWriter;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;

/** スタンプ画像取得Action */
@Plugin("chat")
public class ChtStampsAction extends AbstractRestApiAction {

    /** デフォルトスタンプ画像ディレクトリ */
    private static final String DEFAULT_STAMP_DIR = "/chat/images/stamp/";

    /**
     *
     * @param req
     * @param res
     * @param ctx
     * @throws SQLException
     */
    @Get
    @Parameter(name = "stampSid", value = "")
    public void doGetStamps(
        HttpServletRequest req,
        HttpServletResponse res,
        RestApiContext ctx) throws SQLException {

        ChtStampsGetBiz biz = new ChtStampsGetBiz(ctx);
        biz.execute();
        RestApiResponseWriter.builder(res, ctx)
            .addResultList(biz.getResult())
            .setMax(biz.getMax())
            .build().execute();
    }

    /**
     *
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @throws SQLException
     */
    @Get
    public void doGet(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtStampsGetParamModel param,
        RestApiContext ctx) throws SQLException {
        
        ChtStampDao csDao = new ChtStampDao(ctx.getCon());
        ChtStampModel stampMdl = csDao.select(param.getStampSid());
        
        if (stampMdl.getBinSid() == 0) {
            String fileDir =
                getAppRootPath() + DEFAULT_STAMP_DIR + "stamp_" + stampMdl.getCstSid() + ".png";
            File file = new File(fileDir);
        
            RestApiAttachementResponseWriter.execute(res, req, ctx, file);
        } else {
            RestApiAttachementResponseWriter.execute(res, req, ctx, stampMdl.getBinSid());
        }
    }
}
