package jp.groupsession.v2.cht.restapi.stamps;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;

import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.dao.ChtStampDao;
import jp.groupsession.v2.restapi.controller.RestApiContext;


public class ChtStampsGetBiz {
    /** APIコンテキスト*/
    RestApiContext ctx__;
    /** 取得結果*/
    List<ChtStampsGetResultModel> result__ = List.of();
    /** 取得結果件数*/
    int max__ = 0;
    /** DAO チャットスタンプ情報 */
    private ChtStampDao cstDao__;

    /**
     * コンストラクタ
     * @param ctx APIコンテキスト
     * @throws SQLException
     */
    public ChtStampsGetBiz(RestApiContext ctx) throws SQLException {
        ctx__ = ctx;
        Connection con = ctx__.getCon();
        cstDao__ = new ChtStampDao(con);
    }

    /**
     * ビジネスロジックを実行する
     * @throws SQLException
     */
    public void execute() throws SQLException {
        result__ = cstDao__.getStampSortList(GSConstChat.STAMP_USE_KBN_USE)
                    .stream()
                    .map(stamp -> {
                        ChtStampsGetResultModel ret = new ChtStampsGetResultModel();
                        ret.setSid(stamp.getCstSid());
                        ret.setSortNum(stamp.getCstSort());
                        return ret;
                    })
                    .collect(Collectors.toList());
        max__ = result__.size();
    }

    /**
     *
     * @return APIレスポンスモデル
     */
    public List<ChtStampsGetResultModel> getResult() {
        return result__;
    }

    /**
     *
     * @return 取得結果件数
     */
    public int getMax() {
        return max__;
    }
}
