package jp.groupsession.v2.cht.restapi.stamps;

import java.sql.SQLException;

import jp.groupsession.v2.cht.dao.ChtStampDao;
import jp.groupsession.v2.cht.model.ChtStampModel;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.parameter.annotation.Default;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.struts.msg.GsMessage;

@ParamModel
public class ChtStampsGetParamModel {

    /** スタンプSID */
    @Default("-1")
    private int stampSid__;

    /**
     * @return the stampSid
     */
    public int getStampSid() {
        return stampSid__;
    }

    /**
     * @param stampSid the stampSid to set
     */
    public void setStampSid(int stampSid) {
        stampSid__ = stampSid;
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {

        ChtStampDao csDao = new ChtStampDao(ctx.getCon());
        ChtStampModel stampMdl = csDao.select(stampSid__);

        if (stampMdl == null) {
            GsMessage gsMsg = new GsMessage(ctx.getRequestModel());
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_STAMP,
                    "search.data.notfound",
                    gsMsg.getMessage("cht.cht160.19")
            );
        }
    }
}
