package jp.groupsession.v2.cht.search;
/** フィルター構造*/
public class ChatMessageSearchFilter {
    /** 列挙型 フィルタータイプ*/
    public static enum EnumType {
        /** キーワード*/
        keyword,
        /** 添付ファイル*/
        attachment,
        /** 添付ファイルを含む*/
        attachmentAll,
        /** 添付ファイルを含まない*/
        attachmentLess,
        /** URL*/
        url,
        /** URLを含む*/
        urlAll,
        /** URLを含まない*/
        urlLess,
        /** ユーザ*/
        user,
        /** 所属外ユーザ*/
        outMember,
        /** 削除済みメッセージを含まない*/
        deletedLess,
        /** 特定メッセージ*/
        message,
    }

    /** フィルタータイプ*/
    private EnumType mode__;
    /** フィルター文字列*/
    private String value__;


    /**
     * @param mode
     * @param value
     */
    public ChatMessageSearchFilter(EnumType mode, String value) {
        mode__ = mode;
        value__ = value;
    }

    /**
     * インスタンス生成
     * @param str 生成文字列 {mode}:{検索文字列}
     * @return インスタンス
     */
    public static ChatMessageSearchFilter createInstance(String str) {
        int splitIdx = str.indexOf(":");
        if (splitIdx <= 0) {
            EnumType mode = EnumType.valueOf(str);
            if (mode == null) {
                mode = EnumType.keyword;
            }
            return new ChatMessageSearchFilter(mode, str);
        }
        String modeStr = str.substring(0, splitIdx);
        EnumType mode = EnumType.valueOf(modeStr);
        if (mode == null) {
            mode = EnumType.keyword;
        }
        return new ChatMessageSearchFilter(mode, str.substring(splitIdx + 1));
    }

    /**
     * @return the mode
     */
    public EnumType getMode() {
        return mode__;
    }
    /**
     * @param mode the mode to set
     */
    public void setMode(EnumType mode) {
        mode__ = mode;
    }
    /**
     * @return the value
     */
    public String getValue() {
        return value__;
    }
    /**
     * @param value the value to set
     */
    public void setValue(String value) {
        value__ = value;
    }
    @Override
    public String toString() {
        if (mode__ == EnumType.attachmentAll
            || mode__ == EnumType.attachmentLess
            || mode__ == EnumType.urlLess
            || mode__ == EnumType.urlAll
            || mode__ == EnumType.deletedLess
            ) {
            return String.format("%s:", mode__.name());
        }
        return String.format("%s:%s", mode__.name(), value__);
    }



}
