package jp.groupsession.v2.cht.search;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;

import jp.co.sjts.util.NullDefault;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.dao.ChtUserPairDao;
import jp.groupsession.v2.cht.search.position.AfterMessage;
import jp.groupsession.v2.cht.search.position.ArroundMessage;
import jp.groupsession.v2.cht.search.position.BeforeMessage;
import jp.groupsession.v2.cht.search.position.EnumPositionType;
import jp.groupsession.v2.cht.search.position.IPosition;
import jp.groupsession.v2.cht.search.position.MidokuPosition;
import jp.groupsession.v2.cht.search.position.NewestPosition;
import jp.groupsession.v2.cht.search.position.OffsetPosition;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.model.RequestModel;

public class ChatMessageSearchRequest implements Cloneable {

    /** チャット対象 */
    private final EnumTarget target__;
    /** 検索実行者 ユーザSID */
    private final int sessionUserSid__;
    /** ペアSID */
    private int chatPairSid__ = -1;
    /** チャット対象ユーザSID */
    private int chatTargetUserSid__ = -1;
    /** チャットグループSID */
    private int chatGroupSid__ = -1;
    /** 検索フィルター */
    private List<ChatMessageSearchFilter> filterList__ = List.of();
    /** ピンどめ投稿取得フラグ */
    private int targetPinKbn__ = GSConstChat.CHAT_MESSAGE_GET_ALL;
    /** 取得位置指定設定 */
    private IPosition position__ = new OffsetPosition(0);
    /** 検索結果取得件数 */
    private int limit__ = GSConstChat.CHAT_GET_MESSAGE_NUMBER;
    /** 順序 */
    private int order__ = GSConst.ORDER_KEY_ASC;


    /**
     * コンストラクタ
     * @param sessionUserSid
     * @param target
     */
    private ChatMessageSearchRequest(int sessionUserSid, EnumTarget target) {
        target__ = target;
        sessionUserSid__ = sessionUserSid;
    }

    /** 列挙型 チャット対象 */
    public static enum EnumTarget {
        /** ユーザチャット*/
        USERCHAT,
        /** グループチャット*/
        GROUPCHAT
    }

    /**
     * ユーザチャット検索モデルの生成
     * @param con
     * @param reqMdl
     * @param chatTargetUserSid チャット対象ユーザSID
     * @return ユーザチャット検索モデル
     * @throws SQLException
     */
    public static ChatMessageSearchRequest createUserChatSearchModel(
        Connection con,
        RequestModel reqMdl,
        int chatTargetUserSid) throws SQLException {
        ChatMessageSearchRequest ret = new ChatMessageSearchRequest(
            reqMdl.getSmodel().getUsrsid(),
            EnumTarget.USERCHAT
        );

        ChtUserPairDao cupDao = new ChtUserPairDao(con);
        int pairSid = cupDao.select(reqMdl.getSmodel().getUsrsid(), chatTargetUserSid);
        ret.chatPairSid__ = pairSid;
        ret.chatTargetUserSid__ = chatTargetUserSid;
        return ret;
    }

    /**
     * グループチャット検索モデルの生成
     * @param reqMdl
     * @param chatGroupSid
     * @return グループチャット検索モデルの生成
     */
    public static ChatMessageSearchRequest createGroupChatSearchModel(
        RequestModel reqMdl,
        int chatGroupSid) {
        ChatMessageSearchRequest ret = new ChatMessageSearchRequest(
            reqMdl.getSmodel().getUsrsid(),
            EnumTarget.GROUPCHAT

        );
        ret.chatGroupSid__ = chatGroupSid;
        return ret;
    }
    /**
     * @return the filterList
     */
    public List<ChatMessageSearchFilter> getFilterList() {
        return filterList__;
    }
    /**
     * @param filterList the filterList to set
     */
    public void setFilterList(List<ChatMessageSearchFilter> filterList) {
        filterList__ = filterList;
    }
    /**
     * @return the position
     */
    public IPosition getPosition() {
        return position__;
    }
    /**
     * @param position the position to set
     */
    public void setPosition(IPosition position) {
        position__ = position;
    }
    /**
     * <p> 取得位置指定を行う
     * <p> 取得位置指定文字列は以下のフォーマット
     * <p> ${EnumPositionType.name}:${位置指定タイプごとの指定値}
     *
     * @param positionStr the position to set
     */
    public void setPositionStr(String positionStr) {
        int spidx = positionStr.indexOf(":");
        String code = positionStr;
        if (spidx >= 0) {
            code = positionStr.substring(0, spidx);
            spidx++;
        }
        EnumPositionType codeEnum = EnumPositionType.valueOf(code);
        if (codeEnum == null) {
            return;
        }
        switch (codeEnum) {
            case ARROUND_MESSAGE:
                position__ = new ArroundMessage(
                    NullDefault.getInt(
                        positionStr.substring(spidx),
                        -1)
                );
                break;
            case AFTER_MESSAGE:
                position__ = new AfterMessage(
                    NullDefault.getInt(
                        positionStr.substring(spidx),
                        -1)
                );
                break;
            case BEFORE_MESSAGE:
                position__ = new BeforeMessage(
                    NullDefault.getInt(
                        positionStr.substring(spidx),
                        -1)
                );
            case OFFSET:
                position__ = new OffsetPosition(
                    NullDefault.getInt(
                        positionStr.substring(spidx),
                        -1));
                break;
            case NEWEST:
                position__ = new NewestPosition();
                break;
            case MIDOKUSTART:
                position__ = new MidokuPosition();
                break;
            default:
        }       return;
    }

    /**
     * @return the targetPinKbn
     */
    public int getTargetPinKbn() {
        return targetPinKbn__;
    }

    /**
     * @param targetPinKbn the targetPinKbn to set
     */
    public void setTargetPinKbn(int targetPinKbn) {
        targetPinKbn__ = targetPinKbn;
    }

    /**
     * @return the limit
     */
    public int getLimit() {
        return limit__;
    }

    /**
     * @param limit the limit to set
     */
    public void setLimit(int limit) {
        limit__ = limit;
    }

    /**
     * @return the order
     */
    public int getOrder() {
        return order__;
    }

    /**
     * @param order the order to set
     */
    public void setOrder(int order) {
        order__ = order;
    }

    /**
     * @return the target
     */
    public EnumTarget getTarget() {
        return target__;
    }

    /**
     * @return the chatPairSid
     */
    public int getChatPairSid() {
        return chatPairSid__;
    }

    /**
     * @return the chatTargetUserSid
     */
    public int getChatTargetUserSid() {
        return chatTargetUserSid__;
    }

    /**
     * @return the chatGroupSid
     */
    public int getChatGroupSid() {
        return chatGroupSid__;
    }

    /**
     * @return the sessionUserSid
     */
    public int getSessionUserSid() {
        return sessionUserSid__;
    }

    @Override
    protected ChatMessageSearchRequest clone() {
        ChatMessageSearchRequest ret;
        ret = new ChatMessageSearchRequest(
            this.sessionUserSid__,
            this.getTarget()
        );
        ret.chatGroupSid__ = chatGroupSid__;
        ret.chatPairSid__ = chatPairSid__;
        ret.chatTargetUserSid__ = chatTargetUserSid__;
        try {
            BeanUtils.copyProperties(ret, this);
        } catch (Exception e) {
            throw new RuntimeException("検索パラメータのコピーに失敗");
        }
        return ret;
    }



}
