package jp.co.sjts.util;

import java.io.UnsupportedEncodingException;
import java.util.List;

import jp.groupsession.v2.cmn.DBUtilFactory;
import jp.groupsession.v2.cmn.GSConst;

/**
 * <br>[機  能] データ使用量に関するユーティリティクラス
 * <br>[解  説]
 * <br>[備  考]
 * @author JTS
 */
public class DataSizeUtil {

    /** 文字タイプ　UTF-8 */
    private static final String CHARTYPE_UTF8 = "UTF-8";

    /**
     * 指定された文字列のデータ使用量を計算します
     * <br>postgres  :UTF-8でのバイト数<br>
     * <br>H2Database:文字数×2バイト<br>
     * @param contents 使用量計算対象の文字列
     * @return 使用量(byte)
     */
    public static long getUseDBsize(String... contents) throws UnsupportedEncodingException {
        long useDBsize = 0;
        switch (DBUtilFactory.getInstance().getDbType()) {
            case GSConst.DBTYPE_POSTGRES:
                for (String content : contents) {
                    if (content == null) {
                        continue;
                    }
                    useDBsize += content.getBytes(CHARTYPE_UTF8).length;
                }
                break;
            case GSConst.DBTYPE_H2DB:
                for (String content : contents) {
                    if (content == null) {
                        continue;
                    }
                    useDBsize += content.length() * 2;
                }
                break;
            default:
                break;
        }
        return useDBsize;
    }

        /**
     * 指定された文字列のデータ使用量を計算します
     * <br>postgres  :UTF-8でのバイト数<br>
     * <br>H2Database:文字数×2バイト<br>
     * @param contents 使用量計算対象の文字列
     * @return 使用量(byte)
     */
    public static long getUseDBsize(List<String> contents) throws UnsupportedEncodingException {
        long useDBsize = 0;
        switch (DBUtilFactory.getInstance().getDbType()) {
            case GSConst.DBTYPE_POSTGRES:
                for (String content : contents) {
                    if (content == null) {
                        continue;
                    }
                    useDBsize += content.getBytes(CHARTYPE_UTF8).length;
                }
                break;
            case GSConst.DBTYPE_H2DB:
                for (String content : contents) {
                    if (content == null) {
                        continue;
                    }
                    useDBsize += content.length() * 2;
                }
                break;
            default:
                break;
        }
        return useDBsize;
    }
}
