package jp.groupsession.v2.cmn;

import java.sql.Connection;
import java.sql.SQLException;

import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.model.RequestModel;

/**
 * <br>[機  能] 役職に変更があった場合に実行されるリスナー
 * <br>[解  説]
 * <br>[備  考] DBのコミット、ロールバック処理は各自実行すること。
 *
 * @author  JTS
 */
public interface IPositionListener {

    /**
     * <p>役職削除時に実行される
     * @param con DBコネクション
     * @param cntCon 採番コントローラ
     * @param reqMdl リクエスト情報
     * @param posSid 役職SID
     * @param eusid 更新者ユーザSID
     * @throws SQLException SQL実行例外
     */
    public void deletePosition(
        Connection con, MlCountMtController cntCon,
        RequestModel reqMdl, int posSid, int eusid) throws Exception;
}
