package jp.groupsession.v2.cmn;

import jp.groupsession.v2.cmn.config.PluginConfig;

/**
 * <br>[機  能] jp.groupsession.v2.cmn.IPositionListenerについてのユーティリティークラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class PositionListenerUtil {

    /**
     * <p>プラグイン設定ファイルより役職リスナー実装クラスのリストを返す
     * @param pconfig プラグイン設定
     * @throws ClassNotFoundException 指定されたリスナークラスが存在しない
     * @throws IllegalAccessException リスナー実装クラスのインスタンス生成に失敗
     * @throws InstantiationException リスナー実装クラスのインスタンス生成に失敗
     * @return 役職リスナー
     */
    public static IPositionListener[] getPositionListeners(PluginConfig pconfig)
            throws ClassNotFoundException, IllegalAccessException,
            InstantiationException {

        String[] gsListenerClass = pconfig.getPositionListeners();
        IPositionListener[] lis = getPositionListeners(gsListenerClass);
        return lis;
    }

    /**
     * <p>リスナー名より役職リスナー実装クラスのリストを返す
     * @param listenerClass 役職リスナー実装クラス
     * @throws ClassNotFoundException 指定されたリスナークラスが存在しない
     * @throws IllegalAccessException リスナー実装クラスのインスタンス生成に失敗
     * @throws InstantiationException リスナー実装クラスのインスタンス生成に失敗
     * @return 役職リスナー
     */
    private static IPositionListener[] getPositionListeners(String[] listenerClass)
        throws ClassNotFoundException, IllegalAccessException, InstantiationException {

        IPositionListener[] lis = new IPositionListener[listenerClass.length];
        for (int i = 0; i < listenerClass.length; i++) {
            lis[i] = (IPositionListener) Class.forName(listenerClass[i]).newInstance();
        }

        return lis;
    }
}
