package jp.groupsession.v2.cmn.biz;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;

import jp.groupsession.v2.cmn.model.ActionMessageModel;

/**
 * <br>[機  能] ActionErrorsからエラーのkeyとvalueを取得する処理を行うクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class ActionMessageBiz {

    /**
     *
     * <br>[機  能] ActionErrorsからエラーメッセージのkey/value取得
     * <br>[解  説]
     * <br>[備  考] APIのレスポンスにJIS第2水準以外の文字を含めるとレスポンスが出力されないため、その文字列はレスポンスに含めない
     * @param errors アクションエラー
     * @return エレメント
     */
    public List<ActionMessageModel> getMessageKeyValue(ActionErrors errors) {
        List<ActionMessageModel> ret = new  ArrayList<ActionMessageModel>();
        @SuppressWarnings("unchecked")
        Iterator<ActionMessage> iterator = errors.get();
        while (iterator.hasNext()) {
            ActionMessage message = ((ActionMessage) iterator.next());
            ActionMessageModel messageModel = new ActionMessageModel();

            String messageKey = null;
            if (Objects.equals(message.getKey(), "error.input.njapan.text")) {
                // JIS第2水準以外の文字を含むエラーの場合は、対象の文字列がレスポンスに含まれないようメッセージキーを変更する
                messageKey = "error.input.njapan.text3";
            } else {
                messageKey = message.getKey();
            }

            messageModel.setKey(messageKey);
            messageModel.setValues(message.getValues());
            ret.add(messageModel);
        }
        return ret;
    }
}
