package jp.groupsession.v2.cmn.biz;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtil;
import jp.groupsession.v2.cmn.GsSettingConfigBundle;

/**
 * <br>[機  能] gsSetting.confの設定値を取得するビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class GsSettingBiz {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(GsSettingBiz.class);


    /**
     * <br>[機  能] WEBメール設定ファイルの設定値を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param appRootPath アプリケーションルートパス
     * @param confKey 設定値のキー
     * @param defValue デフォルト値
     * @return 設定値
     */
    public static synchronized int getConfValue(String appRootPath, String confKey, int defValue) {
        String confValue = GsSettingConfigBundle.getValue(confKey);
        if (StringUtil.isNullZeroString(confValue)) {
            try {
                GsSettingConfigBundle.readConfig(appRootPath);
                confValue = GsSettingConfigBundle.getValue(confKey);
            } catch (IOException e) {
                log__.error("gsSetting.confファイルの読み込みに失敗", e);
            }
        }
        return NullDefault.getInt(confValue, defValue);
    }
    
}
