package jp.groupsession.v2.cmn.biz.apiconnect;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.lang3.RandomStringUtils;
import org.jdom2.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import jp.co.sjts.util.StringUtil;
import jp.groupsession.v2.cmn.cmn340.Cmn340JsonModel;
import jp.groupsession.v2.cmn.http.HttpResponseModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectParamModel;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 連携API関連ビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class ApiConnectBiz {

    /**
     * <br>[機  能] URLからパスパラメータ名を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param urlText URL
     * @return URL内に記載されているパスパラメータ一覧
     */
    public List<String> getPathParameterName(String urlText) {

        List<String> ret = new ArrayList<>();
        Pattern pattern = Pattern.compile("\\$\\{.+?\\}");
        String targetText = urlText;
        int questionIdx = urlText.indexOf("?");
        if (questionIdx > -1) {
            targetText = urlText.substring(0, questionIdx);
        }
        Matcher matcher = pattern.matcher(targetText);

        while (matcher.find()) {
            String text = matcher.group(0);
            //${aaa}のような形式からaaaだけを取り出す
            ret.add(text.substring(2, text.length() - 1));
        }
        return ret;
    }

    /**
     * <br>[機  能] URLからクエリパラメータ名を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param urlText URL
     * @return URL内に記載されているパスパラメータ一覧
     */
    public List<String> getQueryParameterName(String urlText) {

        List<String> ret = new ArrayList<>();
        int questionIdx = urlText.indexOf("?");
        if (questionIdx == -1) {
            return ret;
        }

        Pattern pattern = Pattern.compile("(.*?)=\\$\\{\\1\\}");
        String targetText = urlText.substring(questionIdx);
        Matcher matcher = pattern.matcher(targetText);

        while (matcher.find()) {
            ret.add(matcher.group(1));
        }
        return ret;
    }

    /**
     * <br>[機  能] リクエストボディに記載されている順序でパラメータを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param bodyParamList ボディパラメータ一覧
     * @param reqBody リクエストボディ
     * @param contentKbn コンテントタイプ
     * @return リクエストボディに記載されている順序で格納したリクエストボディ
     * @throws ParserConfigurationException
     * @throws SAXException
     * @throws IOException
     * @throws JDOMException
     */
    public TreeMap<Integer, CmnApiConnectParamModel> getBodyMap(
        List<CmnApiConnectParamModel> bodyParamList,
        String reqBody,
        int contentKbn)
        throws ParserConfigurationException, SAXException, IOException, JDOMException {

        TreeMap<Integer, CmnApiConnectParamModel> bodyParamMap = new TreeMap<>();
        AtomicInteger paramIdx = new AtomicInteger(1);
        if (bodyParamList != null && !bodyParamList.isEmpty()) {
            if (contentKbn == EnumContentType.MULTIPART_FORM_DATA.getValue()) {
                Pattern pattern = Pattern.compile(" name=.+?(\\r\\n|;)");
                Matcher matcher = pattern.matcher(reqBody);
                AtomicInteger count = new AtomicInteger(1);
                while (matcher.find()) {
                    String valiableName = matcher.group().substring(6);
                    if (Objects.equals(matcher.group(1), ";")) {
                        valiableName = valiableName.substring(0, valiableName.length() - 1);
                    } else {
                        valiableName = valiableName.substring(0, valiableName.length() - 2);
                    }
                    for (CmnApiConnectParamModel mdl : bodyParamList) {
                        if (Objects.equals(valiableName, mdl.getCacpName())) {
                            bodyParamMap.put(count.getAndIncrement(), mdl);
                            break;
                        }
                    }
                }
            } else {
                List<Cmn340JsonModel> bodyParam = getParamList(reqBody, contentKbn);

                for (Cmn340JsonModel body : bodyParam) {
                    for (CmnApiConnectParamModel mdl : bodyParamList) {
                        if (Objects.equals(body.getParamName(), mdl.getCacpName())) {
                            bodyParamMap.put(paramIdx.getAndIncrement(), mdl);
                            break;
                        }
                    }
                    if (body.getChild() != null) {
                        for (Cmn340JsonModel child : body.getChild()) {
                            for (CmnApiConnectParamModel mdl : bodyParamList) {
                                if (Objects.equals(
                                    body.getParamName() + "." + child.getParamName(),
                                    mdl.getCacpName())) {
                                    bodyParamMap.put(paramIdx.getAndIncrement(), mdl);
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }
        return bodyParamMap;
    }

    /**
     * <br>[機  能] リクエストボディからパラメータ一覧を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param reqBody リクエストボディ
     * @param contentType データ方式
     * @return ret パス
     * @throws JDOMException
     * @throws IOException
     * @throws SAXException
     * @throws ParserConfigurationException
     * @throws UnsupportedEncodingException
     */
    public List<Cmn340JsonModel> getParamList(String reqBody, int contentType)
        throws ParserConfigurationException, SAXException, IOException, JDOMException  {

        List<Cmn340JsonModel> paramList = new ArrayList<Cmn340JsonModel>();
        if (StringUtil.isNullZeroString(reqBody)) {
            return paramList;
        }

        if (contentType == EnumContentType.MANUAL.getValue()) {
            paramList = __getManualParam(reqBody);
            return paramList;
        }
        if (contentType == EnumContentType.APPLICATION_FORM.getValue()) {
            paramList = __getFormParam(reqBody);
            return paramList;
        }

        //パラメータ文字列${何かしらの文字}を""に置き換える
        String targetText = reqBody;
        String okikae = "";
        if (contentType == EnumContentType.APPLICATION_JSON.getValue()) {
            //置き換え用の文字列を作成(先頭に0がある場合にJSON内で自動で省かれるため0は全て1に変換)
            okikae = RandomStringUtils.randomNumeric(8).replaceAll("0", "1");
            while (targetText.contains(okikae)) {
                okikae = RandomStringUtils.randomNumeric(8).replaceAll("0", "1");
            }
        } else {
            okikae = RandomStringUtils.randomAlphabetic(8);
            while (targetText.contains(okikae)) {
                okikae = RandomStringUtils.randomAlphabetic(8);
            }
        }
        String regex = "\\$\\{.+?\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(targetText);
        Set<String> resultSet = new HashSet<String>();
        while (matcher.find()) {
            resultSet.add(matcher.group());
        }

        final AtomicInteger count = new AtomicInteger(1);
        Map<String, String> okikaeMap = new HashMap<>();
        for (String replaceTarget : resultSet) {
            String okikaeWithCount = okikae + count.getAndIncrement();
            okikaeMap.put(okikaeWithCount,
                replaceTarget.substring(2, replaceTarget.length() - 1));
            targetText = targetText.replace(replaceTarget, okikaeWithCount);
        }
        if (contentType == EnumContentType.APPLICATION_JSON.getValue()) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(targetText);
            paramList = __getJsonModel(node, okikae, okikaeMap, null);
        } else if (contentType == EnumContentType.TEXT_XML.getValue()
            || contentType == EnumContentType.APPLICATION_XML.getValue()) {
            paramList = __getXmlModel(targetText, okikae, okikaeMap, null);
        }
        return paramList;
    }

    /**
     * <br>[機  能] 対象の文字列からJSONパラメータ一覧を作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param node JSON要素
     * @param okikae 変数名置き換え用文字列
     * @param okikaeMap 変数名置き換え情報保持マップ
     * @param parentMdl 親パラメータ情報
     * @return JSONパラメータ一覧
     * @throws JsonProcessingException
     * @throws JsonMappingException
     */
    private List<Cmn340JsonModel> __getJsonModel(
        JsonNode node, String okikae, Map<String, String> okikaeMap,
        Cmn340JsonModel parentMdl) throws JsonMappingException, JsonProcessingException {
        List<Cmn340JsonModel> paramList = new ArrayList<>();

        Iterator<Map.Entry<String, JsonNode>> fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry<String, JsonNode> entry = fields.next();
            JsonNode childNode = entry.getValue();
            if (childNode.isObject()) {
                //モデル構造
                Cmn340JsonModel jsonMdl = new Cmn340JsonModel();
                jsonMdl.setParamName(entry.getKey());
                paramList.addAll(
                    __getJsonModel(childNode, okikae, okikaeMap, jsonMdl));
            } else {
                //ただのパラメータ
                String valueText = childNode.asText();
                String regex = okikae + "\\d+";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(valueText);
                while (matcher.find()) {
                    String okikaeName = matcher.group();
                    String valiableName = okikaeMap.get(okikaeName);
                    Cmn340JsonModel jsonMdl = new Cmn340JsonModel();
                    jsonMdl.setParamName(valiableName);
                    jsonMdl.setChild(null);
                    if (parentMdl == null) {
                        paramList.add(jsonMdl);
                    } else {
                        parentMdl.getChild().add(jsonMdl);
                    }
                }
            }

        }

        if (parentMdl != null && parentMdl.getChild() != null && !parentMdl.getChild().isEmpty()) {
            paramList.add(parentMdl);
        }
        return paramList;
    }

    /**
     * <br>[機  能] 対象の文字列からXMLパラメータ一覧を作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param targetStr 対象文字列
     * @param okikae 変数名置き換え用文字列
     * @param okikaeMap 変数名置き換え情報保持マップ
     * @param parentMdl 親パラメータ情報
     * @return XMLパラメータ一覧
     * @throws ParserConfigurationException
     * @throws IOException
     * @throws SAXException
     */
    private static List<Cmn340JsonModel> __getXmlModel(
        String targetStr, String okikae, Map<String,
        String> okikaeMap, Cmn340JsonModel parentMdl)
        throws ParserConfigurationException, SAXException, IOException {
        List<Cmn340JsonModel> paramList = new ArrayList<>();

        //第一階層のパラメータを解析
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        targetStr = targetStr.trim();
        InputSource is = new InputSource(new StringReader(targetStr));
        Document doc = dBuilder.parse(is);
        Element root = doc.getDocumentElement();

        String regex = okikae + "\\d+";
        Pattern pattern = Pattern.compile(regex);
        NodeList nodeList = root.getChildNodes();
        for (int idx = 0; idx < nodeList.getLength(); idx++) {
            Node node = nodeList.item(idx);
            if (node.getNodeType() == Node.TEXT_NODE) {
                String text = node.getTextContent();
                Matcher matcher = pattern.matcher(text);
                if (matcher.find()) {
                    Cmn340JsonModel mdl = new Cmn340JsonModel();
                    mdl.setParamName(okikaeMap.get(matcher.group()));
                    paramList.add(mdl);
                }
                continue;
            }

            NodeList childNodeList = node.getChildNodes();
            Cmn340JsonModel mdl = new Cmn340JsonModel();
            boolean isTextNode = false;
            for (int childIdx = 0; childIdx < childNodeList.getLength(); childIdx++) {
                Node childNode = childNodeList.item(childIdx);
                if (childNode.getNodeType() == Node.TEXT_NODE) {
                    String text = childNode.getTextContent();
                    Matcher matcher = pattern.matcher(text);
                    if (matcher.find()) {
                        mdl.setParamName(okikaeMap.get(matcher.group()));
                        isTextNode = true;
                    }
                } else if (childNode.getNodeType() == Node.ELEMENT_NODE) {
                    mdl.setParamName(node.getNodeName());
                    NodeList magoNodeList = childNode.getChildNodes();
                    for (int magoIdx = 0; magoIdx < magoNodeList.getLength(); magoIdx++) {
                        Node magoNode = magoNodeList.item(magoIdx);
                        String text = magoNode.getTextContent();
                        Matcher matcher = pattern.matcher(text);
                        if (matcher.find()) {
                            Cmn340JsonModel child = new Cmn340JsonModel();
                            child.setParamName(okikaeMap.get(matcher.group()));
                            mdl.getChild().add(child);
                        }
                    }
                }
            }
            //子要素が変数名を含むテキストノード，もしくは変数名を含む孫要素が存在する際に要素を追加
            if (isTextNode || !mdl.getChild().isEmpty()) {
                paramList.add(mdl);
            }
        }
        return paramList;
    }

    /**
     * <br>[機  能] 対象の文字列からurlform-encodedパラメータ一覧を作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param targetStr 対象文字列
     * @return urlformパラメータ一覧
     */
    private List<Cmn340JsonModel> __getFormParam(String targetStr) {

        List<Cmn340JsonModel> ret = new ArrayList<>();
        //変数名=${変数名}となっている箇所を抽出
        Pattern pattern = Pattern.compile("(.*?)=\\$\\{\\1\\}");
        Matcher matcher = pattern.matcher(targetStr);
        while (matcher.find()) {
            Cmn340JsonModel jsonMdl = new Cmn340JsonModel();
            jsonMdl.setParamName(matcher.group(1));
            jsonMdl.setChild(null);
            ret.add(jsonMdl);
        }
        return ret;
    }

    /**
     * <br>[機  能] 対象の文字列から手入力で入力されたパラメータ一覧を作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param targetStr 対象文字列
     * @return パラメータ一覧
     */
    private List<Cmn340JsonModel> __getManualParam(String targetStr) {

        List<Cmn340JsonModel> ret = new ArrayList<>();
        String regex = "\\$\\{.+?\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(targetStr);
        while (matcher.find()) {
            Cmn340JsonModel jsonMdl = new Cmn340JsonModel();
            String text = matcher.group();
            jsonMdl.setParamName(text.substring(2, text.length() - 1));
            jsonMdl.setChild(null);
            ret.add(jsonMdl);
        }
        return ret;
    }

    /**
     * <br>[機  能] API実行結果モデルから、表示用の実行結果文字列を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param resMdl API実行結果モデル
     * @param reqMdl リクエストモデル
     * @return パラメータ一覧
     */
    public String getApiResultText(HttpResponseModel resMdl, RequestModel reqMdl) {

        GsMessage gsMsg = new GsMessage(reqMdl);
        StringBuilder sb = new StringBuilder();
        sb.append(gsMsg.getMessage("cmn.cmn340.69"));
        sb.append(":");
        sb.append(resMdl.getStatusCode());
        sb.append("\r\n");

        Map<String, List<String>> resHeader = resMdl.getHeader();
        if (resHeader != null) {
            for (Map.Entry<String, List<String>> entry : resHeader.entrySet()) {
                sb.append(entry.getKey());
                sb.append(":");
                if (entry.getValue() != null) {
                    for (String value : entry.getValue()) {
                        sb.append(" ");
                        sb.append(value);
                    }
                }
                sb.append("\r\n");
            }
        }
        sb.append(resMdl.getBody());
        return sb.toString();
    }
}
