package jp.groupsession.v2.cmn.biz.apiconnect;

import java.io.IOException;
import java.sql.SQLException;


import jp.co.sjts.util.encryption.EncryptionException;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.GSContext;
import jp.groupsession.v2.cmn.GroupSession;
import jp.groupsession.v2.cmn.biz.GsSettingBiz;
import jp.groupsession.v2.cmn.http.HttpOperation;
import jp.groupsession.v2.cmn.http.HttpPart;
import jp.groupsession.v2.cmn.http.HttpRequestModel;
import jp.groupsession.v2.cmn.http.HttpResponseModel;

import java.util.Objects;

import java.util.Map;
import java.util.List;

/**
 * <br>[機  能] 連携API実行クラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class ApiExecuter {

    /** URL */
    private String url__ = null;
    /** リクエストメソッド */
    private int reqMethod__ = 0;
    /** リクエストヘッダ */
    private Map<String, String> reqHeader__ = null;
    /** Content-Type */
    private String contentType__ = null;
    /** Part一覧(multipart用) */
    private List<HttpPart> partList__ = null;
    /** リクエストボディ */
    private String reqBody__ = null;

    /**
     * @return the url
     */
    public String getUrl() {
        return url__;
    }
    /**
     * @return the reqMethod
     */
    public int getReqMethod() {
        return reqMethod__;
    }
    /**
     * @return the reqHeader
     */
    public Map<String, String> getReqHeader() {
        return reqHeader__;
    }
    /**
     * @return the contentType
     */
    public String getContentType() {
        return contentType__;
    }
    /**
     * @return the partList
     */
    public List<HttpPart> getPartList() {
        return partList__;
    }
    /**
     * @return the reqBody
     */
    public String getReqBody() {
        return reqBody__;
    }

    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param url
     * @param reqMethod
     * @param reqHeader
     * @param contentType
     * @param partList
     * @param reqBody
     */
    public ApiExecuter(String url, int reqMethod,
        Map<String, String> reqHeader, String contentType,
        List<HttpPart> partList, String reqBody) {
        url__ = url;
        reqMethod__ = reqMethod;
        reqHeader__ = reqHeader;
        contentType__ = contentType;
        partList__ = partList;
        reqBody__ = reqBody;
    }


    /**
     * <br>[機  能] 接続テストを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @return レスポンス情報
     * @throws EncryptionException
     * @throws SQLException
     * @throws IOException
     * @throws InterruptedException
     */
    public HttpResponseModel execute() throws EncryptionException,
        SQLException, IOException, InterruptedException {

        //タイムアウトを読み込む
        String appRootPath = (String) GroupSession.getContext().get(GSContext.APP_ROOT_PATH);
        int timeout = GsSettingBiz.getConfValue(
            appRootPath, "CONNECT_API_TIMEOUT", GSConst.CONNECT_API_DEFAULT_TIMEOUT);
        HttpOperation operation = new HttpOperation(null, timeout, timeout);

        HttpRequestModel httpReqMdl = new HttpRequestModel();

        if (Objects.equals(contentType__, EnumContentType.MULTIPART_FORM_DATA.getLabel())) {
            httpReqMdl.setMultipartFlg(true);
            httpReqMdl.setPartList(partList__);
            if (partList__ == null || partList__.isEmpty()) {
                httpReqMdl.setBodyString("");
            }
        } else {
            httpReqMdl.setBodyString(reqBody__);
        }
        httpReqMdl.setHeader(reqHeader__);
        if (reqMethod__ == EnumMethod.POST.getValue()
            || reqMethod__ == EnumMethod.PUT.getValue()
            || reqMethod__ == EnumMethod.PATCH.getValue()) {
            httpReqMdl.setContentType(contentType__);
        }

        HttpResponseModel resMdl = operation.sendRequest(url__, httpReqMdl, reqMethod__);

        return resMdl;
    }
}
