package jp.groupsession.v2.cmn.cmn330;

import java.sql.Connection;
import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import jp.co.sjts.util.NullDefault;
import jp.groupsession.v2.struts.AdminAction;
/**
 *
 * <br>[機  能] 連携API管理 Actionクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Cmn330Action extends AdminAction {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(Cmn330Action.class);

    @Override
    public ActionForward executeAction(ActionMapping map, ActionForm form,
            HttpServletRequest req, HttpServletResponse res, Connection con)
            throws Exception {
        log__.debug("START");

        ActionForward forward = null;
        Cmn330Form thisForm = (Cmn330Form) form;

        String cmd = NullDefault.getString(req.getParameter("CMD"), "");

        if (cmd.equals("cmn330add")) {
            //追加ボタン押下時
            forward = map.findForward("add");
        } else if (cmd.equals("cmn330Back")) {
            //戻るボタン押下時
            forward = map.findForward("gf_main_kanri");
        } else if (cmd.equals("cmn330edit")) {
            //リンク押下時（編集時）
            forward = map.findForward("edit");
        } else {
            //初期表示
            forward = __doInit(map, thisForm, req, res, con);
        }

        return forward;
    }
    /**
     * <br>[機  能] 初期表示
     * <br>[解  説]
     * <br>[備  考]
     * <br>
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @return アクションフォーワード
     * @throws SQLException SQL実行時例外
     */
    private ActionForward __doInit(ActionMapping map, Cmn330Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con) throws SQLException {

        con.setAutoCommit(true);
        Cmn330ParamModel param = new Cmn330ParamModel();
        param.setParam(form);
        Cmn330Biz cmn330Biz = new Cmn330Biz(con);

        cmn330Biz.setInitData(param);
        param.setFormData(form);

        return map.getInputForward();
    }

}
