package jp.groupsession.v2.cmn.cmn330;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;

import jp.groupsession.v2.cmn.dao.base.CmnApiConnectDao;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectModel;
/**
 *
 * <br>[機  能] 連携API管理 Bizクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Cmn330Biz {
    /** コネクション */
    private Connection con__;
    /**
     *
     * コンストラクタ
     * @param con コネクション
     */
    public Cmn330Biz(Connection con) {
        con__ = con;
    }
    /**
     *
     * <br>[機  能] 初期描画設定
     * <br>[解  説]
     * <br>[備  考]
     * @param param
     * @throws SQLException SQL実行時例外
     */
    public void setInitData(Cmn330ParamModel param) throws SQLException {
        CmnApiConnectDao dao = new CmnApiConnectDao(con__);
        List<CmnApiConnectModel> apiList = dao.selectExist();
        param.setCmn330ApiList(apiList);

        List<CmnApiConnectModel> errorApiList = dao.selectVersionErrorApi();
        List<Integer> errorApiSidList = errorApiList.stream()
            .map(CmnApiConnectModel::getCacSid)
            .collect(Collectors.toList());
        param.setCmn330ErrorApiSidList(errorApiSidList);
    }

}
