package jp.groupsession.v2.cmn.cmn340;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;
import org.jdom2.JDOMException;
import org.xml.sax.SAXException;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtilHtml;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.json.JSONArray;
import jp.co.sjts.util.json.JSONObject;
import jp.co.sjts.util.json.util.JSONUtils;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.GSConstLog;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.biz.apiconnect.ApiConnectBiz;
import jp.groupsession.v2.cmn.biz.apiconnect.EnumContentType;
import jp.groupsession.v2.cmn.cmn999.Cmn999Form;
import jp.groupsession.v2.cmn.config.PluginConfig;
import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectParamModel;
import jp.groupsession.v2.struts.AdminAction;
import jp.groupsession.v2.struts.msg.GsMessage;
/**
 *
 * <br>[機  能] 連携API登録 Actionクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Cmn340Action extends AdminAction {
    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(Cmn340Action.class);

    /** テンポラリディレクトリ */
    private static final String TEMP_DIRECTORY_ID = "cmn340";

    @Override
    public ActionForward executeAction(ActionMapping map, ActionForm thisForm,
            HttpServletRequest req, HttpServletResponse res, Connection con)
            throws Exception {
        log__.debug("START");

        ActionForward forward = null;

        String cmd = NullDefault.getString(req.getParameter("CMD"), "");
        Cmn340Form form = (Cmn340Form) thisForm;

        forward = __immigration(map, form, req, res, con);
        if (forward != null) {
            return forward;
        }
        if (cmd.equals("cmn340Decision")) {
            //確定ボタン押下時
            forward = __doDecision(map, form, req, res, con);

        } else if (cmd.equals("cmn340Ok")) {
            //登録ボタン押下時
            __doOk(map, form, req, res, con);

        } else if (cmd.equals("cmn340Back")) {
            //戻るボタン押下時
            forward = map.findForward("cmn330");

        } else if (cmd.equals("cmn340DeleteComp")) {
            //削除確認 OKボタンクリック時
            forward = __doDeleteComp(map, form, req, res, con);

        } else if (cmd.equals("cmn340Test")) {
            //接続確認 ボタンクリック時
            forward = __openTestDialog(map, form, req, res, con);

        } else if (cmd.equals("cmn340TestDo")) {
            //接続確認 実行ボタンクリック時
            forward = __doTest(map, form, req, res, con);

        } else if (cmd.equals("cmn340GetBodyParam")) {
            //リクエストボディからパラメータを生成ボタン押下
            forward = __doGetBodyParam(map, form, req, res, con);

        } else if (cmd.equals("cmn340ReflectGsApi")) {
            //GroupSession APIを反映
            forward = __doReflectGsApi(map, form, req, res, con);
        } else {
            //初期表示
            forward = __doInit(map, form, req, res, con);
        }

        return forward;
    }
    /**
     * 
     * <br>[機  能] 接続確認 ボタンクリック処理
     * <br>[解  説]
     * <br>[備  考]
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @return アクションフォーワード
     * @throws SQLException SQL実行時例外
     * @throws ClassNotFoundException WEB APIクラスが存在しない
     * @throws IOException WEB API設定ファイルの取得に失敗
     * @throws IOToolsException 
     */
    private ActionForward __openTestDialog(ActionMapping map, Cmn340Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con)
        //throws SQLException, ClassNotFoundException, IOException, IOToolsException {
            throws Exception {
        //入力チェック
        RequestModel reqMdl = getRequestModel(req);
        ActionErrors errors = form.validateCheck(
            reqMdl, con,
            getPluginConfig(req),
            getAppRootPath(), false);
        if (!errors.isEmpty()) {
            addErrors(req, errors);
            ActionForward forward = __doInit(map, form, req, res, con);
            return forward;
        }
        ActionForward forward = __doInit(map, form, req, res, con);
        form.setCmn340TestDialogFlg(true);

        if (form.getCmn340CacContent() == EnumContentType.MULTIPART_FORM_DATA.getValue()) {
            //テンポラリディレクトリの削除
            GSTemporaryPathUtil temp = GSTemporaryPathUtil.getInstance();
            temp.deleteTempPath(reqMdl, GSConst.PLUGINID_COMMON, TEMP_DIRECTORY_ID);

            //テンポラリディレクトリの生成
            AtomicInteger num = new AtomicInteger(1);
            for (Map.Entry<Integer, CmnApiConnectParamModel> entry
                : form.getCmn340BodyParamMap().entrySet()) {
                if (entry.getValue().getCacpParamType() == GSConstCommon.PARAM_TYPE_FILE) {
                    temp.createTempDir(getRequestModel(req), GSConst.PLUGINID_COMMON,
                        TEMP_DIRECTORY_ID, String.valueOf(num.getAndIncrement()));
                }
            }
        } else {
            form.setCmn340TestBody(StringUtilHtml.transToHTml(form.getCmn340CacBody()));
        }
        return forward;
    }

    /**
     *
     * <br>[機  能] 接続確認 実行ボタン処理
     * <br>[解  説] JSON型のレスポンスを返す
     * <br>[備  考]
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @return アクションフォーワード
     * @throws Exception 実行例外
     */
    private ActionForward __doTest(ActionMapping map, Cmn340Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con) throws Exception {
        //入力チェック
        ActionErrors errors = form.validateCheck(
            getRequestModel(req), con,
            getPluginConfig(req),
            getAppRootPath(), false);
        if (!errors.isEmpty()) {
            addErrors(req, errors);
            return __doInit(map, form, req, res, con);
        }

        RequestModel reqMdl = getRequestModel(req);
        Cmn340Biz biz = new Cmn340Biz(reqMdl, con);
        Cmn340ParamModel param = new Cmn340ParamModel();
        param.setParam(form);

        //外部接続前にDBコネクションを破棄
        JDBCUtil.closeConnection(con);

        String result = biz.doTest(getRequestModel(req), param);
        JSONObject jsonData = new JSONObject();

        jsonData.element("success", true);
        String responce = result;

        if (JSONUtils.mayBeJSON(responce)) {
            jsonData.element("responce", JSONUtils.quote(responce));
        } else {
            jsonData.element("responce", responce);
        }

        PrintWriter out = null;

        try {
            res.setHeader("Cache-Control", "no-cache");
            res.setContentType("application/json;charset=UTF-8");
            out = res.getWriter();
            out.print(jsonData);
            out.flush();
        } catch (Exception e) {
            log__.error("jsonデータ送信失敗(接続テストデータ)");
        } finally {
            if (out != null) {
                out.close();
            }
        }

        return null;
    }

    /**
     * <br>[機  能] アクセス制限処理
     * <br>[解  説]
     * <br>[備  考]
     * <br>
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @return アクションフォーワード
     * @throws SQLException SQL実行時例外
     */
    private ActionForward __immigration(ActionMapping map, Cmn340Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con) throws SQLException {

        RequestModel reqMdl = getRequestModel(req);
        Cmn340ParamModel param = new Cmn340ParamModel();
        param.setParam(form);
        Cmn340Biz biz = new Cmn340Biz(reqMdl, con);
        if (param.getCmn340mode() != GSConstCommon.MODE_EDIT
                || biz.getEditData(param.getCmn340CacSid()) != null) {
            return null;
        }

        //アクセス例外
        // ・編集モードかつ データが存在しない
        Cmn999Form cmn999Form = new Cmn999Form();
        cmn999Form.setType(Cmn999Form.TYPE_OK);
        cmn999Form.setIcon(Cmn999Form.ICON_WARN);
        cmn999Form.setWtarget(Cmn999Form.WTARGET_BODY);

        //OKボタンクリック時遷移先
        ActionForward forwardOk = map.findForward("cmn330");
        cmn999Form.setUrlOK(forwardOk.getPath());

        MessageResources msgRes = getResources(req);

        GsMessage gsMsg = new GsMessage(reqMdl);
        String nameData = gsMsg.getMessage(req, "cmn.cmn340.01");

        String operation = gsMsg.getMessage("cmn.edit");
        if (Objects.equals(req.getParameter("CMD"), "cmn340DeleteComp")) {
            operation = gsMsg.getMessage("cmn.delete");
        }
        cmn999Form.setMessage(
            msgRes.getMessage("error.none.edit.data", nameData, operation));

        req.setAttribute("cmn999Form", cmn999Form);

        return map.findForward("gf_msg");
    }

    /**
     * <br>[機  能] 初期表示処理
     * <br>[解  説]
     * <br>[備  考]
     * <br>
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @return アクションフォーワード
     * @throws SQLException SQL実行時例外
     * @throws JDOMException 
     * @throws SAXException 
     * @throws ParserConfigurationException 
     * @throws EncryptionException 
     * @throws InvocationTargetException 
     * @throws IllegalAccessException 
     * @throws ClassNotFoundException WEB APIクラスが存在しない
     * @throws IOException WEB API設定ファイルの取得に失敗
     */
    private ActionForward __doInit(ActionMapping map, Cmn340Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con)
            throws SQLException, ClassNotFoundException, IllegalAccessException,
            InvocationTargetException, EncryptionException, IOException,
            ParserConfigurationException, SAXException, JDOMException  {
        con.setAutoCommit(true);

        RequestModel reqMdl = getRequestModel(req);
        Cmn340ParamModel param = new Cmn340ParamModel();
        param.setParam(form);
        Cmn340Biz biz = new Cmn340Biz(reqMdl, con);
        PluginConfig pconfig = getPluginConfig(req);

        biz.setInitData(param, con, pconfig, getAppRootPath());
        saveToken(req);
        param.setFormData(form);

        return map.getInputForward();
    }
    
    /**
     * <br>[機  能] 登録ボタンクリック処理
     * <br>[解  説]
     * <br>[備  考]
     * <br>
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @throws SQLException SQL実行時例外
     * @throws ClassNotFoundException WEB APIクラスが存在しない
     * @throws IOException WEB API設定ファイルの取得に失敗
     */
    @SuppressWarnings("unchecked")
    private void __doOk(ActionMapping map, Cmn340Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con)
    throws SQLException, ClassNotFoundException, IOException,
        ParserConfigurationException, SAXException, JDOMException {
        
        //入力チェック
        ActionErrors errors = form.validateCheck(
            getRequestModel(req), con,
            getPluginConfig(req),
            getAppRootPath(), true);
        JSONObject jsonData = new JSONObject();
        if (errors != null && errors.size() > 0) {
            List<String> errMsgList = new ArrayList<String>();
            MessageResources mres = getResources(req);
            Iterator<ActionMessage> iterator = errors.get();
            while (iterator.hasNext()) {
                ActionMessage errorMsg = (ActionMessage) iterator.next();
                errMsgList.add(mres.getMessage(
                        errorMsg.getKey(), errorMsg.getValues()));
            }
            jsonData.element("success", false);
            jsonData.element("size", errors.size());
            for (int i = 0; i < errMsgList.size(); i++) {
                jsonData.element("errorMsg_" + i, errMsgList.get(i));
            }
        } else {
            jsonData.element("success", true);
            saveToken(req);
            HttpSession session = req.getSession();
            Object value = session.getAttribute(Globals.TRANSACTION_TOKEN_KEY);
            jsonData.element("token", value);
        }
        PrintWriter out = null;
        try {
            res.setHeader("Cache-Control", "no-cache");
            res.setContentType("application/json;charset=UTF-8");
            out = res.getWriter();
            out.print(jsonData);
            out.flush();
        } catch (IOException e) {
        } finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /**
     * <br>[機  能] 確定ボタンクリック処理
     * <br>[解  説] 
     * <br>[備  考]
     * <br>
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @return アクションフォーワード
     * @throws Exception SQL実行時例外
     */
    private ActionForward __doDecision(ActionMapping map, Cmn340Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con) throws Exception {

        if (!isTokenValid(req, true)) {
            log__.info("２重投稿");
            return getSubmitErrorPage(map, req);
        }
        //入力チェック
        ActionErrors errors = form.validateCheck(
            getRequestModel(req), con,
            getPluginConfig(req),
            getAppRootPath(), true);
        if (!errors.isEmpty()) {
            addErrors(req, errors);
            return __doInit(map, form, req, res, con);
        }
        
        RequestModel reqMdl = getRequestModel(req);
        Cmn340Biz biz = new Cmn340Biz(reqMdl, con);
        Cmn340ParamModel param = new Cmn340ParamModel();
        param.setParam(form);

        MlCountMtController cntCon = getCountMtController(req);

        if (param.getCmn340mode() == GSConstCommon.MODE_EDIT) {
            biz.doUpdate(param, cntCon);
        } else {
            biz.doCommit(param, cntCon);
        }
        param.setFormData(form);

        String valueStr = biz.getOpLogValue(param);
        __outPutLog(map, form, req, con, valueStr, false);

        return __doCompPage(map, req, form, false);
    }

    /**
     * <br>[機  能] ボディパラメータを取得する
     * <br>[解  説] 
     * <br>[備  考] テキストボディに入力された文字列からパラメータ一覧を取得する
     * <br>
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @return アクションフォーワード
     * @throws Exception SQL実行時例外
     */
    @SuppressWarnings("unchecked")
    private ActionForward __doGetBodyParam(ActionMapping map, Cmn340Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con)
            throws ClassNotFoundException, IOException, SQLException,
            ParserConfigurationException, SAXException, IOException, JDOMException {

        //入力チェック
        ActionErrors errors = new ActionErrors();
        form.validateReqBody(errors, getRequestModel(req), true);

        JSONObject jsonData = new JSONObject();
        if (!errors.isEmpty()) {
            addErrors(req, errors);
            MessageResources msgRes = getResources(req);
            Iterator<ActionMessage> iterator = errors.get();
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            while (iterator.hasNext()) {
                if (!isFirst) {
                    sb.append("<br>");
                }
                ActionMessage error = ((ActionMessage) iterator.next());
                sb.append(msgRes.getMessage(error.getKey(), error.getValues()));
                isFirst = false;
            }
            jsonData.element("success", false);
            jsonData.element("error", sb.toString());
        } else {
            Cmn340ParamModel param = new Cmn340ParamModel();
            param.setParam(form);

            RequestModel reqMdl = getRequestModel(req);
            try {
                ApiConnectBiz apiBiz = new ApiConnectBiz();
                List<Cmn340JsonModel> paramList = apiBiz.getParamList(
                    param.getCmn340CacBody(), param.getCmn340CacContent());
                JSONArray paramArray = JSONArray.fromObject(paramList);
                jsonData.element("paramList", paramArray);
                jsonData.element("success", true);
            } catch (Exception e) {
                jsonData.element("success", false);
                GsMessage gsMg = new GsMessage(reqMdl);
                jsonData.element("error", gsMg.getMessage("cmn.cmn340.81"));
            }
        }
        
        PrintWriter out = null;
        try {
            res.setHeader("Cache-Control", "no-cache");
            res.setContentType("application/json;charset=UTF-8");
            out = res.getWriter();
            out.print(jsonData);
            out.flush();
        } catch (Exception e) {
            log__.error("jsonデータ送信失敗(テストデータ)");
        } finally {
            if (out != null) {
                out.close();
            }
        }
        

        return null;
    }

    /**
     * <br>[機  能] GroupSession APIを反映させる
     * <br>[解  説] 
     * <br>[備  考]
     * <br>
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @return アクションフォーワード
     * @throws JDOMException 
     * @throws IOException 
     * @throws SAXException 
     * @throws ParserConfigurationException 
     * @throws SQLException SQL実行時例外
     */
    private ActionForward __doReflectGsApi(ActionMapping map, Cmn340Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con)
            throws SQLException, ParserConfigurationException,
                SAXException, IOException, JDOMException {

        //入力チェック
        Cmn340Biz biz = new Cmn340Biz(getRequestModel(req), con);
        JSONObject jsonData = biz._getGsApiInfo(con, form.getCmn340CacGsApi());
        
        if (jsonData == null) {
            jsonData = new JSONObject();
            jsonData.element("success", false);
        } else {
            jsonData.element("success", true);
        }
        
        PrintWriter out = null;
        try {
            res.setHeader("Cache-Control", "no-cache");
            res.setContentType("application/json;charset=UTF-8");
            out = res.getWriter();
            out.print(jsonData);
            out.flush();
        } catch (Exception e) {
            log__.error("jsonデータ送信失敗(GSAPI情報)");
        } finally {
            if (out != null) {
                out.close();
            }
        }

        return null;
    }

    /**
     *
     * <br>[機  能] 登録完了表示処理
     * <br>[解  説]
     * <br>[備  考]
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param isDelete 削除時フラグ
     * @return 登録完了アクションフォーワード
     */
    private ActionForward __doCompPage(ActionMapping map,
            HttpServletRequest req, Cmn340Form form, boolean isDelete) {
        Cmn999Form cmn999Form = new Cmn999Form();
        ActionForward urlForward = null;

        cmn999Form.setType(Cmn999Form.TYPE_OK);
        MessageResources msgRes = getResources(req);
        cmn999Form.setIcon(Cmn999Form.ICON_INFO);
        cmn999Form.setWtarget(Cmn999Form.WTARGET_BODY);
        urlForward = map.findForward("cmn330");
        cmn999Form.setUrlOK(urlForward.getPath());

        //メッセージセット
        String msgState = null;
        if (isDelete) {
            msgState = "sakujo.kanryo.object";
        } else if (form.getCmn340mode() == GSConstCommon.MODE_ADD) {
            msgState = "touroku.kanryo.object";
        } else if (form.getCmn340mode() == GSConstCommon.MODE_EDIT) {
            msgState = "hensyu.kanryo.object";
        }
        cmn999Form.setMessage(msgRes.getMessage(msgState, getInterMessage(req, "cmn.cmn340.01")));

        //画面パラメータをセット
        req.setAttribute("cmn999Form", cmn999Form);

        return map.findForward("gf_msg");
    }

    /**
     *
     * <br>[機  能] オペレーションログ出力
     * <br>[解  説]
     * <br>[備  考]
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param con コネクション
     * @param value 登録情報文字列
     * @param isDelete 削除時フラグ
     */
    private void __outPutLog(
            ActionMapping map, Cmn340Form form,
            HttpServletRequest req, Connection con,
            String value, boolean isDelete) {
        RequestModel reqMdl = getRequestModel(req);
        //ログ出力処理
        CommonBiz cmnBiz = new CommonBiz();
        GsMessage gsMsg = new GsMessage();

        //内容セット
        String opCode = "";
        if (isDelete) {
            opCode = gsMsg.getMessage("cmn.delete");
        } else  if (form.getCmn340mode() == GSConstCommon.MODE_ADD) {
            opCode = gsMsg.getMessage("cmn.entry");
        } else if (form.getCmn340mode() == GSConstCommon.MODE_EDIT) {
            opCode = gsMsg.getMessage("cmn.change");
        }

        cmnBiz.outPutCommonLog(map, reqMdl, gsMsg, con, opCode,
                            GSConstLog.LEVEL_INFO, value);

    }

    /**
     * <br>[機  能] 削除確認 OKボタンクリック処理
     * <br>[解  説]
     * <br>[備  考]
     * <br>
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @return アクションフォーワード
     * @throws SQLException SQL実行時例外
     */
    private ActionForward __doDeleteComp(ActionMapping map, Cmn340Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con) throws SQLException {
        if (!isTokenValid(req, true)) {
            log__.info("２重投稿");
            return getSubmitErrorPage(map, req);
        }

        RequestModel reqMdl = getRequestModel(req);
        Cmn340Biz biz = new Cmn340Biz(reqMdl, con);
        Cmn340ParamModel param = new Cmn340ParamModel();
        param.setParam(form);
        String value = biz.getOpLogValue(param);

        biz.doDelete(param);
        param.setFormData(form);

        __outPutLog(map, form, req, con, value, true);

        return __doCompPage(map, req, form, true);
    }
}
