package jp.groupsession.v2.cmn.cmn340;

import java.io.File;
import java.io.IOException;
import java.net.http.HttpTimeoutException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.LabelValueBean;
import org.jdom2.JDOMException;
import org.xml.sax.SAXException;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.StringUtilHtml;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.co.sjts.util.io.IOTools;
import jp.co.sjts.util.io.ObjectFile;
import jp.co.sjts.util.json.JSONObject;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.biz.apiconnect.ApiConnectBiz;
import jp.groupsession.v2.cmn.biz.apiconnect.ApiExecuter;
import jp.groupsession.v2.cmn.biz.apiconnect.EnumContentType;
import jp.groupsession.v2.cmn.biz.apiconnect.EnumMethod;
import jp.groupsession.v2.cmn.cmn110.Cmn110FileModel;
import jp.groupsession.v2.cmn.config.Plugin;
import jp.groupsession.v2.cmn.config.PluginConfig;
import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectDao;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectGsapiDao;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectGsparamDao;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectHeaderDao;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectParamDao;
import jp.groupsession.v2.cmn.http.HttpPart;
import jp.groupsession.v2.cmn.http.HttpResponseModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectGsapiModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectGsparamModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectHeaderModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectParamModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.GSPassword;

/**
 *
 * <br>[機  能] 連携API登録画面で使用するビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Cmn340Biz {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(Cmn340Biz.class);
    /** 配置 指定無し */
    public static final String HAICHI_SITEINASI = "noneHaichi";
    /** 種類 パラメータ */
    public static final String PARAM_TYPE_PARAMETER = "0";
    /** 配置 指定無し */
    public static final String PARAM_TYPE_IREKO = "1";
    /** 配置 指定無し */
    public static final String PARAM_TYPE_HAIRETU = "2";
    /** リクエストモデル */
    RequestModel reqMdl__;
    /** コネクション */
    Connection con__;

    /**
     *
     * コンストラクタ
     * @param reqMdl リクエストモデル
     * @param con コネクション
     */
    public Cmn340Biz(RequestModel reqMdl, Connection con) {
        reqMdl__ = reqMdl;
        con__ = con;
    }
    /**
     * <br>[機  能] SID指定のデータ取得
     * <br>[解  説]
     * <br>[備  考]
     * @param cmn340CacSid sid
     * @return API連携モデル
     * @throws SQLException SQL実行時例外
     */
    public CmnApiConnectModel getEditData(int cmn340CacSid) throws SQLException {
        CmnApiConnectDao dao = new CmnApiConnectDao(con__);

        return dao.select(cmn340CacSid);
    }

    /**
     * <br>[機  能]
     * <br>[解  説]
     * <br>[備  考]
     * @param param パラメータ情報
     * @param con コネクション
     * @param pconfig プラグイン情報
     * @param appRootPath アプリケーションルート
     * @throws SQLException SQL実行例外
     * @throws IOException 添付ファイル操作時例外
     * @throws ClassNotFoundException プラグイン情報取得時例外
     * @throws EncryptionException パスワード復号時例外
     * @throws JDOMException json操作時例外
     * @throws SAXException XML操作時例外
     * @throws ParserConfigurationException XML操作時例外
     */
    public void setInitData(
        Cmn340ParamModel param, Connection con, PluginConfig pconfig, String appRootPath)
        throws ClassNotFoundException, IOException, SQLException,
            EncryptionException, ParserConfigurationException, SAXException, JDOMException {

        log__.info("連携API登録画面 初期表示処理開始");
        //GSAPIコンボの設定
        __setGsApiCombo(param, reqMdl__, con, pconfig);

        //コンテントタイプのコンボの設定

        int cacSid = NullDefault.getInt(String.valueOf(param.getCmn340CacSid()), -1);
        if (param.getCmn340init() == Cmn340Form.INIT_FLG && cacSid > 0) {
            //編集時
            CmnApiConnectDao cacDao = new CmnApiConnectDao(con);
            CmnApiConnectModel apiMdl = cacDao.select(cacSid);
            if (apiMdl == null) {
                return;
            }

            param.setCmn340CacName(apiMdl.getCacName());
            param.setCmn340CacDescription(apiMdl.getCacDescription());
            param.setCmn340CacUrl(apiMdl.getCacUrl());

            //リクエストヘッダ，リクエストボディ
            param.setCmn340CacMethod(apiMdl.getCacMethodKbn());
            param.setCmn340CacAuth(apiMdl.getCacAuthKbn());
            param.setCmn340CacToken(apiMdl.getCacAuthToken());
            param.setCmn340CacId(apiMdl.getCacAuthId());
            param.setCmn340CacPassword(GSPassword.getDecryPassword(apiMdl.getCacAuthPass()));
            param.setCmn340CacContent(apiMdl.getCacContentKbn());
            param.setCmn340CacContentManual(apiMdl.getCacContentManual());

            //リクエストボディ
            param.setCmn340CacBody(apiMdl.getCacBody());

            CmnApiConnectParamDao cacpDao = new CmnApiConnectParamDao(con);
            List<CmnApiConnectParamModel> paramList = cacpDao.select(cacSid);

            //パスパラメータ
            List<CmnApiConnectParamModel> pathParamList = paramList.stream()
                .filter(mdl -> mdl.getCacpKbn() == 0)
                .collect(Collectors.toList());

            ApiConnectBiz apiBiz = new ApiConnectBiz();
            List<String> pathParamName = apiBiz.getPathParameterName(apiMdl.getCacUrl());
            final AtomicInteger paramIdx = new AtomicInteger(0);
            TreeMap<Integer, CmnApiConnectParamModel> pathParamMap = new TreeMap<>();
            for (String name : pathParamName) {
                for (CmnApiConnectParamModel mdl : pathParamList) {
                    if (Objects.equals(name, mdl.getCacpName())) {
                        pathParamMap.put(paramIdx.getAndIncrement(), mdl);
                        break;
                    }
                }
            }
            param.setCmn340PathParamMap(pathParamMap);

            //クエリパラメータ
            List<CmnApiConnectParamModel> queryParamList = paramList.stream()
                .filter(mdl -> mdl.getCacpKbn() == 1)
                .collect(Collectors.toList());

            List<String> queryParamName = apiBiz.getQueryParameterName(apiMdl.getCacUrl());
            paramIdx.set(1);
            TreeMap<Integer, CmnApiConnectParamModel> queryParamMap = new TreeMap<>();
            for (String name : queryParamName) {
                for (CmnApiConnectParamModel mdl : queryParamList) {
                    if (Objects.equals(name, mdl.getCacpName())) {
                        queryParamMap.put(paramIdx.getAndIncrement(), mdl);
                        break;
                    }
                }
            }
            param.setCmn340QueryParamMap(queryParamMap);

            //ボディパラメータ
            List<CmnApiConnectParamModel> bodyParamList = paramList.stream()
                .filter(mdl -> mdl.getCacpKbn() == 2)
                .collect(Collectors.toList());

            TreeMap<Integer, CmnApiConnectParamModel> bodyParamMap =
                apiBiz.getBodyMap(bodyParamList,
                    param.getCmn340CacBody(), param.getCmn340CacContent());

            param.setCmn340BodyParamMap(bodyParamMap);

            //追加ヘッダー
            CmnApiConnectHeaderDao cachDao = new CmnApiConnectHeaderDao(con);
            List<CmnApiConnectHeaderModel> headerList = cachDao.select(cacSid);
            TreeMap<Integer, CmnApiConnectHeaderModel> reqHeaderMap = headerList.stream()
                .collect(Collectors.toMap(
                    mdl -> mdl.getCachSort(), mdl -> mdl, (a, b) -> b, TreeMap::new));
            param.setCmn340RequestHeaderMap(reqHeaderMap);

            if (apiMdl.getCagSid() != 0) {
                CmnApiConnectGsapiDao cagDao = new CmnApiConnectGsapiDao(con);
                CmnApiConnectGsapiModel cagMdl = cagDao.select(apiMdl.getCagSid());
                //ベースAPI
                if (cagMdl != null) {
                    param.setCmn340CacPlugin(cagMdl.getCagPlugin());
                    param.setCmn340CacGsApi(cagMdl.getCagSid());
                }
                //更新エラーフラグ
                if (cagMdl == null || apiMdl.getCagVersion() < cagMdl.getCagVersion()) {
                    String msgKey =
                        "cmn.gsapi." + cagMdl.getCagPlugin() + "." + cagMdl.getCagOperation();
                    GsMessage gsMsg = new GsMessage(reqMdl__);
                    String path = cagMdl.getCagPath();
                    if (path.indexOf("?") > -1) {
                        path = path.substring(0, path.indexOf("?"));
                    }
                    String pluginText = gsMsg.getMessage(msgKey) + "(" + path + ")";
                    param.setCmn340GsApiErrorText(pluginText);
                    param.setCmn340VerErrorFlg(1);
                }
            }
        }
        param.setCmn340init(Cmn340Form.NOT_INIT_FLG);
        log__.info("連携API登録画面 初期表示処理終了");
    }

    /**
     * <br>[機  能] GroupSessionAPIのコンボボックスの表示内容を設定する
     * <br>[解  説]
     * <br>[備  考]
     * @param param cmn340parammodel
     * @param reqMdl リクエスト情報
     * @param con コネクション
     * @param pconfig プラグインコンフィグ
     * @throws ClassNotFoundException
     * @throws IOException
     * @throws SQLException
     */
    private void __setGsApiCombo(
        Cmn340ParamModel param, RequestModel reqMdl, Connection con, PluginConfig pconfig)
        throws ClassNotFoundException, IOException, SQLException {

        //GS APIの選択値設定
        List<LabelValueBean> pluginLblList = new ArrayList<LabelValueBean>();
        GsMessage gsMsg = new GsMessage(reqMdl__);
        pluginLblList.add(new LabelValueBean(gsMsg.getMessage("cmn.cmn340.82"), "0"));

        List<Plugin> pluginList = pconfig.getPluginDataList();
        Map<String, String> pluginNameMap =
            pluginList.stream()
            .map(plugin -> {
                return plugin;
            }).collect(
                Collectors.toMap(plugin -> plugin.getId(), plugin -> plugin.getName(reqMdl__)));

        CmnApiConnectGsapiDao cagDao = new CmnApiConnectGsapiDao(con__);
        List<CmnApiConnectGsapiModel> apiMdlList = cagDao.select();
        pluginLblList.addAll(
            apiMdlList.stream()
                .filter(mdl -> !StringUtil.isNullZeroString(pluginNameMap.get(mdl.getCagPlugin())))
                .map(mdl -> new LabelValueBean(
                    pluginNameMap.get(mdl.getCagPlugin()), mdl.getCagPlugin()))
                .distinct()
                .collect(Collectors.toList()));

        param.setCmn340CacPluginList(pluginLblList);

        apiMdlList = apiMdlList.stream()
            .filter(mdl -> !StringUtil.isNullZeroString(pluginNameMap.get(mdl.getCagPlugin())))
            .map(mdl -> {
                String msgKey = "cmn.gsapi." + mdl.getCagPlugin() + "." + mdl.getCagOperation();
                mdl.setCagOperation(gsMsg.getMessage(msgKey));
                return mdl;
            })
            .collect(Collectors.toList());
        param.setCmn340CacApiList(apiMdlList);
    }

    /**
     *
     * <br>[機  能] オペレーションログ用文字列を出力する
     * <br>[解  説]
     * <br>[備  考]
     * @param param パラメータモデル
     * @return オペレーションログ用文字列
     * @throws SQLException SQL実行時例外
     */
    public String getOpLogValue(Cmn340ParamModel param) throws SQLException {
        GsMessage gsMsg = new GsMessage(reqMdl__);

        CmnApiConnectModel base = getEditData(param.getCmn340CacSid());

        StringBuilder sb = new StringBuilder();

        if (base == null) {
            return sb.toString();
        }
        sb.append("[" + gsMsg.getMessage("cmn.cmn340.02") + "]");
        sb.append("\r\n");
        sb.append(base.getCacName());
        sb.append("\r\n");
        sb.append("[" + gsMsg.getMessage("cmn.cmn340.03") + "]");
        sb.append("\r\n");
        sb.append(base.getCacUrl());

        return sb.toString();
    }
    /**
     *
     * <br>[機  能] 登録処理を実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param param パラメータモデル
     * @param cntCon 採番コントローラ
     * @throws SQLException SQL実行時例外
     */
    public void doCommit(Cmn340ParamModel param, MlCountMtController cntCon) throws SQLException {
        CmnApiConnectDao cacDao = new CmnApiConnectDao(con__);
        CmnApiConnectParamDao paramDao = new CmnApiConnectParamDao(con__);
        CmnApiConnectHeaderDao headerDao = new CmnApiConnectHeaderDao(con__);

        //連携ApiSID採番
        int sid = (int) cntCon.getSaibanNumber(
                GSConstCommon.SBNSID_COMMON,
                GSConstCommon.SBNSID_SUB_APICON,
                reqMdl__.getSmodel().getUsrsid());
        param.setCmn340CacSid(sid);
        CmnApiConnectModel base = __getConnectModel(param, true);
        List<CmnApiConnectParamModel> paramList = __getConnectParamModel(param);
        List<CmnApiConnectHeaderModel> headerList = __getConnectHeaderModel(param);

        //連携API情報の登録
        cacDao.insert(base);
        //パラメータ一覧の登録
        paramDao.insert(paramList);
        //リクエストヘッダの登録
        headerDao.insert(headerList);
    }

    /**
    *
    * <br>[機  能] 更新処理を実行する
    * <br>[解  説]
    * <br>[備  考]
    * @param param パラメータモデル
    * @param cntCon 採番コントローラ
    * @throws SQLException  SQL実行時例外
    */
    public void doUpdate(Cmn340ParamModel param, MlCountMtController cntCon) throws SQLException {
        CmnApiConnectDao cacDao = new CmnApiConnectDao(con__);
        CmnApiConnectParamDao paramDao = new CmnApiConnectParamDao(con__);
        CmnApiConnectHeaderDao headerDao = new CmnApiConnectHeaderDao(con__);

        //連携ApiSID採番
        CmnApiConnectModel base = __getConnectModel(param, false);
        List<CmnApiConnectParamModel> paramList = __getConnectParamModel(param);
        List<CmnApiConnectHeaderModel> headerList = __getConnectHeaderModel(param);

        //連携API情報の登録
        cacDao.update(base);
        //パラメータ一覧の登録
        int cacSid = param.getCmn340CacSid();

        paramDao.delete(cacSid);
        paramDao.insert(paramList);
        //リクエストヘッダの登録
        headerDao.delete(cacSid);
        headerDao.insert(headerList);
    }

    /**
     * <br>[機  能] 登録,編集用のCmnApiConnectModelを生成する
     * <br>[解  説]
     * <br>[備  考]
     * @param param パラメータモデル
     * @param isInsert true:新規登録, false:更新
     * @return CmnApiConnectModel
     * @throws SQLException
     * @throws NumberFormatException
     */
    private CmnApiConnectModel __getConnectModel(
        Cmn340ParamModel param, boolean isInsert) throws NumberFormatException, SQLException {

        UDate now = new UDate();
        CmnApiConnectModel base = new CmnApiConnectModel();
        base.setCacSid(param.getCmn340CacSid());
        if (isInsert) {
            base.setCacAuid(reqMdl__.getSmodel().getUsrsid());
            base.setCacAdate(now);
        } else {
            CmnApiConnectDao cacDao = new CmnApiConnectDao(con__);
            CmnApiConnectModel cacMdl = cacDao.select(param.getCmn340CacSid());
            base.setCacAuid(cacMdl.getCacAuid());
            base.setCacAdate(cacMdl.getCacAdate());
        }
        base.setCacEuid(reqMdl__.getSmodel().getUsrsid());
        base.setCacEdate(now);

        base.setCacName(param.getCmn340CacName());
        base.setCacDescription(param.getCmn340CacDescription());
        base.setCacUrl(param.getCmn340CacUrl());

        int gsApiSid = param.getCmn340CacGsApi();
        base.setCagSid(gsApiSid);
        if (gsApiSid != 0) {
            CmnApiConnectGsapiDao cagDao = new CmnApiConnectGsapiDao(con__);
            CmnApiConnectGsapiModel cagMdl = cagDao.select(param.getCmn340CacGsApi());
            base.setCagVersion(cagMdl.getCagVersion());
        } else {
            base.setCagVersion(0);
        }

        base.setCacUrl(param.getCmn340CacUrl());
        int methodKbn = param.getCmn340CacMethod();
        base.setCacMethodKbn(methodKbn);
        int authKbn = param.getCmn340CacAuth();
        base.setCacAuthKbn(authKbn);
        if (authKbn == GSConstCommon.AUTH_KBN_TOKEN) {
            base.setCacAuthToken(param.getCmn340CacToken());
        } else if (authKbn == GSConstCommon.AUTH_KBN_BASIC) {
            base.setCacAuthId(param.getCmn340CacId());
            try {
                base.setCacAuthPass(GSPassword.getEncryPassword(param.getCmn340CacPassword()));
            } catch (EncryptionException e) {
                throw new RuntimeException(e);
            }
        }

        int contentKbn = param.getCmn340CacContent();
        base.setCacContentKbn(contentKbn);
        if (contentKbn == EnumContentType.MANUAL.getValue()) {
            base.setCacContentManual(param.getCmn340CacContentManual());
        }

        if (methodKbn == EnumMethod.POST.getValue()
            || methodKbn == EnumMethod.PUT.getValue()
            || methodKbn == EnumMethod.PATCH.getValue()) {

            if (contentKbn == EnumContentType.MULTIPART_FORM_DATA.getValue()) {
                StringBuilder bodyBuilder = new StringBuilder();
                Set<Entry<Integer, CmnApiConnectParamModel>> bodyEntrySet
                    = param.getCmn340BodyParamMap().entrySet();
                for (Map.Entry<Integer, CmnApiConnectParamModel> entry : bodyEntrySet) {
                    bodyBuilder.append("--boundary");
                    bodyBuilder.append("\r\n");
                    bodyBuilder.append("Content-Disposition: form-data; name=");
                    bodyBuilder.append(entry.getValue().getCacpName());
                    if (entry.getValue().getCacpParamType() == GSConstCommon.PARAM_TYPE_FILE) {
                        bodyBuilder.append("; filename=\"\"");
                    }
                    bodyBuilder.append("\r\n\r\n");
                    bodyBuilder.append("${").append(entry.getValue().getCacpName()).append("}");
                    bodyBuilder.append("\r\n");
                }
                bodyBuilder.append("--boundary--");
                base.setCacBody(bodyBuilder.toString());
            } else {
                base.setCacBody(param.getCmn340CacBody());
            }
        }

        return base;
    }

    /**
     * <br>[機  能] CmnApiConnectModelを生成する
     * <br>[解  説]
     * <br>[備  考]
     * @param param パラメータモデル
     * @return CmnApiConnectModel
     * @throws SQLException
     * @throws NumberFormatException
     */
    private List<CmnApiConnectParamModel> __getConnectParamModel(
        Cmn340ParamModel param) throws NumberFormatException, SQLException {

        List<CmnApiConnectParamModel> ret = new ArrayList<CmnApiConnectParamModel>();

        //パスパラメータの取得
        Set<Entry<Integer, CmnApiConnectParamModel>> pathEntrySet
            = param.getCmn340PathParamMap().entrySet();

        for (Map.Entry<Integer, CmnApiConnectParamModel> entry : pathEntrySet) {
            CmnApiConnectParamModel addPathModel = new CmnApiConnectParamModel();
            CmnApiConnectParamModel pathParamModel = entry.getValue();

            addPathModel.setCacSid(param.getCmn340CacSid());
            addPathModel.setCacpKbn(GSConstCommon.PARAM_KBN_PATH);
            addPathModel.setCacpParamType(GSConstCommon.PARAM_TYPE_TEXT);
            addPathModel.setCacpName(pathParamModel.getCacpName());
            addPathModel.setCacpNameDisp(pathParamModel.getCacpNameDisp());
            addPathModel.setCacpBiko(pathParamModel.getCacpBiko());
            addPathModel.setCacpRequiredKbn(GSConstCommon.PARAM_REQUIRE_ON);
            addPathModel.setCacpListKbn(GSConstCommon.PARAM_LIST_OFF);

            ret.add(addPathModel);
        }

        //クエリパラメータの取得
        Set<Entry<Integer, CmnApiConnectParamModel>> queryEntrySet
            = param.getCmn340QueryParamMap().entrySet();

        for (Map.Entry<Integer, CmnApiConnectParamModel> entry : queryEntrySet) {
            CmnApiConnectParamModel addQueryModel = new CmnApiConnectParamModel();
            CmnApiConnectParamModel pathQueryModel = entry.getValue();

            addQueryModel.setCacSid(param.getCmn340CacSid());
            addQueryModel.setCacpKbn(GSConstCommon.PARAM_KBN_QUERY);
            addQueryModel.setCacpParamType(GSConstCommon.PARAM_TYPE_TEXT);
            addQueryModel.setCacpName(pathQueryModel.getCacpName());
            addQueryModel.setCacpNameDisp(pathQueryModel.getCacpNameDisp());
            addQueryModel.setCacpBiko(pathQueryModel.getCacpBiko());
            addQueryModel.setCacpListKbn(pathQueryModel.getCacpListKbn());
            addQueryModel.setCacpRequiredKbn(pathQueryModel.getCacpRequiredKbn());
            ret.add(addQueryModel);
        }

        //ボディパラメータの取得
        int methodKbn = param.getCmn340CacMethod();
        if (methodKbn != EnumMethod.POST.getValue()
            && methodKbn != EnumMethod.PUT.getValue()
            && methodKbn != EnumMethod.PATCH.getValue()) {
            //POST, PUT, PATCH以外はボディパラメータを使用しない
            return ret;
        }

        int contentKbn = param.getCmn340CacContent();
        Set<Entry<Integer, CmnApiConnectParamModel>> bodyEntrySet
            = param.getCmn340BodyParamMap().entrySet();
        for (Map.Entry<Integer, CmnApiConnectParamModel> entry : bodyEntrySet) {
            CmnApiConnectParamModel pathBodyModel = entry.getValue();
            CmnApiConnectParamModel addBodyModel = new CmnApiConnectParamModel();

            addBodyModel.setCacSid(param.getCmn340CacSid());
            addBodyModel.setCacpKbn(GSConstCommon.PARAM_KBN_BODY);
            if (contentKbn == EnumContentType.MULTIPART_FORM_DATA.getValue()
                && pathBodyModel.getCacpParamType() == GSConstCommon.PARAM_TYPE_FILE) {
                addBodyModel.setCacpParamType(GSConstCommon.PARAM_TYPE_FILE);
            }
            addBodyModel.setCacpName(pathBodyModel.getCacpName());
            addBodyModel.setCacpNameDisp(pathBodyModel.getCacpNameDisp());
            addBodyModel.setCacpBiko(pathBodyModel.getCacpBiko());
            if (param.getCmn340CacContent() == EnumContentType.MANUAL.getValue()) {
                addBodyModel.setCacpListKbn(pathBodyModel.getCacpListKbn());
            } else {
                addBodyModel.setCacpListKbn(pathBodyModel.getCacpListKbn());
            }
            addBodyModel.setCacpRequiredKbn(pathBodyModel.getCacpRequiredKbn());

            ret.add(addBodyModel);
        }
        return ret;
    }

    /**
     * <br>[機  能] CmnApiConnectModelを生成する
     * <br>[解  説]
     * <br>[備  考]
     * @param param パラメータモデル
     * @return CmnApiConnectModel
     * @throws SQLException
     * @throws NumberFormatException
     */
    private List<CmnApiConnectHeaderModel> __getConnectHeaderModel(
        Cmn340ParamModel param) throws NumberFormatException, SQLException {

        List<CmnApiConnectHeaderModel> ret = new ArrayList<CmnApiConnectHeaderModel>();
        final AtomicInteger headerSort = new AtomicInteger(1);

        Set<Entry<Integer, CmnApiConnectHeaderModel>> headerEntry
            = param.getCmn340RequestHeaderMap().entrySet();
        for (Map.Entry<Integer, CmnApiConnectHeaderModel> entry : headerEntry) {
            CmnApiConnectHeaderModel headerParamModel = entry.getValue();
            CmnApiConnectHeaderModel addhHeaderModel = new CmnApiConnectHeaderModel();

            addhHeaderModel.setCacSid(param.getCmn340CacSid());
            addhHeaderModel.setCachKey(headerParamModel.getCachKey());
            addhHeaderModel.setCachValue(headerParamModel.getCachValue());
            addhHeaderModel.setCachSort(headerSort.getAndIncrement());

            ret.add(addhHeaderModel);
        }

        return ret;
    }

    /**
     *
     * <br>[機  能] 削除処理を実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param param パラメータモデル
     * @throws SQLException  SQL実行時例外
     */
    public void doDelete(Cmn340ParamModel param) throws SQLException {
        CmnApiConnectDao dao = new CmnApiConnectDao(con__);
        CmnApiConnectParamDao paramDao = new CmnApiConnectParamDao(con__);
        CmnApiConnectHeaderDao headerDao = new CmnApiConnectHeaderDao(con__);

        int cacSid = param.getCmn340CacSid();
        dao.delete(cacSid);
        paramDao.delete(cacSid);
        headerDao.delete(cacSid);
    }

    /**
     * <br>[機  能] ファイルのコンテントタイプを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param extension 拡張子文字列
     * @return コンテントタイプ文字列
     */
    private String __getFileContentType(String extension) {
        String type;
        if (extension.equals(".css")) {
            type = "text/css";
        } else if (extension.equals(".csv")) {
            type = "text/csv";
        } else if (extension.equals(".doc")) {
            type = "application/msword";
        } else if (extension.equals(".gif")) {
            type = "image/gif";
        } else if (extension.equals(".html")) {
            type = "text/html";
        } else if (extension.equals(".ico")) {
            type = "image/vnd.microsoft.icon";
        } else if (extension.equals(".jpeg")) {
            type = "image/jpeg";
        } else if (extension.equals(".jpg")) {
            type = "image/jpeg";
        } else if (extension.equals(".js")) {
            type = "text/javascript";
        } else if (extension.equals(".json")) {
            type = "application/json";
        } else if (extension.equals(".png")) {
            type = "image/png";
        } else if (extension.equals(".pdf")) {
            type = "application/pdf";
        } else if (extension.equals(".ppt")) {
            type = "application/vnd.ms-powerpoint";
        } else if (extension.equals(".pptx")) {
            type = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
        } else if (extension.equals(".txt")) {
            type = "text/plain";
        } else if (extension.equals(".xls")) {
            type = "application/vnd.ms-excel";
        } else if (extension.equals(".xlsx")) {
            type = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        } else if (extension.equals(".xml")) {
            type = "text/xml";
        } else if (extension.equals(".zip")) {
            type = "application/zip";
        } else {
            type = "application/octet-stream";
        }
        return type;
    }

    /**
     * <br>[機  能] multipart/formdataのリクエストボディ情報(Part)を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param param パラメータ情報
     * @return コンテントタイプ文字列
     */
    private List<HttpPart> __getPartList(Cmn340ParamModel param) {
        List<HttpPart> partList = new ArrayList<>();
        Map<Integer, Cmn340ConnectParam> bodyMap = param.getCmn340CapMap();
        for (Map.Entry<Integer, Cmn340ConnectParam> entry : bodyMap.entrySet()) {
            Cmn340ConnectParam bodyParam = entry.getValue();
            if (bodyParam.getCmn340FileDirNum() > 0) {
                //添付ファイル
                List<CmnBinfModel> binList =
                    __getTestFiles(reqMdl__, bodyParam.getCmn340FileDirNum());
                for (CmnBinfModel binMdl : binList) {
                    HttpPart part = new HttpPart();
                    part.setParamName(bodyParam.getCmn340CapName());
                    part.setFile(new File(binMdl.getBinFilePath()));
                    String fileName = binMdl.getBinFileName();
                    part.setFileName(fileName);
                    part.setFileContentType(__getFileContentType(
                        fileName.substring(fileName.lastIndexOf("."))));
                    partList.add(part);
                }
            } else {
                //テキスト
                String[] values = bodyParam.getCmn340CapValue();
                if (values == null) {
                    HttpPart part = new HttpPart();
                    part.setParamName(bodyParam.getCmn340CapName());
                    part.setStrValue("");
                    partList.add(part);
                }
                for (String value : values) {
                    HttpPart part = new HttpPart();
                    part.setParamName(bodyParam.getCmn340CapName());
                    part.setStrValue(value);
                    partList.add(part);
                }
            }
        }
        return partList;
    }

    /**
     * <br>[機  能] 接続テスト処理を実行する
     * <br>[解  説]
     * <br>[備  考] 外部接続を行うため、利用前にDBのコネクションを破棄しておくこと
     * @param param パラメータモデル
     * @param reqMdl リクエスト情報
     * @return テスト結果レスポンス
     * @throws InterruptedException
     * @throws IOException
     * @throws SQLException
     * @throws EncryptionException
     */
    public String doTest(RequestModel reqMdl, Cmn340ParamModel param)
        throws EncryptionException, SQLException, IOException, InterruptedException {

        Map<String, String> reqMap = null;
        if (param.getCmn340TestHeader() != null) {
            reqMap = Arrays.stream(param.getCmn340TestHeader())
                .map(s -> s.split(":"))
                .collect(Collectors.toMap(header -> header[0], header -> header[1]));
        }
        String contentType = null;
        if (param.getCmn340CacMethod() != EnumMethod.GET.getValue()
            && param.getCmn340CacMethod() != EnumMethod.DELETE.getValue()) {
            if (param.getCmn340CacContent() == 0) {
                contentType = param.getCmn340CacContentManual();
            } else {
                contentType = EnumContentType.valueOf(param.getCmn340CacContent()).getLabel();
            }
        }

        List<HttpPart> partList = new ArrayList<>();
        if (Objects.equals(contentType, EnumContentType.MULTIPART_FORM_DATA.getLabel())) {
            partList = __getPartList(param);
        }
        ApiExecuter exe = new ApiExecuter(
            param.getCmn340TestUrl(), param.getCmn340CacMethod(),
            reqMap, contentType, partList, param.getCmn340TestBody());

        try {
            HttpResponseModel resMdl = exe.execute();
            ApiConnectBiz apiBiz = new ApiConnectBiz();
            return apiBiz.getApiResultText(resMdl, reqMdl);
        } catch (HttpTimeoutException e) {
            GsMessage gsMessage = new GsMessage(reqMdl);
            StringBuilder sb = new StringBuilder();
            sb.append(gsMessage.getMessage("cmn.api.error"));
            sb.append("\r\n");
            sb.append(gsMessage.getMessage("cmn.api.error.timeout"));
            return sb.toString();
        } catch (Exception e) {
            GsMessage gsMessage = new GsMessage(reqMdl);
            StringBuilder sb = new StringBuilder();
            sb.append(gsMessage.getMessage("cmn.api.error"));
            return sb.toString();
        }
    }

    /**
     * <br>[機  能] 接続テストに使用する添付ファイル情報を取得する
     * <br>[解  説]
     * <br>[備  考] multipart/formdata時のみ実行される
     * @param reqMdl リクエスト情報
     * @param fileDirNum 添付ファイル格納ディレクトリID
     * @return 添付ファイル情報一覧
     */
    private List<CmnBinfModel> __getTestFiles(RequestModel reqMdl, int fileDirNum) {

        List<CmnBinfModel> ret = new ArrayList<>();
        GSTemporaryPathUtil temp = GSTemporaryPathUtil.getInstance();
        String tempDir = temp.getTempPath(reqMdl,
                GSConstCommon.PLUGIN_ID_COMMON, "cmn340");
        tempDir += String.valueOf(fileDirNum);

        try {
            //テンポラリディレクトリにあるファイル名称を取得
            List<String>fileList = IOTools.getFileNames(tempDir);
            if (fileList != null) {
                for (String fileName : fileList) {
                    //実体ファイル以外では実行しない
                    if (!fileName.endsWith(GSConstCommon.ENDSTR_SAVEFILE)) {
                        continue;
                    }
                    String filePath = IOTools.replaceFileSep(tempDir + "/" + fileName);
                    CmnBinfModel binMdl = new CmnBinfModel();
                    binMdl.setBinFilePath(filePath);
                    String fileNum = fileName.substring(
                        0, fileName.indexOf(GSConstCommon.ENDSTR_SAVEFILE));

                    //ファイル名を保存しているobjファイルからファイル名を取得
                    ObjectFile objFile = new ObjectFile(
                        tempDir, fileNum + GSConstCommon.ENDSTR_OBJFILE);
                    Object fObj = objFile.load();

                    if (fObj == null) {
                        continue;
                    }
                    Cmn110FileModel fMdl = (Cmn110FileModel) fObj;
                    String name = fMdl.getFileName();
                    binMdl.setBinFileName(
                        StringUtilHtml.transToHTmlPlusAmparsant(name));
                    binMdl.setBinFileExtension(name.substring(name.lastIndexOf(".")));
                    ret.add(binMdl);
                }
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    /**
     * <br>[機  能] 指定したGSAPIの情報を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param con コネクション
     * @param cagSid 連携可能APIのSID
     * @return API一覧
     * @throws SQLException
     * @throws JDOMException
     * @throws SAXException
     * @throws ParserConfigurationException
     * @throws IOException 設定ファイルの読み込みに失敗
     * @throws ClassNotFoundException APIクラスが存在しない
     */
    protected JSONObject _getGsApiInfo(
        Connection con, int cagSid) throws SQLException,
            ParserConfigurationException, SAXException, IOException, JDOMException {

        CmnApiConnectGsapiDao cagDao = new CmnApiConnectGsapiDao(con);
        CmnApiConnectGsapiModel cagMdl = cagDao.select(cagSid);
        if (cagMdl == null) {
            return null;
        }

        JSONObject ret = new JSONObject();
        ret.element("url", cagMdl.getCagPath());
        ret.element("plugin", cagMdl.getCagPlugin());
        ret.element("cagSid", cagMdl.getCagSid());
        ret.element("method", cagMdl.getCagMethodKbn());
        ret.element("contentKbn", cagMdl.getCacContentKbn());

        CmnApiConnectGsparamDao cagpDao = new CmnApiConnectGsparamDao(con);
        List<CmnApiConnectGsparamModel> cagpList = cagpDao.select(cagSid);
        List<CmnApiConnectGsparamModel> orderedList = new ArrayList<>();

        //URLに記載されている順にパラメータを並び替える
        ApiConnectBiz apiBiz = new ApiConnectBiz();
        List<String> pathParamName = apiBiz.getPathParameterName(cagMdl.getCagPath());
        for (String name : pathParamName) {
            for (CmnApiConnectGsparamModel mdl : cagpList) {
                if (mdl.getCagpKbn() == GSConstCommon.PARAM_KBN_PATH
                    && Objects.equals(name, mdl.getCagpName())) {
                    orderedList.add(mdl);
                    break;
                }
            }
        }

        List<String> queryParamName = apiBiz.getQueryParameterName(cagMdl.getCagPath());
        for (String name : queryParamName) {
            for (CmnApiConnectGsparamModel mdl : cagpList) {
                if (mdl.getCagpKbn() == GSConstCommon.PARAM_KBN_QUERY
                    && Objects.equals(name, mdl.getCagpName())) {
                    orderedList.add(mdl);
                    break;
                }
            }
        }

        String reqBody = cagMdl.getCagBody();
        if (cagMdl.getCacContentKbn() == EnumContentType.MULTIPART_FORM_DATA.getValue()) {
            Pattern pattern = Pattern.compile(" name=.+?(\\r\\n|;)");
            Matcher matcher = pattern.matcher(reqBody);
            while (matcher.find()) {
                String valiableName = matcher.group().substring(6);
                if (Objects.equals(matcher.group(1), ";")) {
                    valiableName = valiableName.substring(0, valiableName.length() - 1);
                } else {
                    valiableName = valiableName.substring(0, valiableName.length() - 2);
                }
                for (CmnApiConnectGsparamModel mdl : cagpList) {
                    if (mdl.getCagpKbn() == GSConstCommon.PARAM_KBN_BODY
                        && Objects.equals(valiableName, mdl.getCagpName())) {
                        orderedList.add(mdl);
                        break;
                    }
                }
            }
        } else {
            List<Cmn340JsonModel> bodyList = apiBiz.getParamList(
                cagMdl.getCagBody(), cagMdl.getCacContentKbn());
            for (Cmn340JsonModel body : bodyList) {
                for (CmnApiConnectGsparamModel mdl : cagpList) {
                    if (Objects.equals(body.getParamName(), mdl.getCagpName())) {
                        orderedList.add(mdl);
                        break;
                    }
                }
                if (body.getChild() != null) {
                    for (Cmn340JsonModel child : body.getChild()) {
                        for (CmnApiConnectGsparamModel mdl : cagpList) {
                            if (Objects.equals(
                                body.getParamName() + "." + child.getParamName(),
                                mdl.getCagpName())) {
                                orderedList.add(mdl);
                                break;
                            }
                        }
                    }
                }
            }
        }

        if (orderedList != null) {
            ret.element("paramList", orderedList);
        }
        return ret;
    }
}
