package jp.groupsession.v2.cmn.cmn340;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;

/**
 * <p>CMN340 Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class Cmn340Dao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(Cmn340Dao.class);

    /**
     * <p>Default Constructor
     */
    public Cmn340Dao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public Cmn340Dao(Connection con) {
        super(con);
    }

    /**
     * <br>[機  能]API使用チェック
     * <br>[解  説]
     * <br>[備  考]
     * @return int 0:API使用不可 1:BASIC認証 2:トークン認証 BASICとトークン両方が許可されている場合トークン優先
     * @throws SQLException
     */
    public int selectApiConfCheck() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        int ret = 0;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   APC_TOAKEN_USE,");
            sql.addSql("   APC_BASIC_USE");
            sql.addSql(" from ");
            sql.addSql("   API_CONF");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                int tokenKbn = rs.getInt("APC_TOAKEN_USE");
                int basicKbn = rs.getInt("APC_BASIC_USE");
                if (tokenKbn != 0) {
                    ret = 2;
                } else if (basicKbn != 0) {
                    ret = 1;
                } 
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

}
