package jp.groupsession.v2.cmn.cmn340;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.LabelValueBean;
import org.jdom2.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.ValidateUtil;
import jp.co.sjts.util.struts.StrutsUtil;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.GSValidateCommon;
import jp.groupsession.v2.cmn.biz.apiconnect.ApiConnectBiz;
import jp.groupsession.v2.cmn.biz.apiconnect.EnumAuth;
import jp.groupsession.v2.cmn.biz.apiconnect.EnumContentType;
import jp.groupsession.v2.cmn.biz.apiconnect.EnumMethod;
import jp.groupsession.v2.cmn.config.PluginConfig;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectGsapiDao;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectGsapiModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectHeaderModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectParamModel;
import jp.groupsession.v2.struts.AbstractGsForm;
import jp.groupsession.v2.struts.msg.GsMessage;
/**
 *
 * <br>[機  能] 連携API登録 Form
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Cmn340Form extends AbstractGsForm  {
    /** 初期表示フラグ 初期 */
    public static final int INIT_FLG = 0;
    /** 初期表示フラグ 初期済 */
    public static final int NOT_INIT_FLG = 1;
    /** 初期表示フラグ 初期済 */
    public static final EnumSet<EnumContentType> CONTENTTYPE_LIST =
            EnumSet.copyOf(
                EnumSet.allOf(EnumContentType.class)
                .stream()
                .filter(t ->
                    t.equals(EnumContentType.APPLICATION_FORM)
                    || t.equals(EnumContentType.APPLICATION_JSON)
                    || t.equals(EnumContentType.TEXT_XML)
                    || t.equals(EnumContentType.APPLICATION_XML)
                    || t.equals(EnumContentType.MULTIPART_FORM_DATA))
                .collect(Collectors.toList())
            );

    /** 登録モード 追加 | 編集 */
    private int cmn340mode__ = GSConstCommon.MODE_ADD;
    /**初期表示フラグ  */
    private int cmn340init__ = INIT_FLG;
    /** 接続テストdialog表示フラグ */
    private boolean cmn340TestDialogFlg__ = false;

    /** APISID */
    private int cmn340CacSid__ = -1;
    /** API名 */
    private String cmn340CacName__;
    /** 説明 */
    private String cmn340CacDescription__;
    /** URL */
    private String cmn340CacUrl__;
    /** HTTPリクエストメソッド */
    private int cmn340CacMethod__;
    /** Content-Type */
    private int cmn340CacContent__ = EnumContentType.APPLICATION_JSON.getValue();
    /** Content-Type(手入力) */
    private String cmn340CacContentManual__;
    /** リクエストボディ */
    private String cmn340CacBody__;
    /** 認証方式 */
    private int cmn340CacAuth__;
    /** ユーザID */
    private String cmn340CacId__;
    /** パスワード */
    private String cmn340CacPassword__;
    /** トークンキー */
    private String cmn340CacToken__;
    /** パスパラメータ一覧 */
    private TreeMap<Integer, CmnApiConnectParamModel> cmn340PathParamMap__ = new TreeMap<>();
    /** クエリパラメータ一覧 */
    private TreeMap<Integer, CmnApiConnectParamModel> cmn340QueryParamMap__ = new TreeMap<>();
    /** ボディパラメータ一覧 */
    private TreeMap<Integer, CmnApiConnectParamModel> cmn340BodyParamMap__ = new TreeMap<>();
    /** 追加ヘッダー 一覧 */
    private TreeMap<Integer, CmnApiConnectHeaderModel> cmn340RequestHeaderMap__ = new TreeMap<>();

    /** 実行テスト用 ボディパラメータリスト */
    private TreeMap<Integer, Cmn340ConnectParam> cmn340CapMap__ = new TreeMap<>();
    //GS API用パラメータ
    /** プラグイン */
    private String cmn340CacPlugin__ = null;
    /** GS API */
    private int cmn340CacGsApi__ = 0;
    /** プラグイン一覧 */
    private List<LabelValueBean> cmn340CacPluginList__ = null;
    /** GS API一覧 */
    private List<CmnApiConnectGsapiModel> cmn340CacApiList__ = null;
    /** メッセージ表示フラグ*/
    private int cmn340MessageFlg__ = 0;
    /** 連携API更新エラー表示フラグ */
    private int cmn340VerErrorFlg__ = 0;
    /** 接続テスト URL */
    private String cmn340TestUrl__ = null;
    /** 接続テスト リクエストヘッダ */
    private String[] cmn340TestHeader__ = null;
    /** 接続テスト リクエストボディ */
    private String cmn340TestBody__ = null;
    /** 接続テスト 添付ファイルアップロード ディレクトリ */
    private int cmn340TestFileDir__;
    /** GSAPIバージョンエラー文字列 */
    private String cmn340GsApiErrorText__;

    /**
     * @return the cmn340mode
     */
    public int getCmn340mode() {
        return cmn340mode__;
    }

    /**
     * @param cmn340mode the cmn340mode to set
     */
    public void setCmn340mode(int cmn340mode) {
        cmn340mode__ = cmn340mode;
    }

    /**
     * @return the cmn340init
     */
    public int getCmn340init() {
        return cmn340init__;
    }

    /**
     * @param cmn340init the cmn340init to set
     */
    public void setCmn340init(int cmn340init) {
        cmn340init__ = cmn340init;
    }

    /**
     * @return the cmn340TestDialogFlg
     */
    public boolean isCmn340TestDialogFlg() {
        return cmn340TestDialogFlg__;
    }

    /**
     * @param cmn340TestDialogFlg the cmn340TestDialogFlg to set
     */
    public void setCmn340TestDialogFlg(boolean cmn340TestDialogFlg) {
        cmn340TestDialogFlg__ = cmn340TestDialogFlg;
    }

    /**
     * @return the cmn340CacSid
     */
    public int getCmn340CacSid() {
        return cmn340CacSid__;
    }

    /**
     * @param cmn340CacSid the cmn340CacSid to set
     */
    public void setCmn340CacSid(int cmn340CacSid) {
        cmn340CacSid__ = cmn340CacSid;
    }

    /**
     * @return the cmn340CacName
     */
    public String getCmn340CacName() {
        return cmn340CacName__;
    }

    /**
     * @param cmn340CacName the cmn340CacName to set
     */
    public void setCmn340CacName(String cmn340CacName) {
        cmn340CacName__ = cmn340CacName;
    }

    /**
     * @return the cmn340CacDescription
     */
    public String getCmn340CacDescription() {
        return cmn340CacDescription__;
    }

    /**
     * @param cmn340CacDescription the cmn340CacDescription to set
     */
    public void setCmn340CacDescription(String cmn340CacDescription) {
        cmn340CacDescription__ = cmn340CacDescription;
    }

    /**
     * @return the cmn340CacUrl
     */
    public String getCmn340CacUrl() {
        return cmn340CacUrl__;
    }

    /**
     * @param cmn340CacUrl the cmn340CacUrl to set
     */
    public void setCmn340CacUrl(String cmn340CacUrl) {
        cmn340CacUrl__ = cmn340CacUrl;
    }

    /**
     * @return the cmn340CacMethod
     */
    public int getCmn340CacMethod() {
        return cmn340CacMethod__;
    }

    /**
     * @param cmn340CacMethod the cmn340CacMethod to set
     */
    public void setCmn340CacMethod(int cmn340CacMethod) {
        cmn340CacMethod__ = cmn340CacMethod;
    }

    /**
     * @return the cmn340CacContent
     */
    public int getCmn340CacContent() {
        return cmn340CacContent__;
    }

    /**
     * @param cmn340CacContent the cmn340CacContent to set
     */
    public void setCmn340CacContent(int cmn340CacContent) {
        cmn340CacContent__ = cmn340CacContent;
    }

    /**
     * @return the cmn340CacContentManual
     */
    public String getCmn340CacContentManual() {
        return cmn340CacContentManual__;
    }

    /**
     * @param cmn340CacContentManual the cmn340CacContentManual to set
     */
    public void setCmn340CacContentManual(String cmn340CacContentManual) {
        cmn340CacContentManual__ = cmn340CacContentManual;
    }

    /**
     * @return the cmn340CacBody
     */
    public String getCmn340CacBody() {
        return cmn340CacBody__;
    }

    /**
     * @param cmn340CacBody the cmn340CacBody to set
     */
    public void setCmn340CacBody(String cmn340CacBody) {
        cmn340CacBody__ = cmn340CacBody;
    }

    /**
     * @return the cmn340CacAuth
     */
    public int getCmn340CacAuth() {
        return cmn340CacAuth__;
    }

    /**
     * @param cmn340CacAuth the cmn340CacAuth to set
     */
    public void setCmn340CacAuth(int cmn340CacAuth) {
        cmn340CacAuth__ = cmn340CacAuth;
    }

    /**
     * @return the cmn340CacId
     */
    public String getCmn340CacId() {
        return cmn340CacId__;
    }

    /**
     * @param cmn340CacId the cmn340CacId to set
     */
    public void setCmn340CacId(String cmn340CacId) {
        cmn340CacId__ = cmn340CacId;
    }

    /**
     * @return the cmn340CacPassword
     */
    public String getCmn340CacPassword() {
        return cmn340CacPassword__;
    }

    /**
     * @param cmn340CacPassword the cmn340CacPassword to set
     */
    public void setCmn340CacPassword(String cmn340CacPassword) {
        cmn340CacPassword__ = cmn340CacPassword;
    }

    /**
     * @return the cmn340CacToken
     */
    public String getCmn340CacToken() {
        return cmn340CacToken__;
    }

    /**
     * @param cmn340CacToken the cmn340CacToken to set
     */
    public void setCmn340CacToken(String cmn340CacToken) {
        cmn340CacToken__ = cmn340CacToken;
    }

    /**
     * @return the cmn340PathParamMap
     */
    public TreeMap<Integer, CmnApiConnectParamModel> getCmn340PathParamMap() {
        return cmn340PathParamMap__;
    }

    /**
     * @param cmn340PathParamMap the cmn340PathParamMap to set
     */
    public void setCmn340PathParamMap(
            TreeMap<Integer, CmnApiConnectParamModel> cmn340PathParamMap) {
        cmn340PathParamMap__ = cmn340PathParamMap;
    }

    /**
     * @return the cmn340QueryParamMap
     */
    public TreeMap<Integer, CmnApiConnectParamModel> getCmn340QueryParamMap() {
        return cmn340QueryParamMap__;
    }

    /**
     * @param cmn340QueryParamMap the cmn340QueryParamMap to set
     */
    public void setCmn340QueryParamMap(
            TreeMap<Integer, CmnApiConnectParamModel> cmn340QueryParamMap) {
        cmn340QueryParamMap__ = cmn340QueryParamMap;
    }

    /**
     * @return the cmn340BodyParamMap
     */
    public TreeMap<Integer, CmnApiConnectParamModel> getCmn340BodyParamMap() {
        return cmn340BodyParamMap__;
    }

    /**
     * @param cmn340BodyParamMap the cmn340BodyParamMap to set
     */
    public void setCmn340BodyParamMap(
            TreeMap<Integer, CmnApiConnectParamModel> cmn340BodyParamMap) {
        cmn340BodyParamMap__ = cmn340BodyParamMap;
    }

    /**
     * @return the cmn340RequestHeaderMap
     */
    public TreeMap<Integer, CmnApiConnectHeaderModel> getCmn340RequestHeaderMap() {
        return cmn340RequestHeaderMap__;
    }

    /**
     * @param cmn340RequestHeaderMap the cmn340RequestHeaderMap to set
     */
    public void setCmn340RequestHeaderMap(
            TreeMap<Integer, CmnApiConnectHeaderModel> cmn340RequestHeaderMap) {
        cmn340RequestHeaderMap__ = cmn340RequestHeaderMap;
    }

    /**
     * @return the cmn340CapMap
     */
    public TreeMap<Integer, Cmn340ConnectParam> getCmn340CapMap() {
        return cmn340CapMap__;
    }

    /**
     * @param cmn340CapMap the cmn340CapMap to set
     */
    public void setCmn340CapMap(TreeMap<Integer, Cmn340ConnectParam> cmn340CapMap) {
        cmn340CapMap__ = cmn340CapMap;
    }

    /**
     * @return the cmn340CacPlugin
     */
    public String getCmn340CacPlugin() {
        return cmn340CacPlugin__;
    }

    /**
     * @param cmn340CacPlugin the cmn340CacPlugin to set
     */
    public void setCmn340CacPlugin(String cmn340CacPlugin) {
        cmn340CacPlugin__ = cmn340CacPlugin;
    }

    /**
     * @return the cmn340CacGsApi
     */
    public int getCmn340CacGsApi() {
        return cmn340CacGsApi__;
    }

    /**
     * @param cmn340CacGsApi the cmn340CacGsApi to set
     */
    public void setCmn340CacGsApi(int cmn340CacGsApi) {
        cmn340CacGsApi__ = cmn340CacGsApi;
    }

    /**
     * @return the cmn340CacPluginList
     */
    public List<LabelValueBean> getCmn340CacPluginList() {
        return cmn340CacPluginList__;
    }

    /**
     * @param cmn340CacPluginList the cmn340CacPluginList to set
     */
    public void setCmn340CacPluginList(List<LabelValueBean> cmn340CacPluginList) {
        cmn340CacPluginList__ = cmn340CacPluginList;
    }

    /**
     * @return the cmn340CacApiList
     */
    public List<CmnApiConnectGsapiModel> getCmn340CacApiList() {
        return cmn340CacApiList__;
    }

    /**
     * @param cmn340CacApiList the cmn340CacApiList to set
     */
    public void setCmn340CacApiList(
            List<CmnApiConnectGsapiModel> cmn340CacApiList) {
        cmn340CacApiList__ = cmn340CacApiList;
    }

    /**
     * @return the cmn340MessageFlg
     */
    public int getCmn340MessageFlg() {
        return cmn340MessageFlg__;
    }

    /**
     * @param cmn340MessageFlg the cmn340MessageFlg to set
     */
    public void setCmn340MessageFlg(int cmn340MessageFlg) {
        cmn340MessageFlg__ = cmn340MessageFlg;
    }

    /**
     * @return the cmn340VerErrorFlg
     */
    public int getCmn340VerErrorFlg() {
        return cmn340VerErrorFlg__;
    }

    /**
     * @param cmn340VerErrorFlg the cmn340VerErrorFlg to set
     */
    public void setCmn340VerErrorFlg(int cmn340VerErrorFlg) {
        cmn340VerErrorFlg__ = cmn340VerErrorFlg;
    }

    /**
     * @return the cmn340TestUrl
     */
    public String getCmn340TestUrl() {
        return cmn340TestUrl__;
    }

    /**
     * @param cmn340TestUrl the cmn340TestUrl to set
     */
    public void setCmn340TestUrl(String cmn340TestUrl) {
        cmn340TestUrl__ = cmn340TestUrl;
    }

    /**
     * @return the cmn340TestHeader
     */
    public String[] getCmn340TestHeader() {
        return cmn340TestHeader__;
    }

    /**
     * @param cmn340TestHeader the cmn340TestHeader to set
     */
    public void setCmn340TestHeader(String[] cmn340TestHeader) {
        cmn340TestHeader__ = cmn340TestHeader;
    }

    /**
     * @return the cmn340TestBody
     */
    public String getCmn340TestBody() {
        return cmn340TestBody__;
    }

    /**
     * @param cmn340TestBody the cmn340TestBody to set
     */
    public void setCmn340TestBody(String cmn340TestBody) {
        cmn340TestBody__ = cmn340TestBody;
    }

    /**
     * @return the cmn340TestFileDir
     */
    public int getCmn340TestFileDir() {
        return cmn340TestFileDir__;
    }

    /**
     * @param cmn340TestFileDir the cmn340TestFileDir to set
     */
    public void setCmn340TestFileDir(int cmn340TestFileDir) {
        cmn340TestFileDir__ = cmn340TestFileDir;
    }

    /**
     * @return the cmn340GsApiErrorText
     */
    public String getCmn340GsApiErrorText() {
        return cmn340GsApiErrorText__;
    }

    /**
     * @param cmn340GsApiErrorText the cmn340GsApiErrorText to set
     */
    public void setCmn340GsApiErrorText(String cmn340GsApiErrorText) {
        cmn340GsApiErrorText__ = cmn340GsApiErrorText;
    }

    /**
     * <p>getCmn340PathParam[index] を取得します。
     * @param index 添字
     * @return getCmn340PathParam[index]
     * @see jp.groupsession.v2.cmn.cmn340.Cmn340Form#cmn340PathParamMap__
     */
    public CmnApiConnectParamModel getCmn340PathParam(int index) {

        if (!cmn340PathParamMap__.containsKey(index)) {
            cmn340PathParamMap__.put(index, new CmnApiConnectParamModel());
        }
        return cmn340PathParamMap__.get(index);
    }

    /**
     * <p>getCmn340QueryParam[index] を取得します。
     * @param index 添字
     * @return getCmn340QueryParam[index]
     * @see jp.groupsession.v2.cmn.cmn340.Cmn340Form#cmn340QueryParamMap__
     */
    public CmnApiConnectParamModel getCmn340QueryParam(int index) {

        if (!cmn340QueryParamMap__.containsKey(index)) {
            cmn340QueryParamMap__.put(index, new CmnApiConnectParamModel());
        }
        return cmn340QueryParamMap__.get(index);
    }

    /**
     * <p>getCmn340RequestHeader[index] を取得します。
     * @param index 添字
     * @return getCmn340RequestHeader[index]
     * @see jp.groupsession.v2.cmn.cmn340.Cmn340Form#cmn340RequestHeaderMap__
     */
    public CmnApiConnectHeaderModel getCmn340RequestHeader(int index) {

        if (!cmn340RequestHeaderMap__.containsKey(index)) {
            cmn340RequestHeaderMap__.put(index, new CmnApiConnectHeaderModel());
        }
        return cmn340RequestHeaderMap__.get(index);
    }

    /**
     * <p>getCmn340Param[index] を取得します。
     * @param index 添字
     * @return getCmn340BodyParam[index]
     * @see jp.groupsession.v2.cmn.cmn340.Cmn340Form#cmn340BodyParamMap__
     */
    public CmnApiConnectParamModel getCmn340BodyParam(int index) {

        if (!cmn340BodyParamMap__.containsKey(index)) {
            cmn340BodyParamMap__.put(index, new CmnApiConnectParamModel());
        }
        return cmn340BodyParamMap__.get(index);
    }

    /**
     * <p>cmn340CapParam[index] を取得します。
     * @param index 添字
     * @return cmn340CapParam[index]
     * @see jp.groupsession.v2.cmn.cmn340.Cmn340Form#cmn340CapMap__
     */
    public Cmn340ConnectParam getCmn340CapParam(int index) {

        if (!cmn340CapMap__.containsKey(index)) {
            cmn340CapMap__.put(index, new Cmn340ConnectParam());
        }
        return cmn340CapMap__.get(index);
    }

    /**
     *
     * <br>[機  能] 表示用コンテントタイプリストを返す
     * <br>[解  説]
     * <br>[備  考]
     * @return 表示用コンテントタイプリスト
     */
    public EnumSet<EnumContentType> getContentTypeList() {
        return CONTENTTYPE_LIST;
    }

    /**
     * <br>[機  能] 登録時の入力チェックを行う
     * <br>[解  説]
     * <br>[備  考]
     * @param reqMdl リクエスト情報
     * @param con コネクション
     * @param pconfig PluginConfig
     * @param appRootPath AppRootPath
     * @param insertFlg true:登録時チェック，false:接続テスト時チェック
     * @return ActionErrors
     * @throws IOException, ClassNotFoundException {
     * @throws SQLException 
     */
    public ActionErrors validateCheck(
        RequestModel reqMdl, Connection con,
        PluginConfig pconfig, String appRootPath, boolean insertFlg)
    throws IOException, ClassNotFoundException, SQLException,
        ParserConfigurationException, SAXException, JDOMException {
        ActionErrors errors = new ActionErrors();
        GsMessage gsMsg = new GsMessage(reqMdl);

        //ベースAPI
        if (insertFlg && cmn340CacGsApi__ != 0) {
            CmnApiConnectGsapiDao cagDao = new CmnApiConnectGsapiDao(con);
            CmnApiConnectGsapiModel cagMdl = cagDao.select(cmn340CacGsApi__);
            if (cagMdl == null) {
                ActionMessage msg = new ActionMessage(
                    "search.data.notfound", gsMsg.getMessage("cmn.cmn340.61"));
                StrutsUtil.addMessage(errors, msg, "cmn340CacGsApi");
            }
        }

        //共通項目のvalidateチェック
        //API名
        if (insertFlg) {
            GSValidateCommon.validateTextField(errors, cmn340CacName__,
                    "cmn340CacName", gsMsg.getMessage("cmn.cmn340.02"),
                    GSConstCommon.MAXLEN_CAC_NAME, true);
        }

        //説明
        if (insertFlg) {
            GSValidateCommon.validateTextField(errors, cmn340CacDescription__,
                    "cmn340CacDescription", gsMsg.getMessage("ptl.8"),
                    GSConstCommon.MAXLEN_CAC_DESCRIPTION, false);
        }

        //URL
        GSValidateCommon.validateTextField(errors, cmn340CacUrl__,
                "cmn340CacUrl", gsMsg.getMessage("cmn.cmn340.03"),
                GSConstCommon.MAXLEN_CAC_URL, true);

        //URL文字列自体が正常に入力されている場合、その内容をチェック
        if (!StringUtil.isNullZeroString(cmn340CacUrl__)) {
            //URLフォーマットチェック
            if (!ValidateUtil.isHttpUrlFormat(cmn340CacUrl__)) {
                ActionMessage msg = new ActionMessage(
                    "error.input.format.text", gsMsg.getMessage("cmn.url"));
                errors.add("error.input.format.text", msg);
            } else {
                //URLフォーマットチェックを通った場合、URLの中に使用できない文字が含まれていないかをチェック
                String targetText = cmn340CacUrl__;
                String regex = "\\$\\{.+?\\}";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(targetText);
                while (matcher.find()) {
                    targetText = targetText.replaceAll(Pattern.quote(matcher.group()), "");
                }
                try {
                    URI.create(targetText);
                } catch (IllegalArgumentException e) {
                    ActionMessage msg = new ActionMessage(
                        "error.input.njapan.text3", gsMsg.getMessage("cmn.url"));
                    errors.add("error.input.njapan.text3", msg);
                }                
            }

            //URLの${}の中に"$", "{", "}", "."があるかをチェック
            __checkParameterBan(errors, cmn340CacUrl__, gsMsg.getMessage("cmn.url"), false);

            int queryCharIndex = cmn340CacUrl__.indexOf("?");
            String pathUrl = "";
            String queryUrl = "";
            if (queryCharIndex == -1) {
                pathUrl = cmn340CacUrl__;
            } else {
                pathUrl = cmn340CacUrl__.substring(0, queryCharIndex);
                queryUrl = cmn340CacUrl__.substring(queryCharIndex + 1);
            }

            //パスパラメータ URL内パラメータ重複チェック
            String regex = "\\$\\{.+?\\}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(pathUrl);
            Set<String> resultSet = new HashSet<String>();
            while (matcher.find()) {
                if (!resultSet.add(matcher.group())) {
                    ActionMessage msg = new ActionMessage(
                        "errors.free.msg", gsMsg.getMessage("cmn.cmn340.84"));
                    StrutsUtil.addMessage(errors, msg, "cmn340CacAuth");
                }
            }
            //パスパラメータがURL内に記載されているかチェック
            List<String> pathNameList = cmn340PathParamMap__.entrySet().stream()
                .map(mdl -> mdl.getValue().getCacpName())
                .collect(Collectors.toList());
            int pathCount = 1;
            for (String paramName : pathNameList) {
                if (!resultSet.contains("${" + paramName + "}")) {
                    ActionMessage msg = new ActionMessage(
                        "error.api.not.url.use.path", pathCount);
                    errors.add("error.api.not.url.use.path", msg);
                }
                pathCount++;
            }
            //URLに記載されているパスパラメータがパラメータ一覧に存在するか
            for (String urlParamName : resultSet) {
                if (!pathNameList.contains(urlParamName.substring(2, urlParamName.length() - 1))) {
                    ActionMessage msg = new ActionMessage(
                        "error.api.not.url.exist", gsMsg.getMessage("cmn.cmn340.49"));
                    errors.add("error.api.not.url.exist", msg);
                    break;
                }
            }

            //クエリパラメータ URL内パラメータ重複チェック
            matcher = pattern.matcher(queryUrl);
            resultSet = new HashSet<String>();
            while (matcher.find()) {
                if (!resultSet.add(matcher.group())) {
                    ActionMessage msg = new ActionMessage(
                        "errors.free.msg", gsMsg.getMessage("cmn.cmn340.85"));
                    StrutsUtil.addMessage(errors, msg, "cmn340CacAuth");
                }
            }

            //aaa=${aaa}のような形式になっているかを確認
            pattern = Pattern.compile("(.*?)=\\$\\{\\1\\}");
            matcher = pattern.matcher(queryUrl);
            int withNameCount = 0;
            while (matcher.find()) {
                withNameCount++;
            }
            pattern = Pattern.compile("\\$\\{.+?\\}");
            matcher = pattern.matcher(queryUrl);
            int onlyValueCount = 0;
            while (matcher.find()) {
                onlyValueCount++;
            }
            if (withNameCount != onlyValueCount) {
                ActionMessage msg = new ActionMessage(
                    "error.api.url.format", "${" + gsMsg.getMessage("cmn.cmn340.14") + "}");
                errors.add("error.api.url.format", msg);
            }
            //クエリパラメータがURL内に記載されているかチェック
            List<String> queryNameList = cmn340QueryParamMap__.entrySet().stream()
                .map(mdl -> mdl.getValue().getCacpName())
                .collect(Collectors.toList());
            int queryCount = 1;
            for (String queryParam : queryNameList) {
                if (!resultSet.contains("${" + queryParam + "}")) {
                    ActionMessage msg = new ActionMessage(
                        "error.api.not.url.use.query", queryCount);
                    errors.add("error.api.not.url.use.query", msg);
                }
                queryCount++;
            }
            //URLに記載されているクエリパラメータがパラメータ一覧に存在するか
            for (String urlQueryName : resultSet) {
                if (!queryNameList.contains(urlQueryName.substring(2, urlQueryName.length() - 1))) {
                    ActionMessage msg = new ActionMessage(
                        "error.api.not.url.exist", gsMsg.getMessage("cmn.cmn340.52"));
                    errors.add("error.api.not.url.exist", msg);
                    break;
                }
            }
        }
        
        //パスパラメータ
        Set<Entry<Integer, CmnApiConnectParamModel>> pathEs = cmn340PathParamMap__.entrySet();
        Set<String> paramNameSet = new HashSet<>();
        Set<String> paramDispNameSet = new HashSet<>();
        int lineCount = 1;
        for (Map.Entry<Integer, CmnApiConnectParamModel> entry : pathEs) {
            CmnApiConnectParamModel paramMdl = entry.getValue();
            String paramName = gsMsg.getMessage("cmn.cmn340.49")
                + gsMsg.getMessage("cmn.line2", new String[] {String.valueOf(lineCount)});

            if (!StringUtil.isNullZeroString(paramMdl.getCacpName())
                && !paramNameSet.add(paramMdl.getCacpName())) {
                //パスパラメータ 重複
                ActionMessage msg = new ActionMessage("error.select.dup.list",
                    gsMsg.getMessage("cmn.cmn340.49") + " " + gsMsg.getMessage("cmn.cmn340.14"));
                StrutsUtil.addMessage(errors, msg, "error.select.dup.list.path.name");
            }

            if (!StringUtil.isNullZeroString(paramMdl.getCacpNameDisp())
                && !paramDispNameSet.add(paramMdl.getCacpNameDisp())) {
                //パスパラメータ表示名称 重複
                ActionMessage msg = new ActionMessage("error.select.dup.list",
                    gsMsg.getMessage("cmn.cmn340.49") + " " + gsMsg.getMessage("cmn.cmn340.50"));
                StrutsUtil.addMessage(errors, msg, "error.select.dup.list.path.namedisp");
            }
            //パラメータ名チェック
            GSValidateCommon.validateTextField(errors, paramMdl.getCacpName(),
                "pathParamName", 
                paramName + gsMsg.getMessage("cmn.cmn340.14"),
                GSConstCommon.MAXLEN_CAP_NAME, true);

            //表示名称チェック
            GSValidateCommon.validateTextField(errors, paramMdl.getCacpNameDisp(),
                "pathParamNameDisp", 
                paramName + gsMsg.getMessage("cmn.cmn340.50"),
                GSConstCommon.MAXLEN_CAP_NAME_DISP, true);

            //備考チェック
            GSValidateCommon.validateTextField(errors, paramMdl.getCacpBiko(),
                "pathParamBiko", 
                paramName + gsMsg.getMessage("cmn.memo"),
                GSConstCommon.MAXLEN_CAP_BIKO, false);
            lineCount++;
        }

        //クエリパラメータ
        Set<Entry<Integer, CmnApiConnectParamModel>> queryEs = cmn340QueryParamMap__.entrySet();
        paramNameSet = new HashSet<>();
        paramDispNameSet = new HashSet<>();
        lineCount = 1;
        for (Map.Entry<Integer, CmnApiConnectParamModel> entry : queryEs) {
            CmnApiConnectParamModel paramMdl = entry.getValue();
            String paramName = gsMsg.getMessage("cmn.cmn340.52")
                + gsMsg.getMessage("cmn.line2", new String[] {String.valueOf(lineCount)});

            if (!StringUtil.isNullZeroString(paramMdl.getCacpName())
                && !paramNameSet.add(paramMdl.getCacpName())) {
                //クエリパラメータ 重複
                ActionMessage msg = new ActionMessage("error.select.dup.list",
                    gsMsg.getMessage("cmn.cmn340.52") + " " + gsMsg.getMessage("cmn.cmn340.14"));
                StrutsUtil.addMessage(errors, msg, "error.select.dup.list.query.name");
            }
            if (!StringUtil.isNullZeroString(paramMdl.getCacpNameDisp())
                && !paramDispNameSet.add(paramMdl.getCacpNameDisp())) {
                //クエリパラメータ表示名称 重複
                ActionMessage msg = new ActionMessage("error.select.dup.list",
                    gsMsg.getMessage("cmn.cmn340.52") + " " + gsMsg.getMessage("cmn.cmn340.50"));
                StrutsUtil.addMessage(errors, msg, "error.select.dup.list.query.namedisp");
            }
            //パラメータ名チェック
            GSValidateCommon.validateTextField(errors, paramMdl.getCacpName(),
                "queryParamName", 
                paramName + gsMsg.getMessage("cmn.cmn340.14"),
                GSConstCommon.MAXLEN_CAP_NAME, true);
            //表示名称チェック
            GSValidateCommon.validateTextField(errors, paramMdl.getCacpNameDisp(),
                "queryParamNameDisp", 
                paramName + gsMsg.getMessage("cmn.cmn340.50"),
                GSConstCommon.MAXLEN_CAP_NAME_DISP, true);

            //備考チェック
            GSValidateCommon.validateTextField(errors, paramMdl.getCacpBiko(),
                "queryParamBiko", 
                paramName + gsMsg.getMessage("cmn.memo"),
                GSConstCommon.MAXLEN_CAP_BIKO, false);

            //配列トグル
            int listKbn = paramMdl.getCacpListKbn();
            if (listKbn != 0 && listKbn != 1) {
                ActionMessage msg = new ActionMessage("error.input.notvalidate.data",
                    paramName + gsMsg.getMessage("cmn.cmn340.53"));
                errors.add("error.input.notvalidate.data", msg);
            }

            //必須トグル
            int hissuKbn = paramMdl.getCacpRequiredKbn();
            if (hissuKbn != 0 && hissuKbn != 1) {
                ActionMessage msg = new ActionMessage("error.input.notvalidate.data",
                    paramName + gsMsg.getMessage("cmn.required"));
                errors.add("error.input.notvalidate.data", msg);
            }
            lineCount++;
        }

        //リクエストメソッド
        EnumMethod method = EnumMethod.valueOf(cmn340CacMethod__);
        if (method == null) {
            ActionMessage msg = new ActionMessage("error.select3.required.text",
                gsMsg.getMessage("cmn.cmn340.54"));
            errors.add("error.select3.required.text", msg);
        }

        //認証方式
        EnumAuth auth = EnumAuth.valueOf(cmn340CacAuth__);
        if (auth == null) {
            ActionMessage msg = new ActionMessage("error.input.notvalidate.data", 
                    gsMsg.getMessage("cmn.cmn340.10"));
            StrutsUtil.addMessage(errors, msg, "cmn340CacAuth");
        }
        if (auth == EnumAuth.BASIC) {
            GSValidateCommon.validateTextField(errors, cmn340CacId__, "cmn340CacId", 
                    gsMsg.getMessage("cmn.id"), GSConstCommon.MAXLEN_CAC_USER, true);
            GSValidateCommon.validateTextField(errors, cmn340CacPassword__, "cmn340CacPassword", 
                    gsMsg.getMessage("cmn.password"),
                    GSConstCommon.MAXLEN_CAC_PASS, true);
        }
        if (auth == EnumAuth.TOKEN) {
            GSValidateCommon.validateTextField(errors, cmn340CacToken__, "cmn340CacToken",
                    gsMsg.getMessage("cmn.cmn340.16"), GSConstCommon.MAXLEN_CAC_TOKEN, true);
        }

        //データ方式
        __validateContentType(errors, reqMdl);
        EnumContentType contentType = EnumContentType.valueOf(cmn340CacContent__);

        //追加リクエストヘッダ
        Set<Entry<Integer, CmnApiConnectHeaderModel>> headEs = cmn340RequestHeaderMap__.entrySet();
        CmnApiConnectHeaderModel headerMdl = null;
        for (Map.Entry<Integer, CmnApiConnectHeaderModel> entry : headEs) {
            headerMdl = entry.getValue();
            String paramName = gsMsg.getMessage("cmn.cmn340.65")
                + gsMsg.getMessage("cmn.line2", new String[]{String.valueOf(entry.getKey())});
            GSValidateCommon.validateTextField(errors, headerMdl.getCachKey(),
                "cachKey", 
                paramName + gsMsg.getMessage("cmn.cmn340.62"),
                GSConstCommon.MAXLEN_REQ_HEADER_KEY, true);
            GSValidateCommon.validateTextField(errors, headerMdl.getCachValue(),
                "cachValue", 
                paramName + gsMsg.getMessage("cmn.value"),
                GSConstCommon.MAXLEN_REQ_HEADER_VALUE, true);
        }

        //リクエストボディのチェックはContent-Typeによって異なるため、Content-Typeが正常でない場合は処理を終了
        if (contentType == null
            || contentType.getValue() > EnumContentType.MULTIPART_FORM_DATA.getValue()) {
            return errors;
        }

        validateReqBody(errors, reqMdl, false);
        return errors;
    }

    /**
     * <br>[機  能] ContentTypeの入力チェックを行う
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     * @param reqMdl リクエスト情報
     * @throws IOException, ClassNotFoundException {
     */
    private void __validateContentType(ActionErrors errors, RequestModel reqMdl) {
        GsMessage gsMsg = new GsMessage(reqMdl);
        EnumContentType contentType = EnumContentType.valueOf(cmn340CacContent__);
        if (contentType == null
            || contentType.getValue() > EnumContentType.MULTIPART_FORM_DATA.getValue()) {
            ActionMessage msg = new ActionMessage(
                    "error.input.notvalidate.data",
                    gsMsg.getMessage("cmn.cmn340.56"));
            StrutsUtil.addMessage(errors, msg, "cmn340CacContent");
        }
        if (contentType == EnumContentType.MANUAL) {
            GSValidateCommon.validateTextField(errors, cmn340CacContentManual__,
                "cmn340CacContentManual", 
                gsMsg.getMessage("cmn.cmn340.56") + " " + gsMsg.getMessage("cmn.cmn340.60"),
                GSConstCommon.MAXLEN_CAC_CONTENT, true);
        }
    }

    /**
     * <br>[機  能] パラメータ名に禁止された文字列($, {, }, .)が含まれているかを確認する
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     * @param targetText チェック対象文字列
     * @param paramName 画面表示用パラメータ名
     * @param isJsonXml true:JSONもしくはXML, JSON, XMLではない
     * @return true:エラーを追加，false:エラーを追加していない
     * @throws IOException, ClassNotFoundException {
     */
    private boolean __checkParameterBan(
        ActionErrors errors, String targetText, String paramName, boolean isJsonXml) {

        Pattern pattern = Pattern.compile("\\$\\{.+?\\}");
        Matcher matcher = pattern.matcher(targetText);
        while (matcher.find()) {
            String name = matcher.group();
            
            //チェック対象になっていたテキストの${変数名}を適当な文字に置き換える
            targetText = targetText.replace(name, "valiable");
            //${変数名}から変数名だけを取り出し、その中に.が含まれているかを確認する
            name = name.substring(2, name.length() - 1);
            if (name.contains(".")
                || name.contains("$")
                || name.contains("{")
                || name.contains("}")) {
                ActionMessage msg = new ActionMessage(
                    "error.api.parameter.ban", paramName);
                errors.add("error.api.parameter.ban", msg);
                return true;
            }
        }
        if (!isJsonXml) {
            //変数名以外で$, {, }が入力されているかの確認
            if (targetText.contains("$") || targetText.contains("{") || targetText.contains("}")) {
                ActionMessage msg = new ActionMessage("error.api.parameter.ban", paramName);
                errors.add("error.api.parameter.ban", msg);
                return true;
            }
        }

        return false;
    }

    /**
     * <br>[機  能] リクエストボディの入力チェックを行う
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     * @param reqMdl リクエスト情報
     * @param createFlg true:ボディパラメータ作成時, false:ボディパラメータ作成時ではない
     * @throws IOException, ClassNotFoundException {
     */
    public void validateReqBody(ActionErrors errors, RequestModel reqMdl, boolean createFlg)
        throws ParserConfigurationException, SAXException, IOException, JDOMException {

        //コンテントタイプのチェック
        __validateContentType(errors, reqMdl);

        EnumMethod method = EnumMethod.valueOf(cmn340CacMethod__);
        //リクエストメソッドがPOST, PUT, DELETE以外のときはリクエストボディを使用しないため処理を終了
        if (method != EnumMethod.POST && method != EnumMethod.PUT && method != EnumMethod.PATCH) {
            return;
        }

        //multipart/formdataの場合は、リクエストボディに何も入力しない為ボディパラメータ一覧のみをチェック
        EnumContentType contentType = EnumContentType.valueOf(cmn340CacContent__);
        if (contentType == null) {
            return;
        }
        if (contentType.equals(EnumContentType.MULTIPART_FORM_DATA)) {
            if (!createFlg) {
                //パラメータ作成時以外は、ボディパラメータ一覧のチェックを行う
                __checkBodyParamMap(errors, reqMdl);
            }
            return;
        }
        GsMessage gsMsg = new GsMessage(reqMdl);

        GSValidateCommon.validateTextField(errors, cmn340CacBody__,
            "cmn340CacBody", 
            gsMsg.getMessage("cmn.cmn340.08"), GSConstCommon.MAXLEN_CAP_BODY, false);


        //リクエストボディ内の${}の中に$, {, }, .があるかをチェック
        boolean isJsonXml = false;
        if (contentType == EnumContentType.APPLICATION_JSON
            || contentType == EnumContentType.APPLICATION_XML
            || contentType == EnumContentType.TEXT_XML) {
            isJsonXml = true;
        }
        boolean isError = __checkParameterBan(
            errors, cmn340CacBody__, gsMsg.getMessage("cmn.cmn340.08"), isJsonXml);
        if (isError) {
            return;
        }

        //ボディパラメータ一覧のチェック
        if (!createFlg) {
            __checkBodyParamMap(errors, reqMdl);
        }

        //フォーマットチェック
        if (!StringUtil.isNullZeroString(cmn340CacBody__)) {
            //フォーマットチェック前のエラーサイズを取得
            int errorSize = errors.size();
            if (contentType == EnumContentType.APPLICATION_JSON) {
                __checkJsonFormat(errors, reqMdl);
            } else if (contentType == EnumContentType.TEXT_XML
                || contentType == EnumContentType.APPLICATION_XML) {
                __checkXmlFormat(errors, reqMdl);
            } else if (contentType == EnumContentType.APPLICATION_FORM) {
                __checkApplicationFormFormat(errors, reqMdl);
            }

            if (errorSize != errors.size()) {
                return;
            }
        }

        //ボディパラメータ一覧のパラメータがボディパラメータ内に記載されているかチェック
        __checkExistBodyParam(errors, reqMdl, createFlg);
    }

    /**
     * <br>[機  能] リクエストボディとボディパラメータ一覧に入力されている情報に相違がないかをチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     * @param reqMdl リクエスト情報
     * @param createFlg true:ボディパラメータ作成時, false:ボディパラメータ作成時以外
     * @throws JDOMException 
     * @throws IOException 
     * @throws SAXException 
     * @throws ParserConfigurationException 
     */
    private void __checkExistBodyParam(ActionErrors errors, RequestModel reqMdl, boolean createFlg)
        throws ParserConfigurationException, SAXException, IOException, JDOMException {

        Cmn340ParamModel param = new Cmn340ParamModel();
        param.setParam(this);
        ApiConnectBiz apiBiz = new ApiConnectBiz();
        List<Cmn340JsonModel> bodyParamList = apiBiz.getParamList(
            param.getCmn340CacBody(), param.getCmn340CacContent());

        //ボディパラメータに記載されているパラメータ名に重複がないかをチェック
        //階層が異なっていてパラメータ名が同じ場合は許容するため、"${パラメータ名}が重複するか"では判定しない
        Set<String> bodyNameSet = new HashSet<>();
        boolean isTyohukuError = false;
        for (Cmn340JsonModel jsonMdl : bodyParamList) {
            String paramName = jsonMdl.getParamName();
            if (!bodyNameSet.add(paramName)) {
                isTyohukuError = true;
                break;
            }
            if (jsonMdl.getChild() != null) {
                for (Cmn340JsonModel childMdl : jsonMdl.getChild()) {
                    String childName = jsonMdl.getParamName() + "." + childMdl.getParamName();
                    if (!bodyNameSet.add(childName)) {
                        isTyohukuError = true;
                        break;
                    }
                }
            }
        }
        if (isTyohukuError) {
            ActionMessage msg = new ActionMessage("error.api.body.duplication.valiable");
            StrutsUtil.addMessage(errors, msg, "error.api.body.duplication.valiable");
            return;
        }
        //multipart/formdataはリクエストボディの入力がないためパラメータ一覧の重複チェックのみで終了
        if (cmn340CacContent__ == EnumContentType.MULTIPART_FORM_DATA.getValue()) {
            return;
        }

        if (createFlg) {
            //ボディパラメータ作成時は、パラメータ一覧との違いを確認する必要がない
            return;
        }

        //ボディパラメータ一覧のパラメータがリクエストボディに記載されているかチェック
        Set<Map.Entry<Integer, CmnApiConnectParamModel>> entrySet
            = cmn340BodyParamMap__.entrySet();
        for (Map.Entry<Integer, CmnApiConnectParamModel> entry : entrySet) {
            CmnApiConnectParamModel paramMdl = entry.getValue();
            if (!bodyNameSet.contains(paramMdl.getCacpName())) {
                ActionMessage msg = new ActionMessage("error.api.not.url.use.body");
                StrutsUtil.addMessage(errors, msg, "error.api.not.url.use.body");
                break;
            }
        }

        //リクエストボディから作成されていないパラメータが存在しているかチェック
        if (entrySet.size() < bodyNameSet.size()) {
            ActionMessage msg = new ActionMessage("error.api.not.exist.valiable");
            StrutsUtil.addMessage(errors, msg, "error.api.not.exist.valiable");
        }
    }

    /**
     * <br>[機  能] ボディパラメータ一覧に入力されている情報をチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     * @param reqMdl リクエスト情報
     */
    private void __checkBodyParamMap(ActionErrors errors, RequestModel reqMdl) {

        if (cmn340BodyParamMap__ == null || cmn340BodyParamMap__.isEmpty()) {
            return;
        }

        Set<String> paramNameSet = new HashSet<>();
        Set<String> paramDispNameSet = new HashSet<>();

        GsMessage gsMsg = new GsMessage(reqMdl);
        int lineCount = 1;
        for (Map.Entry<Integer, CmnApiConnectParamModel> entry : cmn340BodyParamMap__.entrySet()) {
            CmnApiConnectParamModel paramMdl = entry.getValue();
            String paramName = gsMsg.getMessage("cmn.cmn340.08") + gsMsg.getMessage("cmn.cmn340.18")
                + gsMsg.getMessage("cmn.line2", new String[] {String.valueOf(lineCount)});

            if (!StringUtil.isNullZeroString(paramMdl.getCacpName())
                && !paramNameSet.add(paramMdl.getCacpName())) {
                //ボディパラメータ 重複
                ActionMessage msg = new ActionMessage("error.select.dup.list",
                    gsMsg.getMessage("cmn.cmn340.08") + gsMsg.getMessage("cmn.cmn340.18")
                        + " " + gsMsg.getMessage("cmn.cmn340.14"));
                StrutsUtil.addMessage(errors, msg, "error.select.dup.list.body.name");
            }
            if (!StringUtil.isNullZeroString(paramMdl.getCacpNameDisp())
                && !paramDispNameSet.add(paramMdl.getCacpNameDisp())) {
                //ボディパラメータ表示名称 重複
                ActionMessage msg = new ActionMessage("error.select.dup.list",
                    gsMsg.getMessage("cmn.cmn340.08") + gsMsg.getMessage("cmn.cmn340.18")
                        + " " + gsMsg.getMessage("cmn.cmn340.50"));
                StrutsUtil.addMessage(errors, msg, "error.select.dup.list.body.namedisp");
            }

            //パラメータ名チェック
            String bodyParamName = paramMdl.getCacpName();
            GSValidateCommon.validateTextField(errors, bodyParamName,
                "pathParamName", 
                paramName + gsMsg.getMessage("cmn.cmn340.14"),
                GSConstCommon.MAXLEN_CAP_NAME, true);
            
            //パラメータ名に不正な文字列のチェック(multipart以外はリクエストボディ箇所でチェック)
            if (cmn340CacContent__ == EnumContentType.MULTIPART_FORM_DATA.getValue()
                && bodyParamName != null
                && (bodyParamName.contains(".")
                    || bodyParamName.contains("$")
                    || bodyParamName.contains("{")
                    || bodyParamName.contains("}"))) {
                ActionMessage msg = new ActionMessage(
                    "error.api.parameter.ban", paramName + gsMsg.getMessage("cmn.cmn340.14"));
                StrutsUtil.addMessage(errors, msg, "error.api.parameter.ban.paramname");
            }
            //表示名称チェック
            GSValidateCommon.validateTextField(errors, paramMdl.getCacpNameDisp(),
                "pathParamNameDisp", 
                paramName + gsMsg.getMessage("cmn.cmn340.50"),
                GSConstCommon.MAXLEN_CAP_NAME_DISP, true);

            //備考チェック
            GSValidateCommon.validateTextField(errors, paramMdl.getCacpBiko(),
                "pathParamBiko", 
                paramName + gsMsg.getMessage("cmn.memo"),
                GSConstCommon.MAXLEN_CAP_BIKO, false);

            //形式チェック
            int typeKbn = paramMdl.getCacpParamType();
            if (typeKbn != GSConstCommon.PARAM_TYPE_FILE
                && typeKbn != GSConstCommon.PARAM_TYPE_TEXT) {
                ActionMessage msg = new ActionMessage("error.input.notvalidate.data",
                    paramName + gsMsg.getMessage("cmn.format"));
                errors.add("error.input.notvalidate.data", msg);
            }
            
            //配列トグル
            int listKbn = paramMdl.getCacpListKbn();
            if (listKbn != 0 && listKbn != 1) {
                ActionMessage msg = new ActionMessage("error.input.notvalidate.data",
                    paramName + gsMsg.getMessage("cmn.cmn340.53"));
                errors.add("error.input.notvalidate.data", msg);
            }

            //必須トグル
            int hissuKbn = paramMdl.getCacpRequiredKbn();
            if (hissuKbn != 0 && hissuKbn != 1) {
                ActionMessage msg = new ActionMessage("error.input.notvalidate.data",
                    paramName + gsMsg.getMessage("cmn.required"));
                errors.add("error.input.notvalidate.data", msg);
            }
            lineCount++;
        }
    }

    /**
     * <br>[機  能] パラメータ名の前の文字に:, パラメータ名の後の文字に", "または"}"があるかを確認する
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     */
    private void __checdBodyParamName(ActionErrors errors) {
        if (cmn340CacContent__ == EnumContentType.MULTIPART_FORM_DATA.getValue()
            || cmn340CacContent__ == EnumContentType.MANUAL.getValue()) {
            return;
        }
        List<String> skipList = Arrays.asList(new String[] {" ", "\r", "\n"});
        List<String> prevStrList = null;
        List<String> nextStrList = null;
        if (cmn340CacContent__ == EnumContentType.APPLICATION_JSON.getValue()) {
            prevStrList = Arrays.asList(new String[] {":"});
            nextStrList = Arrays.asList(new String[] {",", "}"});
        } else if (cmn340CacContent__ == EnumContentType.APPLICATION_XML.getValue()
            || cmn340CacContent__ == EnumContentType.TEXT_XML.getValue()) {
            prevStrList = Arrays.asList(new String[] {">"});
            nextStrList = Arrays.asList(new String[] {"<"});
        }  else if (cmn340CacContent__ == EnumContentType.APPLICATION_FORM.getValue()) {
            prevStrList = Arrays.asList(new String[] {"="});
            nextStrList = Arrays.asList(new String[] {"&"});
        }

        String regex = "\\$\\{.+?\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(cmn340CacBody__);

        while (matcher.find()) {
            String text = matcher.group();
            int index = cmn340CacBody__.indexOf(text);
            if (index < 0) {
                continue;
            }
            int indexPrev = index - 1;
            while (indexPrev > -1) {
                String prevChar = cmn340CacBody__.substring(indexPrev, indexPrev + 1);
                if (skipList.contains(prevChar)) {
                    indexPrev--;
                    continue;
                }
                if (!prevStrList.contains(prevChar)) {
                    //前の文字列が意図したものではなかったときにエラー
                    ActionMessage msg = new ActionMessage("error.api.body.valiable.name.text");
                    StrutsUtil.addMessage(errors, msg, "error.api.body.valiable.name.text");
                    return;
                }
                break;
            }

            int indexNext = index + text.length();
            while (indexNext < cmn340CacBody__.length()) {
                String nextChar = cmn340CacBody__.substring(indexNext, indexNext + 1);
                if (skipList.contains(nextChar)) {
                    indexNext++;
                    continue;
                }
                if (!nextStrList.contains(nextChar)) {
                    //前の文字列が意図したものではなかったときにエラー
                    ActionMessage msg = new ActionMessage("error.api.body.valiable.name.text");
                    StrutsUtil.addMessage(errors, msg, "error.api.body.valiable.name.text");
                    return;
                }
                break;
            }
        }
    }

    /**
     * <br>[機  能] JSON要素が意図した構造になっているかをチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     * @param node JSON要素
     * @param parentNode 親JSON要素
     * @param okikae パラメータの置き換え文字列
     * @param okikaeMap パラメータの置き換え元，置き換え先を保持するマップ
     * @param gsMsg GsMessasge
     */
    private void __checkJsonNode(
        ActionErrors errors, JsonNode node, JsonNode parentNode,
        String okikae, Map<String, String> okikaeMap, GsMessage gsMsg) {

        Iterator<Map.Entry<String, JsonNode>> fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry<String, JsonNode> entry = fields.next();
            
            String keyStr = entry.getKey();
            JsonNode childNode = entry.getValue();

            //キー，値が正常かをチェック
            __checkJsonValue(errors, keyStr, childNode, okikae, okikaeMap, gsMsg);

            if (parentNode != null
                && (childNode.isArray() || childNode.isObject())) {                
                ActionMessage msg = new ActionMessage("error.api.body.multiple.model");
                StrutsUtil.addMessage(errors, msg, "error.api.body.multiple.model");
                return;
            }

            if (childNode.isArray() || childNode.isObject()) {
                __checkJsonNode(errors, childNode, node, okikae, okikaeMap, gsMsg);
            }

            if (childNode.isArray()) {
                __checkJsonArray(errors, childNode, okikae);
            }
        }
    }

    /**
     * <br>[機  能] 要素のキー，値が意図したものになっているかをチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     * @param keyStr キー文字列
     * @param node JSON要素
     * @param okikae パラメータの置き換え文字列
     * @param okikaeMap パラメータの置き換え元，置き換え先を保持するマップ
     * @param gsMsg GsMessasge
     */
    private void __checkJsonValue(
        ActionErrors errors, String keyStr, JsonNode node,
        String okikae, Map<String, String> okikaeMap, GsMessage gsMsg) {

        //キー情報に${パラメータ名}が含まれているかをチェック
        Pattern pattern = Pattern.compile(okikae + ".*");
        Matcher matcher = pattern.matcher(keyStr);
        if (matcher.find()) {
            ActionMessage msg = new ActionMessage("error.api.body.valiable.in.key");
            StrutsUtil.addMessage(errors, msg, "error.api.body.valiable.in.key");
        }

        //禁止文字が値に含まれているかをチェック
        __checkBanChar(errors, node.asText(), false, gsMsg);

        String valueStr = node.asText();

        //値に置き換え後の文字列が入っている場合
        if (okikaeMap.containsKey(valueStr)) {
            String replacedName = okikaeMap.get(valueStr);
            replacedName = replacedName.substring(2, replacedName.length() - 1);

            //キーと変数名が等しいかをチェック
            if (!Objects.equals(keyStr, replacedName)) {
                ActionMessage msg = new ActionMessage("error.api.body.key.valiable.name");
                errors.add("error.api.body.key.valiable.name", msg);
                return;
            }
        }
    }

    /**
     * <br>[機  能] JSONArrayに変数, モデル, 配列が含まれているかを確認する
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     * @param nodeArray 配列要素
     * @param okikae ${パラメータ名}の置き換え先文字列
     */
    private void __checkJsonArray(ActionErrors errors, JsonNode nodeArray, String okikae) {

        Pattern pattern = Pattern.compile(okikae + ".*");
        Matcher matcher;

        for (JsonNode childNode : nodeArray) {

            if (childNode.isArray() || childNode.isObject()) {
                ActionMessage msg = new ActionMessage("error.api.body.multiple.array");
                StrutsUtil.addMessage(errors, msg, "error.api.body.multiple.array");
                return;
            }

            String arrayValue = childNode.asText();
            matcher = pattern.matcher(arrayValue);
            if (matcher.find()) {
                ActionMessage msg = new ActionMessage("error.api.body.array.parameter");
                errors.add("error.api.body.array.parameter", msg);
                return;
            }
        }
    }

    /**
     * <br>[機  能] リクエストボディがJSONフォーマットになっているか、配列構造の禁止を守っているかをチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     * @param reqMdl リクエスト情報
     */
    private void __checkJsonFormat(ActionErrors errors, RequestModel reqMdl) {

        String targetText = cmn340CacBody__;

        //${変数名}が[]で囲われているかを確認する
        String listRegex = "^\\[\\s*\\$\\{.+\\}\\s*\\]$";
        Pattern listPattern = Pattern.compile(listRegex);
        Matcher listMatcher = listPattern.matcher(targetText);
        while (listMatcher.find()) {
            ActionMessage msg = new ActionMessage("error.api.body.valiable.in.list");
            errors.add("error.api.body.valiable.in.list", msg);
            return;
        }
        
        //リクエストボディの${パラメータ名}を、ボディパラメータに記載されていない数字に置き換える
        String okikae = RandomStringUtils.randomNumeric(8).replaceAll("0", "1");
        while (targetText.contains(okikae)) {
            okikae = RandomStringUtils.randomNumeric(8).replaceAll("0", "1");
        }

        String regex = "\\$\\{.+?\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(targetText);
        Set<String> resultSet = new HashSet<String>();
        while (matcher.find()) {
            String text = matcher.group();
            resultSet.add(text);
        }

        final AtomicInteger count = new AtomicInteger(1);
        Map<String, String> okikaeMap = new HashMap<>();
        for (String replaceTarget : resultSet) {
            String okikaeWithCount = okikae + count.getAndIncrement();
            okikaeMap.put(okikaeWithCount, replaceTarget);
            //aa : ${aa}をaa : 置き換え後の文字列にする
            targetText = targetText.replace(replaceTarget, okikaeWithCount);
        }
        GsMessage gsMsg = new GsMessage(reqMdl);
        int errorSize = errors.size();

        try {
            //JSON構文をチェック
            ObjectMapper mapper = new ObjectMapper();
            JsonNode json = mapper.readTree(targetText);

            __checkJsonNode(errors, json, null, okikae, okikaeMap, gsMsg);
            if (errorSize != errors.size()) {
                return;
            }
            //変数名の前後に意図した文字列以外が入力されているかを確認する
            __checdBodyParamName(errors);
        } catch (JsonProcessingException e) {
            //JSONフォーマットエラーのメッセージを画面に表示
            String msg = e.getMessage();
            StrutsUtil.addMessage(errors,
                new ActionMessage("error.api.incorrect.body.syntax", msg),
                "error.api.incorrect.body.syntax");
            return;
        }
    }

    /**
     * <br>[機  能] 指定されたオブジェクトに禁止された文字列が入っているか確認します
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     * @param value JSONのvalue文字列
     * @param isKey true:キーに設定されている文字列, false:キーに設定されている文字列ではない
     * @param gsMsg GsMessage
     */
    private void __checkBanChar(ActionErrors errors, Object value, boolean isKey, GsMessage gsMsg) {

        //valueの中が値になっていない場合はリターン
        if (!(value instanceof String) && !(value instanceof Integer)) {
            return;
        }

        String valueStr = null;
        if (value instanceof String) {
            valueStr = (String) value;
        }
        if (value instanceof Integer) {
            valueStr = String.valueOf(value);
        }

        if ((isKey && valueStr.contains("."))
            || valueStr.contains("$")
            || valueStr.contains("{")
            || valueStr.contains("}")) {
            ActionMessage msg = new ActionMessage(
                "error.api.parameter.ban", gsMsg.getMessage("cmn.cmn340.08"));
            StrutsUtil.addMessage(errors, msg, "error.api.parameter.ban.body");
        }
    }

    /**
     * <br>[機  能] 要素内にあるすべての要素のタグ名を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param element Element
     * @return タグ名一覧
     */
    private List<String> __getTagNames(Element element) {
        List<String> tagNames = new ArrayList<>();

        NodeList nodeList = element.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == Node.ELEMENT_NODE) {
                Element childElement = (Element) node;
                tagNames.add(childElement.getTagName());
            }
        }
        return tagNames;
    }

    /**
     * <br>[機  能] リクエストボディがXMLフォーマットになっているか、配列構造の禁止を守っているかをチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     * @param reqMdl リクエスト情報
     */
    private void __checkXmlFormat(ActionErrors errors, RequestModel reqMdl) {

        //正しいXMLフォーマットになっているかをチェック
        String targetStr = cmn340CacBody__;

        String regex = "\\$\\{.+?\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(cmn340CacBody__);
        
        final AtomicInteger count = new AtomicInteger(1);
        String okikae = RandomStringUtils.randomAlphabetic(8);
        while (targetStr.contains(okikae)) {
            okikae = RandomStringUtils.randomAlphabetic(8);
        }
        Map<String, String> okikaeMap = new HashMap<>();
        while (matcher.find()) {
            String okikaeWithCount = okikae + count.getAndIncrement();
            String replaceTarget = matcher.group();
            okikaeMap.put(okikaeWithCount,
                replaceTarget.substring(2, replaceTarget.length() - 1));
            targetStr = targetStr.replace(replaceTarget, okikaeWithCount);
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance(); 
            SAXParser parser = factory.newSAXParser(); 
            XMLReader reader = parser.getXMLReader(); 
            //xmlとしての構文チェック
            reader.parse(new InputSource(new StringReader(targetStr)));
            
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            targetStr = targetStr.trim();
            InputSource is = new InputSource(new StringReader(targetStr));
            Document doc = dBuilder.parse(is);
            Element root = doc.getDocumentElement();

            //タグ名に禁止文字が含まれているかをチェック
            List<String> tagNames = __getTagNames(root);
            GsMessage gsMsg = new GsMessage(reqMdl);
            for (String tagName : tagNames) {
                __checkBanChar(errors, tagName, true, gsMsg);
            }

            //テキストとして不正な文字列が入っているかをチェック
            String planeText = root.getTextContent();
            __checkBanChar(errors, planeText, false, gsMsg);

            String okikaeRegex = okikae + "\\d+";
            __checkNodeList(errors, root, okikaeMap, okikaeRegex, 1);
            
        } catch (Exception e) {
            String msg = e.toString();
            int msgIndex = msg.indexOf("SAXParseException;");
            if (msgIndex > 0 && msg.length() > msgIndex + 19) {
                msg = msg.substring(msgIndex + 19);
            }
            StrutsUtil.addMessage(errors,
                    new ActionMessage("error.api.incorrect.body.syntax",
                                    msg),
                    "error.api.incorrect.body.syntax");
            return;
        }

        //変数がキーに設定されていないかをチェック
        String keyRegex = "<\\s*\\$\\{[^}]+\\}[^>]*>";
        pattern = Pattern.compile(keyRegex);
        matcher = pattern.matcher(cmn340CacBody__);
        if (matcher.find()) {
            StrutsUtil.addMessage(errors,
                new ActionMessage("error.api.body.valiable.in.key"),
                "error.api.body.valiable.in.key");
        }

        //変数名の前後に意図した文字列以外が入力されているかを確認する
        __checdBodyParamName(errors);
    }

    /**
     * <br>[機  能] XML要素が配列構造になっているか、キーと変数名が正しいかをチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     * @param node XML要素
     * @param okikaeMap 変数名置き換え情報保持マップ
     * @param regex 置き換え文字取得用正規表現
     * @param kaisou XMLの要素階層
     */
    private void __checkNodeList(ActionErrors errors, Node node,
        Map<String, String> okikaeMap, String regex, int kaisou) {
        if (node.getNodeType() == Node.TEXT_NODE) {
            return;
        }

        //root要素の子要素が4階層まである場合は、構造の中に構造があるためエラー
        if (kaisou > 3) {
            StrutsUtil.addMessage(errors,
                new ActionMessage("error.api.body.multiple.model"),
                "error.api.body.multiple.model");
            return;
        }

        //同一階層に同じタグ名が存在するかチェック用(同じタグ名がある場合配列構造エラー)
        Set<String> nodeNameSet = new HashSet<>();
        Set<String> arrayNameSet = new HashSet<>();
        
        Pattern pattern = Pattern.compile(regex);
        if (node.getNodeType() == Node.ELEMENT_NODE) {
            NodeList nodeList = node.getChildNodes();
            for (int idx = 0; idx < nodeList.getLength(); idx++) {
                if (!nodeNameSet.add(nodeList.item(idx).getNodeName())) {
                    arrayNameSet.add(nodeList.item(idx).getNodeName());
                }
            }
            for (int idx = 0; idx < nodeList.getLength(); idx++) {
                Node childNode = nodeList.item(idx);
                if (childNode.getNodeType() == Node.TEXT_NODE) {

                    String text = childNode.getTextContent();
                    if (node.getUserData("isArray") != null
                        && (boolean) node.getUserData("isArray")) {
                        //配列の中に変数名が含まれている場合
                        Matcher matcher = pattern.matcher(text);
                        if (matcher.find()) {
                            ActionMessage msg = new ActionMessage("error.api.body.array.parameter");
                            StrutsUtil.addMessage(errors, msg, "error.api.body.array.parameter");
                            return;
                        }
                    }

                    //変数を格納したテキストノードの場合、タグ名と変数名が等しいかをチェック
                    Matcher matcher = pattern.matcher(text);
                    if (matcher.find()) {
                        String valableName = okikaeMap.get(matcher.group());
                        if (!Objects.equals(node.getNodeName(), valableName)) {
                            ActionMessage msg =
                                new ActionMessage("error.api.body.key.valiable.name");
                            errors.add("error.api.body.key.valiable.name", msg);
                            StrutsUtil.addMessage(errors,
                                new ActionMessage("error.api.body.key.valiable.name"),
                                "error.api.body.key.valiable.name");
                            return;
                        }
                    }
                }
                if (childNode.getNodeType() == Node.ELEMENT_NODE) {
                    if (node.getUserData("isArray") != null
                        && (boolean) node.getUserData("isArray")) {
                        //親要素が配列で、子要素が要素ノードの場合はエラー
                        ActionMessage msg = new ActionMessage("error.api.body.multiple.array");
                        StrutsUtil.addMessage(errors, msg, "error.api.body.multiple.array");
                        return;
                    }

                    if (kaisou > 1 && arrayNameSet.contains(childNode.getNodeName())) {
                        //親要素がモデルで、子要素が配列の場合はエラー
                        ActionMessage msg = new ActionMessage("error.api.body.multiple.model");
                        StrutsUtil.addMessage(errors, msg, "error.api.body.multiple.model");
                        return;
                    }

                    childNode.setUserData(
                        "isArray", arrayNameSet.contains(childNode.getNodeName()), null);
                    __checkNodeList(errors, childNode, okikaeMap, regex, kaisou + 1);

                    
                }
            }    
        }
    }

    /**
     * <br>[機  能] リクエストボディがurlform-encoded形式になっているかをチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param errors エラー
     * @param reqMdl リクエスト情報
     */
    private void __checkApplicationFormFormat(
        ActionErrors errors, RequestModel reqMdl) {

        String targetText = cmn340CacBody__;
        //${パラメータ名}の前後に意図していない文字が入っているかをチェックする
        __checdBodyParamName(errors);

        Pattern pattern = Pattern.compile("(.*?)=\\$\\{\\1\\}");
        Matcher matcher = pattern.matcher(targetText);
        int withEqualCount = 0;
        List<String> paramList = new ArrayList<>();
        while (matcher.find()) {
            withEqualCount++;
            paramList.add(matcher.group(1));
        }

        pattern = Pattern.compile("\\$\\{.+?\\}");
        matcher = pattern.matcher(targetText);
        
        int onlyNameCount = 0;
        while (matcher.find()) {
            onlyNameCount++;
        }

        GsMessage gsMsg = new GsMessage(reqMdl);
        if (withEqualCount != onlyNameCount) {
            ActionMessage msg = new ActionMessage(
                "error.api.body.valiable.name", "${" + gsMsg.getMessage("cmn.cmn340.14") + "}");
            errors.add("error.api.body.valiable.name", msg);
            return;
        }

        //リクエストボディからaaa=1234のように、=の前にあるパラメータ名を取得し、配列構造禁止チェックを行う※値に変数を含まない場合は許容
        pattern = Pattern.compile("([^&=]+)(?==)");
        matcher = pattern.matcher(targetText);
        Set<String> keySet = new HashSet<>();
        while (matcher.find()) {
            if (!keySet.add(matcher.group())
                && paramList.contains(matcher.group())) {
                ActionMessage msg = new ActionMessage("error.api.body.array.parameter");
                StrutsUtil.addMessage(errors, msg, "error.api.body.array.parameter");
            }
        }
    }
}
