package jp.groupsession.v2.cmn.cmn340;

import java.util.List;
import java.util.TreeMap;

import org.apache.struts.util.LabelValueBean;

import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.biz.apiconnect.EnumContentType;
import jp.groupsession.v2.cmn.model.AbstractParamModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectGsapiModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectHeaderModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectParamModel;
/**
 *
 * <br>[機  能] 連携API登録 ParamModel
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Cmn340ParamModel extends AbstractParamModel  {
    
    /** 登録モード 追加 | 編集 */
    private int cmn340mode__ = GSConstCommon.MODE_ADD;
    /**初期表示フラグ  */
    private int cmn340init__;
    /** 接続テストdialog表示フラグ */
    private boolean cmn340TestDialogFlg__ = false;

    /** APISID */
    private int cmn340CacSid__ = -1;
    /** API名 */
    private String cmn340CacName__;
    /** 説明 */
    private String cmn340CacDescription__;
    /** URL */
    private String cmn340CacUrl__;
    /** HTTPリクエストメソッド */
    private int cmn340CacMethod__;
    /** Content-Type */
    private int cmn340CacContent__ = EnumContentType.APPLICATION_JSON.getValue();
    /** Content-Type(手入力) */
    private String cmn340CacContentManual__;
    /** リクエストボディ */
    private String cmn340CacBody__;
    /** 認証方式 */
    private int cmn340CacAuth__;
    /** ユーザID */
    private String cmn340CacId__;
    /** パスワード */
    private String cmn340CacPassword__;
    /** トークンキー */
    private String cmn340CacToken__;
    /** パスパラメータ一覧 */
    private TreeMap<Integer, CmnApiConnectParamModel> cmn340PathParamMap__ = new TreeMap<>();
    /** クエリパラメータ一覧 */
    private TreeMap<Integer, CmnApiConnectParamModel> cmn340QueryParamMap__ = new TreeMap<>();
    /** ボディパラメータ一覧 */
    private TreeMap<Integer, CmnApiConnectParamModel> cmn340BodyParamMap__ = new TreeMap<>();
    /** 追加ヘッダー 一覧 */
    private TreeMap<Integer, CmnApiConnectHeaderModel> cmn340RequestHeaderMap__ = new TreeMap<>();

    /** 実行テスト用 ボディパラメータリスト */
    private TreeMap<Integer, Cmn340ConnectParam> cmn340CapMap__ = new TreeMap<>();
    //GS API用パラメータ
    /** プラグイン */
    private String cmn340CacPlugin__ = null;
    /** GS API */
    private int cmn340CacGsApi__ = 0;
    /** プラグイン一覧 */
    private List<LabelValueBean> cmn340CacPluginList__ = null;
    /** GS API一覧 */
    private List<CmnApiConnectGsapiModel> cmn340CacApiList__ = null;
    /** メッセージ表示フラグ*/
    private int cmn340MessageFlg__ = 0;
    /** 連携API更新エラー表示フラグ */
    private int cmn340VerErrorFlg__ = 0;
    /** 接続テスト URL */
    private String cmn340TestUrl__ = null;
    /** 接続テスト リクエストヘッダ */
    private String[] cmn340TestHeader__ = null;
    /** 接続テスト リクエストボディ */
    private String cmn340TestBody__ = null;
    /** 接続テスト 添付ファイルアップロード ディレクトリ */
    private int cmn340TestFileDir__;
    /** GSAPIバージョンエラー文字列 */
    private String cmn340GsApiErrorText__;

    /**
     * @return the cmn340mode
     */
    public int getCmn340mode() {
        return cmn340mode__;
    }

    /**
     * @param cmn340mode the cmn340mode to set
     */
    public void setCmn340mode(int cmn340mode) {
        cmn340mode__ = cmn340mode;
    }

    /**
     * @return the cmn340init
     */
    public int getCmn340init() {
        return cmn340init__;
    }

    /**
     * @param cmn340init the cmn340init to set
     */
    public void setCmn340init(int cmn340init) {
        cmn340init__ = cmn340init;
    }

    /**
     * @return the cmn340TestDialogFlg
     */
    public boolean isCmn340TestDialogFlg() {
        return cmn340TestDialogFlg__;
    }

    /**
     * @param cmn340TestDialogFlg the cmn340TestDialogFlg to set
     */
    public void setCmn340TestDialogFlg(boolean cmn340TestDialogFlg) {
        cmn340TestDialogFlg__ = cmn340TestDialogFlg;
    }

    /**
     * @return the cmn340CacSid
     */
    public int getCmn340CacSid() {
        return cmn340CacSid__;
    }

    /**
     * @param cmn340CacSid the cmn340CacSid to set
     */
    public void setCmn340CacSid(int cmn340CacSid) {
        cmn340CacSid__ = cmn340CacSid;
    }

    /**
     * @return the cmn340CacName
     */
    public String getCmn340CacName() {
        return cmn340CacName__;
    }

    /**
     * @param cmn340CacName the cmn340CacName to set
     */
    public void setCmn340CacName(String cmn340CacName) {
        cmn340CacName__ = cmn340CacName;
    }

    /**
     * @return the cmn340CacDescription
     */
    public String getCmn340CacDescription() {
        return cmn340CacDescription__;
    }

    /**
     * @param cmn340CacDescription the cmn340CacDescription to set
     */
    public void setCmn340CacDescription(String cmn340CacDescription) {
        cmn340CacDescription__ = cmn340CacDescription;
    }

    /**
     * @return the cmn340CacUrl
     */
    public String getCmn340CacUrl() {
        return cmn340CacUrl__;
    }

    /**
     * @param cmn340CacUrl the cmn340CacUrl to set
     */
    public void setCmn340CacUrl(String cmn340CacUrl) {
        cmn340CacUrl__ = cmn340CacUrl;
    }

    /**
     * @return the cmn340CacMethod
     */
    public int getCmn340CacMethod() {
        return cmn340CacMethod__;
    }

    /**
     * @param cmn340CacMethod the cmn340CacMethod to set
     */
    public void setCmn340CacMethod(int cmn340CacMethod) {
        cmn340CacMethod__ = cmn340CacMethod;
    }

    /**
     * @return the cmn340CacContent
     */
    public int getCmn340CacContent() {
        return cmn340CacContent__;
    }

    /**
     * @param cmn340CacContent the cmn340CacContent to set
     */
    public void setCmn340CacContent(int cmn340CacContent) {
        cmn340CacContent__ = cmn340CacContent;
    }

    /**
     * @return the cmn340CacContentManual
     */
    public String getCmn340CacContentManual() {
        return cmn340CacContentManual__;
    }

    /**
     * @param cmn340CacContentManual the cmn340CacContentManual to set
     */
    public void setCmn340CacContentManual(String cmn340CacContentManual) {
        cmn340CacContentManual__ = cmn340CacContentManual;
    }

    /**
     * @return the cmn340CacBody
     */
    public String getCmn340CacBody() {
        return cmn340CacBody__;
    }

    /**
     * @param cmn340CacBody the cmn340CacBody to set
     */
    public void setCmn340CacBody(String cmn340CacBody) {
        cmn340CacBody__ = cmn340CacBody;
    }

    /**
     * @return the cmn340CacAuth
     */
    public int getCmn340CacAuth() {
        return cmn340CacAuth__;
    }

    /**
     * @param cmn340CacAuth the cmn340CacAuth to set
     */
    public void setCmn340CacAuth(int cmn340CacAuth) {
        cmn340CacAuth__ = cmn340CacAuth;
    }

    /**
     * @return the cmn340CacId
     */
    public String getCmn340CacId() {
        return cmn340CacId__;
    }

    /**
     * @param cmn340CacId the cmn340CacId to set
     */
    public void setCmn340CacId(String cmn340CacId) {
        cmn340CacId__ = cmn340CacId;
    }

    /**
     * @return the cmn340CacPassword
     */
    public String getCmn340CacPassword() {
        return cmn340CacPassword__;
    }

    /**
     * @param cmn340CacPassword the cmn340CacPassword to set
     */
    public void setCmn340CacPassword(String cmn340CacPassword) {
        cmn340CacPassword__ = cmn340CacPassword;
    }

    /**
     * @return the cmn340CacToken
     */
    public String getCmn340CacToken() {
        return cmn340CacToken__;
    }

    /**
     * @param cmn340CacToken the cmn340CacToken to set
     */
    public void setCmn340CacToken(String cmn340CacToken) {
        cmn340CacToken__ = cmn340CacToken;
    }

    /**
     * @return the cmn340PathParamMap
     */
    public TreeMap<Integer, CmnApiConnectParamModel> getCmn340PathParamMap() {
        return cmn340PathParamMap__;
    }

    /**
     * @param cmn340PathParamMap the cmn340PathParamMap to set
     */
    public void setCmn340PathParamMap(
            TreeMap<Integer, CmnApiConnectParamModel> cmn340PathParamMap) {
        cmn340PathParamMap__ = cmn340PathParamMap;
    }

    /**
     * @return the cmn340QueryParamMap
     */
    public TreeMap<Integer, CmnApiConnectParamModel> getCmn340QueryParamMap() {
        return cmn340QueryParamMap__;
    }

    /**
     * @param cmn340QueryParamMap the cmn340QueryParamMap to set
     */
    public void setCmn340QueryParamMap(
            TreeMap<Integer, CmnApiConnectParamModel> cmn340QueryParamMap) {
        cmn340QueryParamMap__ = cmn340QueryParamMap;
    }

    /**
     * @return the cmn340BodyParamMap
     */
    public TreeMap<Integer, CmnApiConnectParamModel> getCmn340BodyParamMap() {
        return cmn340BodyParamMap__;
    }

    /**
     * @param cmn340BodyParamMap the cmn340BodyParamMap to set
     */
    public void setCmn340BodyParamMap(
            TreeMap<Integer, CmnApiConnectParamModel> cmn340BodyParamMap) {
        cmn340BodyParamMap__ = cmn340BodyParamMap;
    }

    /**
     * @return the cmn340RequestHeaderMap
     */
    public TreeMap<Integer, CmnApiConnectHeaderModel> getCmn340RequestHeaderMap() {
        return cmn340RequestHeaderMap__;
    }

    /**
     * @param cmn340RequestHeaderMap the cmn340RequestHeaderMap to set
     */
    public void setCmn340RequestHeaderMap(
            TreeMap<Integer, CmnApiConnectHeaderModel> cmn340RequestHeaderMap) {
        cmn340RequestHeaderMap__ = cmn340RequestHeaderMap;
    }

    /**
     * @return the cmn340CapMap
     */
    public TreeMap<Integer, Cmn340ConnectParam> getCmn340CapMap() {
        return cmn340CapMap__;
    }

    /**
     * @param cmn340CapMap the cmn340CapMap to set
     */
    public void setCmn340CapMap(TreeMap<Integer, Cmn340ConnectParam> cmn340CapMap) {
        cmn340CapMap__ = cmn340CapMap;
    }

    /**
     * @return the cmn340CacPlugin
     */
    public String getCmn340CacPlugin() {
        return cmn340CacPlugin__;
    }

    /**
     * @param cmn340CacPlugin the cmn340CacPlugin to set
     */
    public void setCmn340CacPlugin(String cmn340CacPlugin) {
        cmn340CacPlugin__ = cmn340CacPlugin;
    }

    /**
     * @return the cmn340CacGsApi
     */
    public int getCmn340CacGsApi() {
        return cmn340CacGsApi__;
    }

    /**
     * @param cmn340CacGsApi the cmn340CacGsApi to set
     */
    public void setCmn340CacGsApi(int cmn340CacGsApi) {
        cmn340CacGsApi__ = cmn340CacGsApi;
    }

    /**
     * @return the cmn340CacPluginList
     */
    public List<LabelValueBean> getCmn340CacPluginList() {
        return cmn340CacPluginList__;
    }

    /**
     * @param cmn340CacPluginList the cmn340CacPluginList to set
     */
    public void setCmn340CacPluginList(List<LabelValueBean> cmn340CacPluginList) {
        cmn340CacPluginList__ = cmn340CacPluginList;
    }

    /**
     * @return the cmn340CacApiList
     */
    public List<CmnApiConnectGsapiModel> getCmn340CacApiList() {
        return cmn340CacApiList__;
    }

    /**
     * @param cmn340CacApiList the cmn340CacApiList to set
     */
    public void setCmn340CacApiList(
            List<CmnApiConnectGsapiModel> cmn340CacApiList) {
        cmn340CacApiList__ = cmn340CacApiList;
    }

    /**
     * @return the cmn340MessageFlg
     */
    public int getCmn340MessageFlg() {
        return cmn340MessageFlg__;
    }

    /**
     * @param cmn340MessageFlg the cmn340MessageFlg to set
     */
    public void setCmn340MessageFlg(int cmn340MessageFlg) {
        cmn340MessageFlg__ = cmn340MessageFlg;
    }

    /**
     * @return the cmn340VerErrorFlg
     */
    public int getCmn340VerErrorFlg() {
        return cmn340VerErrorFlg__;
    }

    /**
     * @param cmn340VerErrorFlg the cmn340VerErrorFlg to set
     */
    public void setCmn340VerErrorFlg(int cmn340VerErrorFlg) {
        cmn340VerErrorFlg__ = cmn340VerErrorFlg;
    }

    /**
     * @return the cmn340TestUrl
     */
    public String getCmn340TestUrl() {
        return cmn340TestUrl__;
    }

    /**
     * @param cmn340TestUrl the cmn340TestUrl to set
     */
    public void setCmn340TestUrl(String cmn340TestUrl) {
        cmn340TestUrl__ = cmn340TestUrl;
    }

    /**
     * @return the cmn340TestHeader
     */
    public String[] getCmn340TestHeader() {
        return cmn340TestHeader__;
    }

    /**
     * @param cmn340TestHeader the cmn340TestHeader to set
     */
    public void setCmn340TestHeader(String[] cmn340TestHeader) {
        cmn340TestHeader__ = cmn340TestHeader;
    }

    /**
     * @return the cmn340TestBody
     */
    public String getCmn340TestBody() {
        return cmn340TestBody__;
    }

    /**
     * @param cmn340TestBody the cmn340TestBody to set
     */
    public void setCmn340TestBody(String cmn340TestBody) {
        cmn340TestBody__ = cmn340TestBody;
    }

    /**
     * @return the cmn340TestFileDir
     */
    public int getCmn340TestFileDir() {
        return cmn340TestFileDir__;
    }

    /**
     * @param cmn340TestFileDir the cmn340TestFileDir to set
     */
    public void setCmn340TestFileDir(int cmn340TestFileDir) {
        cmn340TestFileDir__ = cmn340TestFileDir;
    }

    /**
     * @return the cmn340GsApiErrorText
     */
    public String getCmn340GsApiErrorText() {
        return cmn340GsApiErrorText__;
    }

    /**
     * @param cmn340GsApiErrorText the cmn340GsApiErrorText to set
     */
    public void setCmn340GsApiErrorText(String cmn340GsApiErrorText) {
        cmn340GsApiErrorText__ = cmn340GsApiErrorText;
    }

    /**
     * <p>getCmn340PathParam[index] を取得します。
     * @param index 添字
     * @return getCmn340PathParam[index]
     * @see jp.groupsession.v2.cmn.cmn340.Cmn340Form#cmn340PathParamMap__
     */
    public CmnApiConnectParamModel getCmn340PathParam(int index) {

        if (!cmn340PathParamMap__.containsKey(index)) {
            cmn340PathParamMap__.put(index, new CmnApiConnectParamModel());
        }
        return cmn340PathParamMap__.get(index);
    }

    /**
     * <p>getCmn340QueryParam[index] を取得します。
     * @param index 添字
     * @return getCmn340QueryParam[index]
     * @see jp.groupsession.v2.cmn.cmn340.Cmn340Form#cmn340QueryParamMap__
     */
    public CmnApiConnectParamModel getCmn340QueryParam(int index) {

        if (!cmn340QueryParamMap__.containsKey(index)) {
            cmn340QueryParamMap__.put(index, new CmnApiConnectParamModel());
        }
        return cmn340QueryParamMap__.get(index);
    }

    /**
     * <p>getCmn340RequestHeader[index] を取得します。
     * @param index 添字
     * @return getCmn340RequestHeader[index]
     * @see jp.groupsession.v2.cmn.cmn340.Cmn340Form#cmn340RequestHeaderMap__
     */
    public CmnApiConnectHeaderModel getCmn340RequestHeader(int index) {

        if (!cmn340RequestHeaderMap__.containsKey(index)) {
            cmn340RequestHeaderMap__.put(index, new CmnApiConnectHeaderModel());
        }
        return cmn340RequestHeaderMap__.get(index);
    }

    /**
     * <p>getCmn340Param[index] を取得します。
     * @param index 添字
     * @return getCmn340BodyParam[index]
     * @see jp.groupsession.v2.cmn.cmn340.Cmn340Form#cmn340BodyParamMap__
     */
    public CmnApiConnectParamModel getCmn340BodyParam(int index) {

        if (!cmn340BodyParamMap__.containsKey(index)) {
            cmn340BodyParamMap__.put(index, new CmnApiConnectParamModel());
        }
        return cmn340BodyParamMap__.get(index);
    }

    /**
     * <p>cmn340CapParam[index] を取得します。
     * @param index 添字
     * @return cmn340CapParam[index]
     * @see jp.groupsession.v2.cmn.cmn340.Cmn340Form#cmn340CapMap__
     */
    public Cmn340ConnectParam getCmn340CapParam(int index) {

        if (!cmn340CapMap__.containsKey(index)) {
            cmn340CapMap__.put(index, new Cmn340ConnectParam());
        }
        return cmn340CapMap__.get(index);
    }

    /**
     *
     * <br>[機  能] 設定値をformにコピー
     * <br>[解  説]
     * <br>[備  考]
     * @param form
     */
    public void setFormData(Cmn340Form form) {
        super.setFormData(form);
        form.setCmn340CapMap(new TreeMap<Integer, Cmn340ConnectParam>(cmn340CapMap__));
        form.setCmn340PathParamMap(
            new TreeMap<Integer, CmnApiConnectParamModel>(cmn340PathParamMap__));
        form.setCmn340QueryParamMap(
            new TreeMap<Integer, CmnApiConnectParamModel>(cmn340QueryParamMap__));
        form.setCmn340BodyParamMap(
            new TreeMap<Integer, CmnApiConnectParamModel>(cmn340BodyParamMap__));
    }
    /**
     *
     * <br>[機  能] フォームパラメータをコピーする
     * <br>[解  説]
     * <br>[備  考]
     * @param form
     */
    public void setParam(Cmn340Form form) {
        super.setParam(form);
        this.setCmn340CapMap(new TreeMap<Integer, Cmn340ConnectParam>(form.getCmn340CapMap()));
        this.setCmn340PathParamMap(
            new TreeMap<Integer, CmnApiConnectParamModel>(form.getCmn340PathParamMap()));
        this.setCmn340QueryParamMap(
            new TreeMap<Integer, CmnApiConnectParamModel>(form.getCmn340QueryParamMap()));
        this.setCmn340BodyParamMap(
            new TreeMap<Integer, CmnApiConnectParamModel>(form.getCmn340BodyParamMap()));
    }
}
