package jp.groupsession.v2.cmn.dao.base;

import jp.co.sjts.util.date.UDate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectModel;

/**
 * <p>CMN_API_CONNECT Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class CmnApiConnectDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(CmnApiConnectDao.class);

    /**
     * <p>Default Constructor
     */
    public CmnApiConnectDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public CmnApiConnectDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CMN_API_CONNECT");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CMN_API_CONNECT (");
            sql.addSql("   CAC_SID integer not null,");
            sql.addSql("   CAC_NAME varchar(50) not null,");
            sql.addSql("   CAC_DESCRIPTION varchar(1000),");
            sql.addSql("   CAG_SID integer not null,");
            sql.addSql("   CAG_VERSION integer not null,");
            sql.addSql("   CAC_URL clob not null,");
            sql.addSql("   CAC_METHOD_KBN integer not null,");
            sql.addSql("   CAC_AUTH_KBN integer not null,");
            sql.addSql("   CAC_AUTH_TOKEN varchar(1000),");
            sql.addSql("   CAC_AUTH_ID varchar(256),");
            sql.addSql("   CAC_AUTH_PASS varchar(352),");
            sql.addSql("   CAC_CONTENT_KBN integer not null,");
            sql.addSql("   CAC_CONTENT_MANUAL varchar(150),");
            sql.addSql("   CAC_BODY clob,");
            sql.addSql("   CAC_AUID integer not null,");
            sql.addSql("   CAC_ADATE timestamp not null,");
            sql.addSql("   CAC_EUID integer not null,");
            sql.addSql("   CAC_EDATE timestamp not null,");
            sql.addSql("   CAC_JKBN integer not null,");
            sql.addSql("   primary key (CAC_SID)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CMN_API_CONNECT Data Bindding JavaBean
     * @param bean CMN_API_CONNECT Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(CmnApiConnectModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CMN_API_CONNECT(");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CAC_NAME,");
            sql.addSql("   CAC_DESCRIPTION,");
            sql.addSql("   CAG_SID,");
            sql.addSql("   CAG_VERSION,");
            sql.addSql("   CAC_URL,");
            sql.addSql("   CAC_METHOD_KBN,");
            sql.addSql("   CAC_AUTH_KBN,");
            sql.addSql("   CAC_AUTH_TOKEN,");
            sql.addSql("   CAC_AUTH_ID,");
            sql.addSql("   CAC_AUTH_PASS,");
            sql.addSql("   CAC_CONTENT_KBN,");
            sql.addSql("   CAC_CONTENT_MANUAL,");
            sql.addSql("   CAC_BODY,");
            sql.addSql("   CAC_AUID,");
            sql.addSql("   CAC_ADATE,");
            sql.addSql("   CAC_EUID,");
            sql.addSql("   CAC_EDATE,");
            sql.addSql("   CAC_JKBN");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCacSid());
            sql.addStrValue(bean.getCacName());
            sql.addStrValue(bean.getCacDescription());
            sql.addIntValue(bean.getCagSid());
            sql.addIntValue(bean.getCagVersion());
            sql.addStrValue(bean.getCacUrl());
            sql.addIntValue(bean.getCacMethodKbn());
            sql.addIntValue(bean.getCacAuthKbn());
            sql.addStrValue(bean.getCacAuthToken());
            sql.addStrValue(bean.getCacAuthId());
            sql.addStrValue(bean.getCacAuthPass());
            sql.addIntValue(bean.getCacContentKbn());
            sql.addStrValue(bean.getCacContentManual());
            sql.addStrValue(bean.getCacBody());
            sql.addIntValue(bean.getCacAuid());
            sql.addDateValue(bean.getCacAdate());
            sql.addIntValue(bean.getCacEuid());
            sql.addDateValue(bean.getCacEdate());
            sql.addIntValue(bean.getCacJkbn());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update CMN_API_CONNECT Data Bindding JavaBean
     * @param bean CMN_API_CONNECT Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(CmnApiConnectModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CMN_API_CONNECT");
            sql.addSql(" set ");
            sql.addSql("   CAC_NAME=?,");
            sql.addSql("   CAC_DESCRIPTION=?,");
            sql.addSql("   CAG_SID=?,");
            sql.addSql("   CAG_VERSION=?,");
            sql.addSql("   CAC_URL=?,");
            sql.addSql("   CAC_METHOD_KBN=?,");
            sql.addSql("   CAC_AUTH_KBN=?,");
            sql.addSql("   CAC_AUTH_TOKEN=?,");
            sql.addSql("   CAC_AUTH_ID=?,");
            sql.addSql("   CAC_AUTH_PASS=?,");
            sql.addSql("   CAC_CONTENT_KBN=?,");
            sql.addSql("   CAC_CONTENT_MANUAL=?,");
            sql.addSql("   CAC_BODY=?,");
            sql.addSql("   CAC_AUID=?,");
            sql.addSql("   CAC_ADATE=?,");
            sql.addSql("   CAC_EUID=?,");
            sql.addSql("   CAC_EDATE=?,");
            sql.addSql("   CAC_JKBN=?");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(bean.getCacName());
            sql.addStrValue(bean.getCacDescription());
            sql.addIntValue(bean.getCagSid());
            sql.addIntValue(bean.getCagVersion());
            sql.addStrValue(bean.getCacUrl());
            sql.addIntValue(bean.getCacMethodKbn());
            sql.addIntValue(bean.getCacAuthKbn());
            sql.addStrValue(bean.getCacAuthToken());
            sql.addStrValue(bean.getCacAuthId());
            sql.addStrValue(bean.getCacAuthPass());
            sql.addIntValue(bean.getCacContentKbn());
            sql.addStrValue(bean.getCacContentManual());
            sql.addStrValue(bean.getCacBody());
            sql.addIntValue(bean.getCacAuid());
            sql.addDateValue(bean.getCacAdate());
            sql.addIntValue(bean.getCacEuid());
            sql.addDateValue(bean.getCacEdate());
            sql.addIntValue(bean.getCacJkbn());
            //where
            sql.addIntValue(bean.getCacSid());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <br>[機  能] select文のSQLを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @return select文のSQL
     */
    private SqlBuffer __getSelectSql() {
        SqlBuffer sql = new SqlBuffer();
        sql.addSql(" select ");
        sql.addSql("   CAC_SID,");
        sql.addSql("   CAC_NAME,");
        sql.addSql("   CAC_DESCRIPTION,");
        sql.addSql("   CAG_SID,");
        sql.addSql("   CAG_VERSION,");
        sql.addSql("   CAC_URL,");
        sql.addSql("   CAC_METHOD_KBN,");
        sql.addSql("   CAC_AUTH_KBN,");
        sql.addSql("   CAC_AUTH_TOKEN,");
        sql.addSql("   CAC_AUTH_ID,");
        sql.addSql("   CAC_AUTH_PASS,");
        sql.addSql("   CAC_CONTENT_KBN,");
        sql.addSql("   CAC_CONTENT_MANUAL,");
        sql.addSql("   CAC_BODY,");
        sql.addSql("   CAC_AUID,");
        sql.addSql("   CAC_ADATE,");
        sql.addSql("   CAC_EUID,");
        sql.addSql("   CAC_EDATE,");
        sql.addSql("   CAC_JKBN");
        return sql;
    }

    /**
     * <p>Select CMN_API_CONNECT All Data
     * @return List in CMN_API_CONNECTModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnApiConnectModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<CmnApiConnectModel> ret = new ArrayList<>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CAC_NAME,");
            sql.addSql("   CAC_DESCRIPTION,");
            sql.addSql("   CAG_SID,");
            sql.addSql("   CAG_VERSION,");
            sql.addSql("   CAC_URL,");
            sql.addSql("   CAC_METHOD_KBN,");
            sql.addSql("   CAC_AUTH_KBN,");
            sql.addSql("   CAC_AUTH_TOKEN,");
            sql.addSql("   CAC_AUTH_ID,");
            sql.addSql("   CAC_AUTH_PASS,");
            sql.addSql("   CAC_CONTENT_KBN,");
            sql.addSql("   CAC_CONTENT_MANUAL,");
            sql.addSql("   CAC_BODY,");
            sql.addSql("   CAC_AUID,");
            sql.addSql("   CAC_ADATE,");
            sql.addSql("   CAC_EUID,");
            sql.addSql("   CAC_EDATE,");
            sql.addSql("   CAC_JKBN");
            sql.addSql(" from ");
            sql.addSql("   CMN_API_CONNECT");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 論理削除されていない連携API一覧を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @return 論理削除されていない連携API一覧
     */
    public List<CmnApiConnectModel> selectExist() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<CmnApiConnectModel> ret = new ArrayList<>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = __getSelectSql();
            sql.addSql(" from ");
            sql.addSql("   CMN_API_CONNECT");
            sql.addSql(" where ");
            sql.addSql("   CAC_JKBN = ?");
            sql.addIntValue(GSConst.JTKBN_TOROKU);
            sql.addSql(" order by ");
            sql.addSql("   CAC_SID");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.setParameter(pstmt);
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }



    /**
     * <p>Select CMN_API_CONNECT
     * @param cacSid CAC_SID
     * @return CMN_API_CONNECTModel
     * @throws SQLException SQL実行例外
     */
    public CmnApiConnectModel select(int cacSid) throws SQLException {

        List<Integer> cacSidList = Arrays.asList(cacSid);
        List<CmnApiConnectModel> cacList = select(cacSidList);
        if (cacList.isEmpty()) {
            return null;
        }
        return cacList.get(0);
    }

    /**
     * <br>[機  能] 指定された連携APIを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param cacSidList CAC_SID
     * @return CMN_API_CONNECTModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnApiConnectModel> select(List<Integer> cacSidList) throws SQLException {

        List<CmnApiConnectModel> ret = new ArrayList<>();
        if (cacSidList == null || cacSidList.isEmpty()) {
            return ret;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = __getSelectSql();
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID in (");
            for (int idx = 0; idx < cacSidList.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addIntValue(cacSidList.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] GSAPIのバージョンと異なる連携APIの名前を一覧で取得する
     * <br>[解  説]
     * <br>[備  考]
     * @return GSAPIのバージョンと異なる連携
     */
    public List<CmnApiConnectModel> selectVersionErrorApi() throws SQLException {

        List<CmnApiConnectModel> ret = new ArrayList<>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = __getSelectSql();
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT");
            sql.addSql(" where ");
            sql.addSql("   CMN_API_CONNECT.CAG_SID != ?");
            sql.addIntValue(-1);
            sql.addSql(" and exists (");
            sql.addSql("   select 1");
            sql.addSql("   from");
            sql.addSql("     CMN_API_CONNECT_GSAPI");
            sql.addSql("   where");
            sql.addSql("     CMN_API_CONNECT_GSAPI.CAG_SID = CMN_API_CONNECT.CAG_SID");
            sql.addSql("   and ");
            sql.addSql("     CMN_API_CONNECT.CAG_VERSION != CMN_API_CONNECT_GSAPI.CAG_VERSION");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }


    /**
     * <br>[機  能] 指定された連携APIを論理削除する
     * <br>[解  説]
     * <br>[備  考]
     * @param cacSid
     * @return 論理削除件数
     */
    public int delete(int cacSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CMN_API_CONNECT");
            sql.addSql(" set");
            sql.addSql("   CAC_JKBN = ?");
            sql.addIntValue(GSConst.JTKBN_DELETE);
            sql.addSql(" where ");
            sql.addSql("   CAC_SID=?");
            sql.addIntValue(cacSid);

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create CMN_API_CONNECT Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created CmnApiConnectModel
     * @throws SQLException SQL実行例外
     */
    private CmnApiConnectModel __getCmnApiConnectFromRs(ResultSet rs) throws SQLException {
        CmnApiConnectModel bean = new CmnApiConnectModel();
        bean.setCacSid(rs.getInt("CAC_SID"));
        bean.setCacName(rs.getString("CAC_NAME"));
        bean.setCacDescription(rs.getString("CAC_DESCRIPTION"));
        bean.setCagSid(rs.getInt("CAG_SID"));
        bean.setCagVersion(rs.getInt("CAG_VERSION"));
        bean.setCacUrl(rs.getString("CAC_URL"));
        bean.setCacMethodKbn(rs.getInt("CAC_METHOD_KBN"));
        bean.setCacAuthKbn(rs.getInt("CAC_AUTH_KBN"));
        bean.setCacAuthToken(rs.getString("CAC_AUTH_TOKEN"));
        bean.setCacAuthId(rs.getString("CAC_AUTH_ID"));
        bean.setCacAuthPass(rs.getString("CAC_AUTH_PASS"));
        bean.setCacContentKbn(rs.getInt("CAC_CONTENT_KBN"));
        bean.setCacContentManual(rs.getString("CAC_CONTENT_MANUAL"));
        bean.setCacBody(rs.getString("CAC_BODY"));
        bean.setCacAuid(rs.getInt("CAC_AUID"));
        bean.setCacAdate(UDate.getInstanceTimestamp(rs.getTimestamp("CAC_ADATE")));
        bean.setCacEuid(rs.getInt("CAC_EUID"));
        bean.setCacEdate(UDate.getInstanceTimestamp(rs.getTimestamp("CAC_EDATE")));
        bean.setCacJkbn(rs.getInt("CAC_JKBN"));
        return bean;
    }
}
