package jp.groupsession.v2.cmn.dao.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectGsapiModel;

/**
 * <p>CMN_API_CONNECT_GSAPI Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class CmnApiConnectGsapiDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(CmnApiConnectGsapiDao.class);

    /**
     * <p>Default Constructor
     */
    public CmnApiConnectGsapiDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public CmnApiConnectGsapiDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CMN_API_CONNECT_GSAPI");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CMN_API_CONNECT_GSAPI (");
            sql.addSql("   CAG_SID integer not null,");
            sql.addSql("   CAG_PLUGIN varchar(20) not null,");
            sql.addSql("   CAG_OPERATION varchar(100) not null,");
            sql.addSql("   CAG_PATH varchar(1000) not null,");
            sql.addSql("   CAG_METHOD_KBN integer not null,");
            sql.addSql("   CAG_AUTH_KBN integer not null,");
            sql.addSql("   CAC_CONTENT_KBN integer not null,");
            sql.addSql("   CAG_BODY clob,");
            sql.addSql("   CAG_VERSION integer not null,");
            sql.addSql("   primary key (CAG_SID)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CMN_API_CONNECT_GSAPI Data Bindding JavaBean
     * @param bean CMN_API_CONNECT_GSAPI Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(CmnApiConnectGsapiModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CMN_API_CONNECT_GSAPI(");
            sql.addSql("   CAG_SID,");
            sql.addSql("   CAG_PLUGIN,");
            sql.addSql("   CAG_OPERATION,");
            sql.addSql("   CAG_PATH,");
            sql.addSql("   CAG_METHOD_KBN,");
            sql.addSql("   CAG_AUTH_KBN,");
            sql.addSql("   CAC_CONTENT_KBN,");
            sql.addSql("   CAG_BODY,");
            sql.addSql("   CAG_VERSION");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCagSid());
            sql.addStrValue(bean.getCagPlugin());
            sql.addStrValue(bean.getCagOperation());
            sql.addStrValue(bean.getCagPath());
            sql.addIntValue(bean.getCagMethodKbn());
            sql.addIntValue(bean.getCagAuthKbn());
            sql.addIntValue(bean.getCacContentKbn());
            sql.addStrValue(bean.getCagBody());
            sql.addIntValue(bean.getCagVersion());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update CMN_API_CONNECT_GSAPI Data Bindding JavaBean
     * @param bean CMN_API_CONNECT_GSAPI Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(CmnApiConnectGsapiModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CMN_API_CONNECT_GSAPI");
            sql.addSql(" set ");
            sql.addSql("   CAG_PLUGIN=?,");
            sql.addSql("   CAG_OPERATION=?,");
            sql.addSql("   CAG_PATH=?,");
            sql.addSql("   CAG_METHOD_KBN=?,");
            sql.addSql("   CAG_AUTH_KBN=?,");
            sql.addSql("   CAC_CONTENT_KBN=?,");
            sql.addSql("   CAG_BODY=?,");
            sql.addSql("   CAG_VERSION=?");
            sql.addSql(" where ");
            sql.addSql("   CAG_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(bean.getCagPlugin());
            sql.addStrValue(bean.getCagOperation());
            sql.addStrValue(bean.getCagPath());
            sql.addIntValue(bean.getCagMethodKbn());
            sql.addIntValue(bean.getCagAuthKbn());
            sql.addIntValue(bean.getCacContentKbn());
            sql.addStrValue(bean.getCagBody());
            sql.addIntValue(bean.getCagVersion());
            //where
            sql.addIntValue(bean.getCagSid());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select CMN_API_CONNECT_GSAPI All Data
     * @return List in CMN_API_CONNECT_GSAPIModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnApiConnectGsapiModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<CmnApiConnectGsapiModel> ret = new ArrayList<>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CAG_SID,");
            sql.addSql("   CAG_PLUGIN,");
            sql.addSql("   CAG_OPERATION,");
            sql.addSql("   CAG_PATH,");
            sql.addSql("   CAG_METHOD_KBN,");
            sql.addSql("   CAG_AUTH_KBN,");
            sql.addSql("   CAC_CONTENT_KBN,");
            sql.addSql("   CAG_BODY,");
            sql.addSql("   CAG_VERSION");
            sql.addSql(" from ");
            sql.addSql("   CMN_API_CONNECT_GSAPI");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectGsapiFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CMN_API_CONNECT_GSAPI
     * @param cagSid CAG_SID
     * @return CMN_API_CONNECT_GSAPIModel
     * @throws SQLException SQL実行例外
     */
    public CmnApiConnectGsapiModel select(int cagSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        CmnApiConnectGsapiModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CAG_SID,");
            sql.addSql("   CAG_PLUGIN,");
            sql.addSql("   CAG_OPERATION,");
            sql.addSql("   CAG_PATH,");
            sql.addSql("   CAG_METHOD_KBN,");
            sql.addSql("   CAG_AUTH_KBN,");
            sql.addSql("   CAC_CONTENT_KBN,");
            sql.addSql("   CAG_BODY,");
            sql.addSql("   CAG_VERSION");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_GSAPI");
            sql.addSql(" where ");
            sql.addSql("   CAG_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cagSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getCmnApiConnectGsapiFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete CMN_API_CONNECT_GSAPI
     * @param cagSid CAG_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int cagSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_GSAPI");
            sql.addSql(" where ");
            sql.addSql("   CAG_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cagSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create CMN_API_CONNECT_GSAPI Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created CmnApiConnectGsapiModel
     * @throws SQLException SQL実行例外
     */
    private CmnApiConnectGsapiModel
        __getCmnApiConnectGsapiFromRs(ResultSet rs) throws SQLException {

        CmnApiConnectGsapiModel bean = new CmnApiConnectGsapiModel();
        bean.setCagSid(rs.getInt("CAG_SID"));
        bean.setCagPlugin(rs.getString("CAG_PLUGIN"));
        bean.setCagOperation(rs.getString("CAG_OPERATION"));
        bean.setCagPath(rs.getString("CAG_PATH"));
        bean.setCagMethodKbn(rs.getInt("CAG_METHOD_KBN"));
        bean.setCagAuthKbn(rs.getInt("CAG_AUTH_KBN"));
        bean.setCacContentKbn(rs.getInt("CAC_CONTENT_KBN"));
        bean.setCagBody(rs.getString("CAG_BODY"));
        bean.setCagVersion(rs.getInt("CAG_VERSION"));
        return bean;
    }
}
