package jp.groupsession.v2.cmn.dao.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectGsparamModel;

/**
 * <p>CMN_API_CONNECT_GSPARAM Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class CmnApiConnectGsparamDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(CmnApiConnectGsparamDao.class);

    /**
     * <p>Default Constructor
     */
    public CmnApiConnectGsparamDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public CmnApiConnectGsparamDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CMN_API_CONNECT_GSPARAM");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CMN_API_CONNECT_GSPARAM (");
            sql.addSql("   CAG_SID integer not null,");
            sql.addSql("   CAGP_KBN integer not null,");
            sql.addSql("   CAGP_PARAM_TYPE integer not null,");
            sql.addSql("   CAGP_NAME varchar(50) not null,");
            sql.addSql("   CAGP_NAME_DISP varchar(50) not null,");
            sql.addSql("   CAGP_BIKO varchar(100),");
            sql.addSql("   CAGP_REQUIRED_KBN integer not null,");
            sql.addSql("   CAGP_LIST_KBN integer not null,");
            sql.addSql("   primary key (CAG_SID,CAGP_KBN,CAGP_NAME)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CMN_API_CONNECT_GSPARAM Data Bindding JavaBean
     * @param bean CMN_API_CONNECT_GSPARAM Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(CmnApiConnectGsparamModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CMN_API_CONNECT_GSPARAM(");
            sql.addSql("   CAG_SID,");
            sql.addSql("   CAGP_KBN,");
            sql.addSql("   CAGP_PARAM_TYPE,");
            sql.addSql("   CAGP_NAME,");
            sql.addSql("   CAGP_NAME_DISP,");
            sql.addSql("   CAGP_BIKO,");
            sql.addSql("   CAGP_REQUIRED_KBN,");
            sql.addSql("   CAGP_LIST_KBN");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCagSid());
            sql.addIntValue(bean.getCagpKbn());
            sql.addIntValue(bean.getCagpParamType());
            sql.addStrValue(bean.getCagpName());
            sql.addStrValue(bean.getCagpNameDisp());
            sql.addStrValue(bean.getCagpBiko());
            sql.addIntValue(bean.getCagpRequiredKbn());
            sql.addIntValue(bean.getCagpListKbn());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update CMN_API_CONNECT_GSPARAM Data Bindding JavaBean
     * @param bean CMN_API_CONNECT_GSPARAM Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(CmnApiConnectGsparamModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CMN_API_CONNECT_GSPARAM");
            sql.addSql(" set ");
            sql.addSql("   CAGP_PARAM_TYPE=?,");
            sql.addSql("   CAGP_NAME_DISP=?,");
            sql.addSql("   CAGP_BIKO=?,");
            sql.addSql("   CAGP_REQUIRED_KBN=?,");
            sql.addSql("   CAGP_LIST_KBN=?");
            sql.addSql(" where ");
            sql.addSql("   CAG_SID=?");
            sql.addSql(" and");
            sql.addSql("   CAGP_KBN=?");
            sql.addSql(" and");
            sql.addSql("   CAGP_NAME=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCagpParamType());
            sql.addStrValue(bean.getCagpNameDisp());
            sql.addStrValue(bean.getCagpBiko());
            sql.addIntValue(bean.getCagpRequiredKbn());
            sql.addIntValue(bean.getCagpListKbn());
            //where
            sql.addIntValue(bean.getCagSid());
            sql.addIntValue(bean.getCagpKbn());
            sql.addStrValue(bean.getCagpName());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select CMN_API_CONNECT_GSPARAM All Data
     * @return List in CMN_API_CONNECT_GSPARAMModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnApiConnectGsparamModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<CmnApiConnectGsparamModel> ret = new ArrayList<>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CAG_SID,");
            sql.addSql("   CAGP_KBN,");
            sql.addSql("   CAGP_PARAM_TYPE,");
            sql.addSql("   CAGP_NAME,");
            sql.addSql("   CAGP_NAME_DISP,");
            sql.addSql("   CAGP_BIKO,");
            sql.addSql("   CAGP_REQUIRED_KBN,");
            sql.addSql("   CAGP_LIST_KBN");
            sql.addSql(" from ");
            sql.addSql("   CMN_API_CONNECT_GSPARAM");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectGsparamFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CMN_API_CONNECT_GSPARAM
     * @param cagSid CAG_SID
     * @return List in CMN_API_CONNECT_GSPARAMModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnApiConnectGsparamModel> select(int cagSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<CmnApiConnectGsparamModel> ret = new ArrayList<>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CAG_SID,");
            sql.addSql("   CAGP_KBN,");
            sql.addSql("   CAGP_PARAM_TYPE,");
            sql.addSql("   CAGP_NAME,");
            sql.addSql("   CAGP_NAME_DISP,");
            sql.addSql("   CAGP_BIKO,");
            sql.addSql("   CAGP_REQUIRED_KBN,");
            sql.addSql("   CAGP_LIST_KBN");
            sql.addSql(" from ");
            sql.addSql("   CMN_API_CONNECT_GSPARAM");
            sql.addSql(" where ");
            sql.addSql("   CAG_SID = ?");
            sql.addIntValue(cagSid);

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.setParameter(pstmt);
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectGsparamFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CMN_API_CONNECT_GSPARAM
     * @param cagSid CAG_SID
     * @param cagpKbn CAGP_KBN
     * @param cagpName CAGP_NAME
     * @return CMN_API_CONNECT_GSPARAMModel
     * @throws SQLException SQL実行例外
     */
    public CmnApiConnectGsparamModel select(
        int cagSid, int cagpKbn, String cagpName) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        CmnApiConnectGsparamModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CAG_SID,");
            sql.addSql("   CAGP_KBN,");
            sql.addSql("   CAGP_PARAM_TYPE,");
            sql.addSql("   CAGP_NAME,");
            sql.addSql("   CAGP_NAME_DISP,");
            sql.addSql("   CAGP_BIKO,");
            sql.addSql("   CAGP_REQUIRED_KBN,");
            sql.addSql("   CAGP_LIST_KBN");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_GSPARAM");
            sql.addSql(" where ");
            sql.addSql("   CAG_SID=?");
            sql.addSql(" and");
            sql.addSql("   CAGP_KBN=?");
            sql.addSql(" and");
            sql.addSql("   CAGP_NAME=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cagSid);
            sql.addIntValue(cagpKbn);
            sql.addStrValue(cagpName);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getCmnApiConnectGsparamFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete CMN_API_CONNECT_GSPARAM
     * @param cagSid CAG_SID
     * @param cagpKbn CAGP_KBN
     * @param cagpName CAGP_NAME
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int cagSid, int cagpKbn, String cagpName) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_GSPARAM");
            sql.addSql(" where ");
            sql.addSql("   CAG_SID=?");
            sql.addSql(" and");
            sql.addSql("   CAGP_KBN=?");
            sql.addSql(" and");
            sql.addSql("   CAGP_NAME=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cagSid);
            sql.addIntValue(cagpKbn);
            sql.addStrValue(cagpName);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create CMN_API_CONNECT_GSPARAM Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created CmnApiConnectGsparamModel
     * @throws SQLException SQL実行例外
     */
    private CmnApiConnectGsparamModel
        __getCmnApiConnectGsparamFromRs(ResultSet rs) throws SQLException {

        CmnApiConnectGsparamModel bean = new CmnApiConnectGsparamModel();
        bean.setCagSid(rs.getInt("CAG_SID"));
        bean.setCagpKbn(rs.getInt("CAGP_KBN"));
        bean.setCagpParamType(rs.getInt("CAGP_PARAM_TYPE"));
        bean.setCagpName(rs.getString("CAGP_NAME"));
        bean.setCagpNameDisp(rs.getString("CAGP_NAME_DISP"));
        bean.setCagpBiko(rs.getString("CAGP_BIKO"));
        bean.setCagpRequiredKbn(rs.getInt("CAGP_REQUIRED_KBN"));
        bean.setCagpListKbn(rs.getInt("CAGP_LIST_KBN"));
        return bean;
    }
}
