package jp.groupsession.v2.cmn.dao.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectHeaderModel;

/**
 * <p>CMN_API_CONNECT_HEADER Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class CmnApiConnectHeaderDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(CmnApiConnectHeaderDao.class);

    /**
     * <p>Default Constructor
     */
    public CmnApiConnectHeaderDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public CmnApiConnectHeaderDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CMN_API_CONNECT_HEADER");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CMN_API_CONNECT_HEADER (");
            sql.addSql("   CAC_SID integer not null,");
            sql.addSql("   CACH_SORT integer not null,");
            sql.addSql("   CACH_KEY varchar(100) not null,");
            sql.addSql("   CACH_VALUE varchar(300) not null,");
            sql.addSql("   primary key (CAC_SID,CACH_SORT)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CMN_API_CONNECT_HEADER Data Bindding JavaBean
     * @param bean CMN_API_CONNECT_HEADER Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(CmnApiConnectHeaderModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CMN_API_CONNECT_HEADER(");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CACH_SORT,");
            sql.addSql("   CACH_KEY,");
            sql.addSql("   CACH_VALUE");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCacSid());
            sql.addIntValue(bean.getCachSort());
            sql.addStrValue(bean.getCachKey());
            sql.addStrValue(bean.getCachValue());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] リクエストヘッダ情報を一括で登録する
     * <br>[解  説]
     * <br>[備  考]
     * @param beanList リクエストヘッダ情報一覧
     * @throws SQLException SQL実行例外
     */
    public void insert(List<CmnApiConnectHeaderModel> beanList) throws SQLException {

        if (beanList == null || beanList.isEmpty()) {
            return;
        }

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CMN_API_CONNECT_HEADER(");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CACH_SORT,");
            sql.addSql("   CACH_KEY,");
            sql.addSql("   CACH_VALUE");
            sql.addSql(" )");
            sql.addSql(" values");
            CmnApiConnectHeaderModel bean = null;
            for (int idx = 0; idx < beanList.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");    
                }
                sql.addSql(" (");
                sql.addSql("   ?,");
                sql.addSql("   ?,");
                sql.addSql("   ?,");
                sql.addSql("   ?");
                sql.addSql(" )");
                bean = beanList.get(idx);
                sql.addIntValue(bean.getCacSid());
                sql.addIntValue(bean.getCachSort());
                sql.addStrValue(bean.getCachKey());
                sql.addStrValue(bean.getCachValue());
            }
            

            pstmt = con.prepareStatement(sql.toSqlString());
            
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update CMN_API_CONNECT_HEADER Data Bindding JavaBean
     * @param bean CMN_API_CONNECT_HEADER Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(CmnApiConnectHeaderModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CMN_API_CONNECT_HEADER");
            sql.addSql(" set ");
            sql.addSql("   CACH_KEY=?,");
            sql.addSql("   CACH_VALUE=?");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID=?");
            sql.addSql(" and");
            sql.addSql("   CACH_SORT=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(bean.getCachKey());
            sql.addStrValue(bean.getCachValue());
            //where
            sql.addIntValue(bean.getCacSid());
            sql.addIntValue(bean.getCachSort());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select CMN_API_CONNECT_HEADER All Data
     * @return List in CMN_API_CONNECT_HEADERModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnApiConnectHeaderModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<CmnApiConnectHeaderModel> ret = new ArrayList<CmnApiConnectHeaderModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CACH_SORT,");
            sql.addSql("   CACH_KEY,");
            sql.addSql("   CACH_VALUE");
            sql.addSql(" from ");
            sql.addSql("   CMN_API_CONNECT_HEADER");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectHeaderFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 指定した連携APIの追加ヘッダーをソート順に取得します
     * <br>[解  説]
     * <br>[備  考] 
     * @param cacSid 連携APIのSID
     * @return List in CMN_API_CONNECT_HEADERModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnApiConnectHeaderModel> select(int cacSid) throws SQLException {

        List<Integer> cacSidList = Arrays.asList(cacSid);
        List<CmnApiConnectHeaderModel> ret = select(cacSidList);
        return ret;
    }

    /**
     * <br>[機  能] 指定した連携APIの追加ヘッダーをソート順に取得します
     * <br>[解  説]
     * <br>[備  考] 
     * @param cacSidList 連携APIのSID
     * @return List in CMN_API_CONNECT_HEADERModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnApiConnectHeaderModel> select(
        List<Integer> cacSidList) throws SQLException {

        List<CmnApiConnectHeaderModel> ret = new ArrayList<>();
        if (cacSidList == null || cacSidList.isEmpty()) {
            return ret;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CACH_SORT,");
            sql.addSql("   CACH_KEY,");
            sql.addSql("   CACH_VALUE");
            sql.addSql(" from ");
            sql.addSql("   CMN_API_CONNECT_HEADER");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID in (");
            for (int idx = 0; idx < cacSidList.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addIntValue(cacSidList.get(idx));
            }
            sql.addSql("   )");
            sql.addSql(" order by ");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CACH_SORT");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.setParameter(pstmt);
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectHeaderFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CMN_API_CONNECT_HEADER
     * @param cacSid CAC_SID
     * @param cachSort CACH_SORT
     * @return CMN_API_CONNECT_HEADERModel
     * @throws SQLException SQL実行例外
     */
    public CmnApiConnectHeaderModel select(int cacSid, int cachSort) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        CmnApiConnectHeaderModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CACH_SORT,");
            sql.addSql("   CACH_KEY,");
            sql.addSql("   CACH_VALUE");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_HEADER");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID=?");
            sql.addSql(" and");
            sql.addSql("   CACH_SORT=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cacSid);
            sql.addIntValue(cachSort);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getCmnApiConnectHeaderFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 指定された連携APIのヘッダー情報を削除する
     * <br>[解  説]
     * <br>[備  考]
     * @param cacSid CAC_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int cacSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_HEADER");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cacSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Delete CMN_API_CONNECT_HEADER
     * @param cacSid CAC_SID
     * @param cachSort CACH_SORT
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int cacSid, int cachSort) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_HEADER");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID=?");
            sql.addSql(" and");
            sql.addSql("   CACH_SORT=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cacSid);
            sql.addIntValue(cachSort);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create CMN_API_CONNECT_HEADER Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created CmnApiConnectHeaderModel
     * @throws SQLException SQL実行例外
     */
    private CmnApiConnectHeaderModel
        __getCmnApiConnectHeaderFromRs(ResultSet rs) throws SQLException {

        CmnApiConnectHeaderModel bean = new CmnApiConnectHeaderModel();
        bean.setCacSid(rs.getInt("CAC_SID"));
        bean.setCachSort(rs.getInt("CACH_SORT"));
        bean.setCachKey(rs.getString("CACH_KEY"));
        bean.setCachValue(rs.getString("CACH_VALUE"));
        return bean;
    }
}
