package jp.groupsession.v2.cmn.dao.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectHistoryModel;

/**
 * <p>CMN_API_CONNECT_HISTORY Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class CmnApiConnectHistoryDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(CmnApiConnectHistoryDao.class);

    /**
     * <p>Default Constructor
     */
    public CmnApiConnectHistoryDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public CmnApiConnectHistoryDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CMN_API_CONNECT_HISTORY");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CMN_API_CONNECT_HISTORY (");
            sql.addSql("   CAC_HISTORY_SID integer not null,");
            sql.addSql("   CAC_SID integer not null,");
            sql.addSql("   CAC_AUID integer not null,");
            sql.addSql("   CAC_ADATE timestamp not null,");
            sql.addSql("   CAC_EUID integer not null,");
            sql.addSql("   CAC_EDATE timestamp not null,");
            sql.addSql("   primary key (CAC_HISTORY_SID,CAC_SID)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CMN_API_CONNECT_HISTORY Data Bindding JavaBean
     * @param bean CMN_API_CONNECT_HISTORY Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(CmnApiConnectHistoryModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CMN_API_CONNECT_HISTORY(");
            sql.addSql("   CAC_HISTORY_SID,");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CAC_AUID,");
            sql.addSql("   CAC_ADATE,");
            sql.addSql("   CAC_EUID,");
            sql.addSql("   CAC_EDATE");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCacHistorySid());
            sql.addIntValue(bean.getCacSid());
            sql.addIntValue(bean.getCacAuid());
            sql.addDateValue(bean.getCacAdate());
            sql.addIntValue(bean.getCacEuid());
            sql.addDateValue(bean.getCacEdate());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update CMN_API_CONNECT_HISTORY Data Bindding JavaBean
     * @param bean CMN_API_CONNECT_HISTORY Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(CmnApiConnectHistoryModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CMN_API_CONNECT_HISTORY");
            sql.addSql(" set ");
            sql.addSql("   CAC_AUID=?,");
            sql.addSql("   CAC_ADATE=?,");
            sql.addSql("   CAC_EUID=?,");
            sql.addSql("   CAC_EDATE=?");
            sql.addSql(" where ");
            sql.addSql("   CAC_HISTORY_SID=?");
            sql.addSql(" and");
            sql.addSql("   CAC_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCacAuid());
            sql.addDateValue(bean.getCacAdate());
            sql.addIntValue(bean.getCacEuid());
            sql.addDateValue(bean.getCacEdate());
            //where
            sql.addIntValue(bean.getCacHistorySid());
            sql.addIntValue(bean.getCacSid());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select CMN_API_CONNECT_HISTORY All Data
     * @return List in CMN_API_CONNECT_HISTORYModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnApiConnectHistoryModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<CmnApiConnectHistoryModel> ret = new ArrayList<CmnApiConnectHistoryModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CAC_HISTORY_SID,");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CAC_AUID,");
            sql.addSql("   CAC_ADATE,");
            sql.addSql("   CAC_EUID,");
            sql.addSql("   CAC_EDATE");
            sql.addSql(" from ");
            sql.addSql("   CMN_API_CONNECT_HISTORY");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectHistoryFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }
    
    /**
     * <p>Select CMN_API_CONNECT_HISTORY
     * @param cacSid CAC_SID
     * @return CMN_API_CONNECT_HISTORYModel
     * @throws SQLException SQL実行例外
     */
    public CmnApiConnectHistoryModel select(int cacSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        CmnApiConnectHistoryModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CAC_HISTORY_SID,");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CAC_AUID,");
            sql.addSql("   CAC_ADATE,");
            sql.addSql("   CAC_EUID,");
            sql.addSql("   CAC_EDATE");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_HISTORY");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cacSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getCmnApiConnectHistoryFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CMN_API_CONNECT_HISTORY
     * @param cacHistorySid CAC_HISTORY_SID
     * @param cacSid CAC_SID
     * @return CMN_API_CONNECT_HISTORYModel
     * @throws SQLException SQL実行例外
     */
    public CmnApiConnectHistoryModel select(int cacHistorySid, int cacSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        CmnApiConnectHistoryModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CAC_HISTORY_SID,");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CAC_AUID,");
            sql.addSql("   CAC_ADATE,");
            sql.addSql("   CAC_EUID,");
            sql.addSql("   CAC_EDATE");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_HISTORY");
            sql.addSql(" where ");
            sql.addSql("   CAC_HISTORY_SID=?");
            sql.addSql(" and");
            sql.addSql("   CAC_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cacHistorySid);
            sql.addIntValue(cacSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getCmnApiConnectHistoryFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete CMN_API_CONNECT_HISTORY
     * @param cacHistorySid CAC_HISTORY_SID
     * @param cacSid CAC_SID
     * @throws SQLException SQL実行例外
     * @return 件数
     */
    public int delete(int cacHistorySid, int cacSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_HISTORY");
            sql.addSql(" where ");
            sql.addSql("   CAC_HISTORY_SID=?");
            sql.addSql(" and");
            sql.addSql("   CAC_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cacHistorySid);
            sql.addIntValue(cacSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create CMN_API_CONNECT_HISTORY Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created CmnApiConnectHistoryModel
     * @throws SQLException SQL実行例外
     */
    private CmnApiConnectHistoryModel
    __getCmnApiConnectHistoryFromRs(ResultSet rs) throws SQLException {
        CmnApiConnectHistoryModel bean = new CmnApiConnectHistoryModel();
        bean.setCacHistorySid(rs.getInt("CAC_HISTORY_SID"));
        bean.setCacSid(rs.getInt("CAC_SID"));
        bean.setCacAuid(rs.getInt("CAC_AUID"));
        bean.setCacAdate(UDate.getInstanceTimestamp(rs.getTimestamp("CAC_ADATE")));
        bean.setCacEuid(rs.getInt("CAC_EUID"));
        bean.setCacEdate(UDate.getInstanceTimestamp(rs.getTimestamp("CAC_EDATE")));
        return bean;
    }
    /**
     *
     * <br>[機  能] 旧CacSidから最新のCacSidを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param oldCacSid 旧CACSID
     * @return 最新のCACSID 見つからない場合 null
     * @throws SQLException SQL実行時例外
     */
    public Integer getNewestCacSid(int oldCacSid) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();
        Integer ret = null;
        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   max(HISTORY.CAC_SID) as NEWEST");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_HISTORY CHK");
            sql.addSql("   inner join CMN_API_CONNECT_HISTORY HISTORY");
            sql.addSql("   on CHK.CAC_HISTORY_SID = HISTORY.CAC_HISTORY_SID");
            sql.addSql(" where ");
            sql.addSql("   CHK.CAC_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(oldCacSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = rs.getInt("NEWEST");
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;

    }
}
