package jp.groupsession.v2.cmn.dao.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectParamModel;

/**
 * <p>CMN_API_CONNECT_PARAM Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class CmnApiConnectParamDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(CmnApiConnectParamDao.class);

    /**
     * <p>Default Constructor
     */
    public CmnApiConnectParamDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public CmnApiConnectParamDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CMN_API_CONNECT_PARAM");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CMN_API_CONNECT_PARAM (");
            sql.addSql("   CAC_SID integer not null,");
            sql.addSql("   CACP_KBN integer not null,");
            sql.addSql("   CACP_PARAM_TYPE integer not null,");
            sql.addSql("   CACP_NAME varchar(50) not null,");
            sql.addSql("   CACP_NAME_DISP varchar(50) not null,");
            sql.addSql("   CACP_BIKO varchar(100),");
            sql.addSql("   CACP_REQUIRED_KBN integer not null,");
            sql.addSql("   CACP_LIST_KBN integer not null,");
            sql.addSql("   primary key (CAC_SID,CACP_KBN,CACP_NAME)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CMN_API_CONNECT_PARAM Data Bindding JavaBean
     * @param bean CMN_API_CONNECT_PARAM Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(CmnApiConnectParamModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CMN_API_CONNECT_PARAM(");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CACP_KBN,");
            sql.addSql("   CACP_PARAM_TYPE,");
            sql.addSql("   CACP_NAME,");
            sql.addSql("   CACP_NAME_DISP,");
            sql.addSql("   CACP_BIKO,");
            sql.addSql("   CACP_REQUIRED_KBN,");
            sql.addSql("   CACP_LIST_KBN");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCacSid());
            sql.addIntValue(bean.getCacpKbn());
            sql.addIntValue(bean.getCacpParamType());
            sql.addStrValue(bean.getCacpName());
            sql.addStrValue(bean.getCacpNameDisp());
            sql.addStrValue(bean.getCacpBiko());
            sql.addIntValue(bean.getCacpRequiredKbn());
            sql.addIntValue(bean.getCacpListKbn());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] パラメータ情報を一括で登録する
     * <br>[解  説]
     * <br>[備  考]
     * @param beanList パラメータ情報一覧
     * @throws SQLException SQL実行例外
     */
    public void insert(List<CmnApiConnectParamModel> beanList) throws SQLException {

        if (beanList == null || beanList.isEmpty()) {
            return;
        }
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            StringBuilder sb = new StringBuilder();
            sb.append(" insert ");
            sb.append(" into ");
            sb.append(" CMN_API_CONNECT_PARAM(");
            sb.append("   CAC_SID,");
            sb.append("   CACP_KBN,");
            sb.append("   CACP_PARAM_TYPE,");
            sb.append("   CACP_NAME,");
            sb.append("   CACP_NAME_DISP,");
            sb.append("   CACP_BIKO,");
            sb.append("   CACP_REQUIRED_KBN,");
            sb.append("   CACP_LIST_KBN");
            sb.append(" )");
            sb.append(" values");

            List<CmnApiConnectParamModel> exeList = new ArrayList<CmnApiConnectParamModel>();
            Iterator<CmnApiConnectParamModel> itr = beanList.iterator();
            while (itr.hasNext()) {
                exeList.add(itr.next());
                if (exeList.size() < 500
                        && itr.hasNext()) {
                    continue;
                }

                //500件毎に実行
                SqlBuffer sql = new SqlBuffer();
                sql.addSql(sb.toString());

                Iterator<CmnApiConnectParamModel> exeItr = exeList.iterator();
                while (exeItr.hasNext()) {
                    CmnApiConnectParamModel mdl = exeItr.next();
                    sql.addSql(" (");
                    sql.addSql("   ?,");
                    sql.addSql("   ?,");
                    sql.addSql("   ?,");
                    sql.addSql("   ?,");
                    sql.addSql("   ?,");
                    sql.addSql("   ?,");
                    sql.addSql("   ?,");
                    sql.addSql("   ?");
                    sql.addSql(" )");
                    sql.addIntValue(mdl.getCacSid());
                    sql.addIntValue(mdl.getCacpKbn());
                    sql.addIntValue(mdl.getCacpParamType());
                    sql.addStrValue(mdl.getCacpName());
                    sql.addStrValue(mdl.getCacpNameDisp());
                    sql.addStrValue(mdl.getCacpBiko());
                    sql.addIntValue(mdl.getCacpRequiredKbn());
                    sql.addIntValue(mdl.getCacpListKbn());
                    if (exeItr.hasNext()) {
                        sql.addSql(",");
                    }
                }

                try (PreparedStatement pstmt = con.prepareStatement(sql.toSqlString());) {
                    sql.setParameter(pstmt);
                    log__.info(sql.toLogString());
                    pstmt.executeUpdate();
                }
                exeList.clear();
            }
        } catch (SQLException e) {
            throw e;
        }
    }

    /**
     * <p>Update CMN_API_CONNECT_PARAM Data Bindding JavaBean
     * @param bean CMN_API_CONNECT_PARAM Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(CmnApiConnectParamModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CMN_API_CONNECT_PARAM");
            sql.addSql(" set ");
            sql.addSql("   CACP_PARAM_TYPE=?,");
            sql.addSql("   CACP_NAME_DISP=?,");
            sql.addSql("   CACP_BIKO=?,");
            sql.addSql("   CACP_REQUIRED_KBN=?,");
            sql.addSql("   CACP_LIST_KBN=?");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID=?");
            sql.addSql(" and");
            sql.addSql("   CACP_KBN=?");
            sql.addSql(" and");
            sql.addSql("   CACP_NAME=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCacpParamType());
            sql.addStrValue(bean.getCacpNameDisp());
            sql.addStrValue(bean.getCacpBiko());
            sql.addIntValue(bean.getCacpRequiredKbn());
            sql.addIntValue(bean.getCacpListKbn());
            //where
            sql.addIntValue(bean.getCacSid());
            sql.addIntValue(bean.getCacpKbn());
            sql.addStrValue(bean.getCacpName());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select CMN_API_CONNECT_PARAM All Data
     * @return List in CMN_API_CONNECT_PARAMModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnApiConnectParamModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<CmnApiConnectParamModel> ret = new ArrayList<>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CACP_KBN,");
            sql.addSql("   CACP_PARAM_TYPE,");
            sql.addSql("   CACP_NAME,");
            sql.addSql("   CACP_NAME_DISP,");
            sql.addSql("   CACP_BIKO,");
            sql.addSql("   CACP_REQUIRED_KBN,");
            sql.addSql("   CACP_LIST_KBN");
            sql.addSql(" from ");
            sql.addSql("   CMN_API_CONNECT_PARAM");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectParamFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] selectで使用するSQLを返します。
     * <br>[解  説]
     * <br>[備  考]
     * @return selectで使用するSQL
     */
    private SqlBuffer __getSelectSql() {

        SqlBuffer sql = new SqlBuffer();
        sql.addSql(" select ");
        sql.addSql("   CAC_SID,");
        sql.addSql("   CACP_KBN,");
        sql.addSql("   CACP_PARAM_TYPE,");
        sql.addSql("   CACP_NAME,");
        sql.addSql("   CACP_NAME_DISP,");
        sql.addSql("   CACP_BIKO,");
        sql.addSql("   CACP_REQUIRED_KBN,");
        sql.addSql("   CACP_LIST_KBN");
        return sql;
    }

    /**
     * <br>[機  能] 指定した連携APIのパラメータ情報を取得する
     * <br>[解  説]
     * <br>[備  考] パスパラメータ，クエリパラメータ，ボディパラメータを一度に取得します
     * @param cacSid 連携APISID
     * @return List in CMN_API_CONNECT_PARAMModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnApiConnectParamModel> select(int cacSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<CmnApiConnectParamModel> ret = new ArrayList<CmnApiConnectParamModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = __getSelectSql();
            sql.addSql(" from ");
            sql.addSql("   CMN_API_CONNECT_PARAM");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID = ?");
            sql.addIntValue(cacSid);

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.setParameter(pstmt);
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectParamFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 指定した連携APIのパラメータ情報を取得する
     * <br>[解  説]
     * <br>[備  考] パスパラメータ，クエリパラメータ，ボディパラメータを一度に取得します
     * @param cacSidList 連携APISID一覧
     * @return List in CMN_API_CONNECT_PARAMModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnApiConnectParamModel> select(List<Integer> cacSidList) throws SQLException {

        ArrayList<CmnApiConnectParamModel> ret = new ArrayList<CmnApiConnectParamModel>();
        if (cacSidList == null || cacSidList.isEmpty()) {
            return ret;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = __getSelectSql();
            sql.addSql(" from ");
            sql.addSql("   CMN_API_CONNECT_PARAM");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID in (");
            for (int idx = 0; idx < cacSidList.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addIntValue(cacSidList.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.setParameter(pstmt);
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectParamFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CMN_API_CONNECT_PARAM
     * @param cacSid CAC_SID
     * @param cacpKbn CACP_KBN
     * @param cacpName CACP_NAME
     * @return CMN_API_CONNECT_PARAMModel
     * @throws SQLException SQL実行例外
     */
    public CmnApiConnectParamModel select(
        int cacSid, int cacpKbn, String cacpName) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        CmnApiConnectParamModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CAC_SID,");
            sql.addSql("   CACP_KBN,");
            sql.addSql("   CACP_PARAM_TYPE,");
            sql.addSql("   CACP_NAME,");
            sql.addSql("   CACP_NAME_DISP,");
            sql.addSql("   CACP_BIKO,");
            sql.addSql("   CACP_REQUIRED_KBN,");
            sql.addSql("   CACP_LIST_KBN");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_PARAM");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID=?");
            sql.addSql(" and");
            sql.addSql("   CACP_KBN=?");
            sql.addSql(" and");
            sql.addSql("   CACP_NAME=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cacSid);
            sql.addIntValue(cacpKbn);
            sql.addStrValue(cacpName);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getCmnApiConnectParamFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * 連携APIパラメータ情報を取得する
     * @param cacSid 連携APISID
     * @param cacpKbn パラメータ区分
     * @param cacpNameList パラメータ名リスト
     * @return CMN_API_CONNECT_PARAMModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnApiConnectParamModel> select(
        int cacSid, int cacpKbn, List<String> cacpNameList) throws SQLException {

        List<CmnApiConnectParamModel> ret = new ArrayList<CmnApiConnectParamModel>();
        if (cacpNameList == null || cacpNameList.isEmpty()) {
            return ret;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = __getSelectSql();
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_PARAM");
            sql.addSql(" where ");
            sql.addSql("   CACP_NAME in (");
            for (int idx = 0; idx < cacpNameList.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addStrValue(cacpNameList.get(idx));
            }
            sql.addSql("   )");
            sql.addSql(" and");
            sql.addSql("   CAC_SID=?");
            sql.addSql(" and");
            sql.addSql("   CACP_KBN=?");

            sql.addIntValue(cacSid);
            sql.addIntValue(cacpKbn);
            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnApiConnectParamFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 指定した連携APIの削除処理を実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param cacSid CAC_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int cacSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_PARAM");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cacSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Delete CMN_API_CONNECT_PARAM
     * @param cacSid CAC_SID
     * @param cacpKbn CACP_KBN
     * @param cacpName CACP_NAME
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int cacSid, int cacpKbn, String cacpName) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CMN_API_CONNECT_PARAM");
            sql.addSql(" where ");
            sql.addSql("   CAC_SID=?");
            sql.addSql(" and");
            sql.addSql("   CACP_KBN=?");
            sql.addSql(" and");
            sql.addSql("   CACP_NAME=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cacSid);
            sql.addIntValue(cacpKbn);
            sql.addStrValue(cacpName);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create CMN_API_CONNECT_PARAM Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created CmnApiConnectParamModel
     * @throws SQLException SQL実行例外
     */
    private CmnApiConnectParamModel
        __getCmnApiConnectParamFromRs(ResultSet rs) throws SQLException {

        CmnApiConnectParamModel bean = new CmnApiConnectParamModel();
        bean.setCacSid(rs.getInt("CAC_SID"));
        bean.setCacpKbn(rs.getInt("CACP_KBN"));
        bean.setCacpParamType(rs.getInt("CACP_PARAM_TYPE"));
        bean.setCacpName(rs.getString("CACP_NAME"));
        bean.setCacpNameDisp(rs.getString("CACP_NAME_DISP"));
        bean.setCacpBiko(rs.getString("CACP_BIKO"));
        bean.setCacpRequiredKbn(rs.getInt("CACP_REQUIRED_KBN"));
        bean.setCacpListKbn(rs.getInt("CACP_LIST_KBN"));
        return bean;
    }
}
