package jp.groupsession.v2.cmn.dao.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.model.base.CmnInfoMsgBinModel;

/**
 * <p>CMN_INFO_MSG_BIN Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class CmnInfoMsgBinDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(CmnInfoMsgBinDao.class);

    /**
     * <p>Default Constructor
     */
    public CmnInfoMsgBinDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public CmnInfoMsgBinDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CMN_INFO_MSG_BIN");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CMN_INFO_MSG_BIN (");
            sql.addSql("   IMS_SID integer not null,");
            sql.addSql("   IMSB_SID integer not null,");
            sql.addSql("   BIN_SID bigint not null,");
            sql.addSql("   primary key (IMS_SID,IMSB_SID)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CMN_INFO_MSG_BIN Data Bindding JavaBean
     * @param bean CMN_INFO_MSG_BIN Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(CmnInfoMsgBinModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CMN_INFO_MSG_BIN(");
            sql.addSql("   IMS_SID,");
            sql.addSql("   IMSB_SID,");
            sql.addSql("   BIN_SID");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getImsSid());
            sql.addIntValue(bean.getImsbSid());
            sql.addLongValue(bean.getBinSid());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] インフォメーションの内容の中の画像ファイル情報を登録する
     * <br>[解  説]
     * <br>[備  考]
     * @param binMdlList 画像ファイルリスト
     * @throws SQLException SQL実行例外
     */
    public void insertData(List<CmnInfoMsgBinModel> binMdlList) throws SQLException {

        if (binMdlList == null || binMdlList.isEmpty()) {
            return;
        }

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CMN_INFO_MSG_BIN(");
            sql.addSql("   IMS_SID,");
            sql.addSql("   IMSB_SID,");
            sql.addSql("   BIN_SID");
            sql.addSql(" )");
            sql.addSql(" values");

            //IMSB_SIDには1から始まる連番値を設定する
            CmnInfoMsgBinModel binMdl = null;
            for (int idx = 0; idx < binMdlList.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql(" (");
                sql.addSql("   ?,");
                sql.addSql("   ?,");
                sql.addSql("   ?");
                sql.addSql(" )");
                binMdl = binMdlList.get(idx);
                sql.addIntValue(binMdl.getImsSid());
                sql.addIntValue(binMdl.getImsbSid());
                sql.addLongValue(binMdl.getBinSid());
            }

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update CMN_INFO_MSG_BIN Data Bindding JavaBean
     * @param bean CMN_INFO_MSG_BIN Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(CmnInfoMsgBinModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CMN_INFO_MSG_BIN");
            sql.addSql(" set ");
            sql.addSql("   BIN_SID=?");
            sql.addSql(" where ");
            sql.addSql("   IMS_SID=?");
            sql.addSql(" and");
            sql.addSql("   IMSB_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addLongValue(bean.getBinSid());
            //where
            sql.addIntValue(bean.getImsSid());
            sql.addIntValue(bean.getImsbSid());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select CMN_INFO_MSG_BIN All Data
     * @return List in CMN_INFO_MSG_BINModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnInfoMsgBinModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<CmnInfoMsgBinModel> ret = new ArrayList<CmnInfoMsgBinModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   IMS_SID,");
            sql.addSql("   IMSB_SID,");
            sql.addSql("   BIN_SID");
            sql.addSql(" from ");
            sql.addSql("   CMN_INFO_MSG_BIN");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnInfoMsgBinFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 指定されたインフォメーションのtinyMCE内の画像情報を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param imsSid インフォメーションSID
     * @return List in CMN_INFO_MSG_BINModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnInfoMsgBinModel> select(int imsSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<CmnInfoMsgBinModel> ret = new ArrayList<CmnInfoMsgBinModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   IMS_SID,");
            sql.addSql("   IMSB_SID,");
            sql.addSql("   BIN_SID");
            sql.addSql(" from ");
            sql.addSql("   CMN_INFO_MSG_BIN");
            sql.addSql(" where ");
            sql.addSql("   IMS_SID = ?");

            sql.addIntValue(imsSid);

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.setParameter(pstmt);
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnInfoMsgBinFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CMN_INFO_MSG_BIN
     * @param imsSid IMS_SID
     * @param imsbSid IMSB_SID
     * @return CMN_INFO_MSG_BINModel
     * @throws SQLException SQL実行例外
     */
    public CmnInfoMsgBinModel select(int imsSid, int imsbSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        CmnInfoMsgBinModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   IMS_SID,");
            sql.addSql("   IMSB_SID,");
            sql.addSql("   BIN_SID");
            sql.addSql(" from");
            sql.addSql("   CMN_INFO_MSG_BIN");
            sql.addSql(" where ");
            sql.addSql("   IMS_SID=?");
            sql.addSql(" and");
            sql.addSql("   IMSB_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(imsSid);
            sql.addIntValue(imsbSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getCmnInfoMsgBinFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete CMN_INFO_MSG_BIN
     * @param imsSid IMS_SID
     * @param imsbSid IMSB_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int imsSid, int imsbSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CMN_INFO_MSG_BIN");
            sql.addSql(" where ");
            sql.addSql("   IMS_SID=?");
            sql.addSql(" and");
            sql.addSql("   IMSB_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(imsSid);
            sql.addIntValue(imsbSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <br>[機  能] 指定されたインフォメーションのtinyMCE内の画像情報を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param imsSid IMS_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(List<Integer> imsSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CMN_INFO_MSG_BIN");
            sql.addSql(" where ");
            sql.addSql("   IMS_SID in (");
            for (int idx = 0; idx < imsSid.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addIntValue(imsSid.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <br>[機  能] 指定されたインフォメーションの内容の中のバイナリーファイル情報を論理削除する
     * <br>[解  説] 状態区分を9:削除に更新する
     * <br>[備  考]
     * @param imsSid SID
     * @return 削除(更新)件数
     * @throws SQLException SQL実行例外
     */
    public int deleteBinf(List<Integer> imsSid) throws SQLException {

        if (imsSid == null || imsSid.isEmpty()) {
            return 0;
        }
        PreparedStatement pstmt = null;
        int count = 0;

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("  update");
            sql.addSql("    CMN_BINF");
            sql.addSql("  set");
            sql.addSql("    BIN_JKBN = ?");
            sql.addIntValue(GSConst.JTKBN_DELETE);
            sql.addSql("  where");
            sql.addSql("    BIN_SID in (");
            sql.addSql("      select BIN_SID from CMN_INFO_MSG_BIN");
            sql.addSql("      where IMS_SID in (");
            for (int idx = 0; idx < imsSid.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addIntValue(imsSid.get(idx));
            }
            sql.addSql("      )");
            sql.addSql("    )");

            log__.info(sql.toLogString());

            pstmt = getCon().prepareStatement(sql.toSqlString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();

        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }

        return count;
    }

    /**
     * <p>Create CMN_INFO_MSG_BIN Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created CmnInfoMsgBinModel
     * @throws SQLException SQL実行例外
     */
    private CmnInfoMsgBinModel __getCmnInfoMsgBinFromRs(ResultSet rs) throws SQLException {
        CmnInfoMsgBinModel bean = new CmnInfoMsgBinModel();
        bean.setImsSid(rs.getInt("IMS_SID"));
        bean.setImsbSid(rs.getInt("IMSB_SID"));
        bean.setBinSid(rs.getInt("BIN_SID"));
        return bean;
    }
}
