package jp.groupsession.v2.cmn.dao.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cmn.model.base.CmnRokuyoModel;

/**
 * <p>CMN_ROKUYO Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class CmnRokuyoDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(CmnRokuyoDao.class);

    /**
     * <p>Default Constructor
     */
    public CmnRokuyoDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public CmnRokuyoDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CMN_ROKUYO");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CMN_ROKUYO (");
            sql.addSql("   CRK_DATE Date not null,");
            sql.addSql("   CRK_KBN integer not null,");
            sql.addSql("   primary key (CRK_DATE)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CMN_ROKUYO Data Bindding JavaBean
     * @param bean CMN_ROKUYO Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(CmnRokuyoModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CMN_ROKUYO(");
            sql.addSql("   CRK_DATE,");
            sql.addSql("   CRK_KBN");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addDateValue(bean.getCrkDate());
            sql.addIntValue(bean.getCrkKbn());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update CMN_ROKUYO Data Bindding JavaBean
     * @param bean CMN_ROKUYO Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(CmnRokuyoModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CMN_ROKUYO");
            sql.addSql(" set ");
            sql.addSql("   CRK_KBN=?");
            sql.addSql(" where ");
            sql.addSql("   CRK_DATE=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCrkKbn());
            //where
            sql.addDateValue(bean.getCrkDate());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select CMN_ROKUYO All Data
     * @return List in CMN_ROKUYOModel
     * @throws SQLException SQL実行例外
     */
    public List<CmnRokuyoModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<CmnRokuyoModel> ret = new ArrayList<CmnRokuyoModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CRK_DATE,");
            sql.addSql("   CRK_KBN");
            sql.addSql(" from ");
            sql.addSql("   CMN_ROKUYO");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnRokuyoFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CMN_ROKUYO
     * @param crkDate CRK_DATE
     * @return CMN_ROKUYOModel
     * @throws SQLException SQL実行例外
     */
    public CmnRokuyoModel select(UDate crkDate) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        CmnRokuyoModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CRK_DATE,");
            sql.addSql("   CRK_KBN");
            sql.addSql(" from");
            sql.addSql("   CMN_ROKUYO");
            sql.addSql(" where ");
            sql.addSql("   CRK_DATE=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addDateValue(crkDate);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getCmnRokuyoFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p> 指定した期間内の六曜情報を取得する。
     * @param frDate 開始日付
     * @param toDate 終了日付
     * @return 六曜情報リスト
     * @throws SQLException SQL実行例外
     */
    public List<CmnRokuyoModel> select(UDate frDate, UDate toDate) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        List<CmnRokuyoModel> ret = new ArrayList<CmnRokuyoModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CRK_DATE,");
            sql.addSql("   CRK_KBN");
            sql.addSql(" from");
            sql.addSql("   CMN_ROKUYO");
            sql.addSql(" where ");
            sql.addSql("   CRK_DATE >= ?");
            sql.addSql(" and ");
            sql.addSql("   CRK_DATE <= ?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addDateValue(frDate);
            sql.addDateValue(toDate);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getCmnRokuyoFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p> 日付の最小値を取得する
     * @return 最小値と最大値のリスト（[0]:最小値, [1]:最大値）
     * @throws SQLException SQL実行例外
     */
    public List<UDate> getMinMaxDate() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        List<UDate> ret = new ArrayList<UDate>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   MIN(CRK_DATE) as MIN,");
            sql.addSql("   MAX(CRK_DATE) as MAX");
            sql.addSql(" from ");
            sql.addSql("   CMN_ROKUYO");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret.add(UDate.getInstanceTimestamp(rs.getTimestamp("MIN")));
                ret.add(UDate.getInstanceTimestamp(rs.getTimestamp("MAX")));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete CMN_ROKUYO
     * @param crkDate CRK_DATE
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(UDate crkDate) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CMN_ROKUYO");
            sql.addSql(" where ");
            sql.addSql("   CRK_DATE=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addDateValue(crkDate);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create CMN_ROKUYO Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created CmnRokuyoModel
     * @throws SQLException SQL実行例外
     */
    private CmnRokuyoModel __getCmnRokuyoFromRs(ResultSet rs) throws SQLException {
        CmnRokuyoModel bean = new CmnRokuyoModel();
        bean.setCrkDate(UDate.getInstanceTimestamp(rs.getTimestamp("CRK_DATE")));
        bean.setCrkKbn(rs.getInt("CRK_KBN"));
        return bean;
    }
}
