package jp.groupsession.v2.cmn.restapi.transactions.temporaries.directories;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Delete;
import jp.groupsession.v2.restapi.controller.annotation.Post;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;

/**
 * <br>[機  能] 共通 登録時の添付ファイルを一時保管するAPI アクションクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class CmnTransactionsTemporariesDirectoriesAction extends AbstractRestApiAction {
    /**
     *
     * <br>[機  能] 登録時の添付ファイルを一時保管する
     * <br>[解  説]
     * <br>[備  考]
     * @param res レスポンス
     * @param req リクエスト
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPathModel テンポラリディレクトリパスモデル
     */
    @Post
    public void doPost(HttpServletRequest req,
                HttpServletResponse res,
                CmnTransactionsTemporariesDirectoriesParamModel param,
                RestApiContext ctx,
                GSTemporaryPathModel tempPathModel) throws SQLException, Exception {
        //リクエストから添付ファイル情報を取得
        CmnTransactionsTemporariesDirectoriesParamModel fileParam
                = (CmnTransactionsTemporariesDirectoriesParamModel) req.getAttribute(
                    "restApiCmnTempFileForm");
        param.setTmpFile(fileParam.getTmpFile());
        //ファイル情報を取得してから入力チェックを行う。
        param.validatPost(ctx, tempPathModel);
        CmnTransactionsTemporariesDirectoriesPostBiz biz
                = new CmnTransactionsTemporariesDirectoriesPostBiz(tempPathModel);
        //アップロード処理
        biz.saveTempfile(param);
        //レスポンス生成
        RestApiResponseWriter.builder(res, ctx)
            .addResult(biz.getResult())
            .build().execute();
    }

    /**
     * <br>[機  能] 一時保管した添付ファイルを削除する
     * <br>[解  説]
     * <br>[備  考]
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPathModel テンポラリディレクトリパスモデル
     */
    @Delete
    public void doDelete(HttpServletResponse res,
                CmnTransactionsTemporariesDirectoriesParamModel param,
                RestApiContext ctx,
                GSTemporaryPathModel tempPathModel) throws Exception {
        //入力チェック
        param.validateDelete(ctx, tempPathModel);
        CmnTransactionsTemporariesDirectoriesDeleteBiz biz
                = new CmnTransactionsTemporariesDirectoriesDeleteBiz(ctx, tempPathModel);
        //削除処理
        biz.deleteTempfile(param);
        //レスポンス生成
        RestApiResponseWriter.builder(res, ctx)
            .addResult(biz.getResult())
            .build().execute();

    }
}