package jp.groupsession.v2.cmn.restapi.transactions.temporaries.directories;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.codec.binary.Base64;
import org.apache.struts.util.LabelValueBean;

import jp.co.sjts.util.encryption.Blowfish;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.TempFileModel;
import jp.groupsession.v2.cmn.restapi.model.CmnRestapiFileModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;

/**
 * <br>[機  能] 共通 一時保管した添付ファイルを削除するAPI ビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class CmnTransactionsTemporariesDirectoriesDeleteBiz {

    /** コンテキスト */
    private final RestApiContext ctx__;
    /** テンポラリディレクトリパスモデル */
    GSTemporaryPathModel tempPathModel__;
    /** ディレクトリ名*/
    private String dirName__ = null;

    /** 実行結果*/
    private CmnTransactionsTemporariesDirectoriesPostResultModel result__ = null;
    /**
     * @return the result
     */
    public CmnTransactionsTemporariesDirectoriesPostResultModel getResult() {
        return result__;
    }

    /**
     *
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiConst
     * @param tempPathModel テンポラリディレクトリパスモデル
     */
    public CmnTransactionsTemporariesDirectoriesDeleteBiz(
                RestApiContext ctx, GSTemporaryPathModel tempPathModel) {
        ctx__ = ctx;
        tempPathModel__ = tempPathModel;
    }
    /**
     *
     * <br>[機  能] 一時保管した添付ファイルを削除する
     * <br>[解  説]
     * <br>[備  考]
     * @param param
     */
    public void deleteTempfile(
                CmnTransactionsTemporariesDirectoriesParamModel param) throws Exception {
        try {
            GSTemporaryPathUtil temp = GSTemporaryPathUtil.getInstance();
            if (param.getDirectoryCode() == null) {
                //全削除
                temp.deleteTempPath(ctx__.getRequestModel(),
                    "api", "temporary");
            } else {
                String tempDir = decodeTempDir__(param.getDirectoryCode());
                if (param.getFileIndex() == -1) {
                    //ディレクトリ削除
                    temp.deleteTempPath(ctx__.getRequestModel(),
                        "api", "temporary", dirName__);
                } else {
                    CommonBiz cmnBiz = new CommonBiz();
                    List<LabelValueBean> delList = new ArrayList<>();
                    List<LabelValueBean> fileList = cmnBiz.getTempFileLabelList(tempDir);
                    delList.add(fileList.get(param.getFileIndex()));
                    temp.deleteFile(
                            delList.stream()
                                .map(l -> l.getValue())
                                .collect(Collectors.toList())
                                .toArray(new String[delList.size()]),
                                ctx__.getRequestModel(),
                            "api", "temporary", dirName__);

                    CmnTransactionsTemporariesDirectoriesPostResultModel result
                        = new CmnTransactionsTemporariesDirectoriesPostResultModel();
                    List<CmnRestapiFileModel> fileArray = new ArrayList<CmnRestapiFileModel>();
                    if (param.getDirectoryCode() != null && param.getFileIndex() > -1) {
                        //ファイルを指定して削除した際、残っているファイルがあればリザルトとして返す
                        List<TempFileModel> tempFileList = cmnBiz.getTempFiles(tempDir);
                        for (int i = 0; i < tempFileList.size(); i++) {
                            CmnRestapiFileModel fileMdl = new CmnRestapiFileModel();
                            fileMdl.setIndexNum(i);
                            fileMdl.setFileName(tempFileList.get(i).getFileName());
                            fileMdl.setFileSizeByteNum(tempFileList.get(i).getFile().length());
                            fileArray.add(fileMdl);
                        }
                    }
                    result.setFileArray(fileArray);
                    result.setDirectoryCodeText(param.getDirectoryCode());
                    result__ = result;
                }
            }
        } catch (Exception e) {
            throw new RuntimeException("削除に失敗", e);
        }
    }
    /**
     * <br>[機  能] ディレクトリ識別文字列からディレクトリを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param directoryCode ディレクトリ識別文字列
     * @return tempDir
     */
    private String decodeTempDir__(String directoryCode) throws Exception {
        String tempDir = null;
        try {
            byte[] codeByte = Base64.decodeBase64(directoryCode);
            String dirName = Blowfish.decrypt("gsFileDirMake", codeByte);
            dirName__ = dirName;
            tempDir = tempPathModel__.getTempPath() + dirName + "/";
            File useDir = new File(tempDir);
            if (!useDir.exists()) {
                return null;
            }
        } catch (Exception e) {
            throw new Exception("ディレクトリの指定に失敗", e);
        }
        return tempDir;
    }
}
