package jp.groupsession.v2.cmn.restapi.transactions.temporaries.directories;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.codec.binary.Base64;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.LabelValueBean;

import jp.co.sjts.util.EnumUtil.EnumOutRangeException;
import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.encryption.Blowfish;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.struts.AbstractForm;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.dao.base.CmnFileConfDao;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.base.CmnFileConfModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.EnumError;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.msg.RestApiGsMessage;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;

/**
 *
 * <br>[機  能] 共通 登録時の添付ファイルを一時保管するAPI パラメータモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
@ParamModel
public class CmnTransactionsTemporariesDirectoriesParamModel extends AbstractForm {

    /** 添付ファイル */
    private FormFile[] tmpFile__ = null;
    /** ディレクトリ識別文字列 */
    private String directoryCode__ = null;
    /** 添付ファイルインデックス */
    private int fileIndex__ = -1;

    /**
     * @return the tmpFile
     */
    public FormFile[] getTmpFile() {
        return tmpFile__;
    }
    /**
     * @param tmpFile the tmpFile to set
     */
    public void setTmpFile(FormFile[] tmpFile) {
        tmpFile__ = tmpFile;
    }

    /**
     * @return the directoryCode
     */
    public String getDirectoryCode() {
        return directoryCode__;
    }
    /**
     * @param directoryCode the directoryCode to set
     */
    public void setDirectoryCode(String directoryCode) {
        directoryCode__ = directoryCode;
    }

    /**
     * @return the fileIndex
     */
    public int getFileIndex() {
        return fileIndex__;
    }
    /**
     * @param fileIndex the fileIndex to set
     */
    public void setFileIndex(int fileIndex) {
        fileIndex__ = fileIndex;
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説] POST
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     * @param tempPathModel テンポラリディレクトリパスモデル
     * @throws EnumOutRangeException
     * @throws IOToolsException
     */
    public void validatPost(RestApiContext ctx, GSTemporaryPathModel tempPathModel)
            throws SQLException {
        if (directoryCode__ != null) {
            try {
                byte[] codeByte = Base64.decodeBase64(directoryCode__);
                String dirName = Blowfish.decrypt("gsFileDirMake", codeByte);
                String tempDir = tempPathModel.getTempPath() + dirName + "/";
                File useDir = new File(tempDir);
                if (!useDir.exists()) {
                    //指定したディレクトリが存在しない
                    throw new RestApiPermissionException(
                        EnumError.RESOURCE_CANT_ACCESS_DIRECTORY,
                        "error.no.access.data",
                        new RestApiGsMessage()
                            .getMessage("fil.fil080.9")
                    );
                }
            } catch (Exception e) {
                //ディレクトリの指定に失敗
                throw new RestApiPermissionException(
                    EnumError.RESOURCE_CANT_ACCESS_DIRECTORY,
                    "error.no.access.data",
                    new RestApiGsMessage()
                        .getMessage("fil.fil080.9")
                );
            }
        }

        if (tmpFile__ == null) {
            //ファイルが1件も存在しない
            throw new RestApiValidateException(
                    EnumError.PARAM_REQUIRED_FILE,
                    "error.select.required.text",
                    "tmpFile"
            );
        }

        List<String> errorFileNameList = new ArrayList<String>();
        //添付ファイル最大容量取得
        CmnFileConfDao cfcDao = new CmnFileConfDao(ctx.getCon());
        CmnFileConfModel cfcMdl = cfcDao.select();
        int maxSize = cfcMdl.getFicMaxSize();
        int maxSizeMb = maxSize * GSConstCommon.FILE_SIZE_1MB;
        for (FormFile formFile : tmpFile__) {
            if (formFile == null || StringUtil.isNullZeroString(formFile.getFileName())) {
                //アップロードできないファイルが指定されている
                throw new RestApiValidateException(
                        EnumError.PARAM_ERROR_FILE,
                        "error.input.format.file",
                        "tmpFile",
                        new RestApiGsMessage()
                            .getMessage("fil.fil300.4")

                );
            }
            if (maxSizeMb < formFile.getFileSize()) {
                //ファイルサイズ制限を超えたファイル名を格納
                errorFileNameList.add(formFile.getFileName());
            }
        }
        if (errorFileNameList.size() > 0) {
            //ファイルサイズ制限を超えたファイルが存在する
            StringBuffer errorFileStr = new StringBuffer();
            for (String fileName : errorFileNameList) {
                errorFileStr.append("\r\n・" + fileName);
            }
            throw new RestApiValidateException(
                EnumError.PARAM_SIZE_LIMIT_FILE,
                    "restapi.error.file.size.error",
                    "tmpFile",
                    String.valueOf(maxSize),
                    errorFileStr.toString()
            );
        }
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説] DELETE
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     * @param tempPathModel テンポラリディレクトリパスモデル
     * @throws EnumOutRangeException
     * @throws IOToolsException
     */
    public void validateDelete(RestApiContext ctx, GSTemporaryPathModel tempPathModel) {
        if (directoryCode__ != null) {
            String tempDir = "";
            try {
                byte[] codeByte = Base64.decodeBase64(directoryCode__);
                String dirName = Blowfish.decrypt("gsFileDirMake", codeByte);
                tempDir = tempPathModel.getTempPath() + dirName + "/";
                File useDir = new File(tempDir);
                if (!useDir.exists()) {
                    //指定したディレクトリが存在しない
                    throw new RestApiPermissionException(
                        EnumError.RESOURCE_CANT_ACCESS_DIRECTORY,
                        "error.no.access.data",
                        new RestApiGsMessage()
                            .getMessage("fil.fil080.9")
                    );
                }
            } catch (Exception e) {
                //ディレクトリの指定に失敗
                throw new RestApiPermissionException(
                    EnumError.RESOURCE_CANT_ACCESS_DIRECTORY,
                    "error.no.access.data",
                    new RestApiGsMessage()
                        .getMessage("fil.fil080.9")
                );
            }
            if (fileIndex__ > -1) {
                try {
                    CommonBiz cmnBiz = new CommonBiz();
                    List<LabelValueBean> fileList = cmnBiz.getTempFileLabelList(tempDir);
                    if (fileList.size() <= fileIndex__) {
                        //指定したファイルが存在しない
                        throw new RestApiPermissionException(
                            EnumError.RESOURCE_CANT_ACCESS_FILE,
                            "error.no.access.data",
                            new RestApiGsMessage()
                                .getMessage("cmn.file")
                        );
                    }
                } catch (Exception e) {
                    //ファイルの指定に失敗
                    throw new RestApiPermissionException(
                        EnumError.RESOURCE_CANT_ACCESS_FILE,
                        "error.no.access.data",
                        new RestApiGsMessage()
                            .getMessage("cmn.file")
                    );
                }
            }
        }
    }
}
