package jp.groupsession.v2.cmn.restapi.transactions.temporaries.directories;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.codec.binary.Base64;
import org.apache.struts.upload.FormFile;

import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.encryption.Blowfish;
import jp.co.sjts.util.http.TempFileUtil;
import jp.co.sjts.util.io.ObjectFile;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.cmn110.Cmn110Biz;
import jp.groupsession.v2.cmn.cmn110.Cmn110FileModel;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.TempFileModel;
import jp.groupsession.v2.cmn.restapi.model.CmnRestapiFileModel;

/**
 * <br>[機  能] 共通 登録時の添付ファイルを一時保管するAPI ビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class CmnTransactionsTemporariesDirectoriesPostBiz {

    /** テンポラリディレクトリパスモデル */
    GSTemporaryPathModel tempPathModel__;
    /** ディレクトリ識別文字列*/
    private String directoryCode__ = null;
    /** 実行結果*/
    private CmnTransactionsTemporariesDirectoriesPostResultModel result__ = null;
    /**
     * @return the result
     */
    public CmnTransactionsTemporariesDirectoriesPostResultModel getResult() {
        return result__;
    }

    /**
     *
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param tempPathModel テンポラリディレクトリパスモデル
     */
    public CmnTransactionsTemporariesDirectoriesPostBiz(GSTemporaryPathModel tempPathModel) {
        tempPathModel__ = tempPathModel;
    }
    /**
     *
     * <br>[機  能] 登録時の添付ファイルを一時保管する
     * <br>[解  説]
     * <br>[備  考]
     * @param param
     */
    public void saveTempfile(
        CmnTransactionsTemporariesDirectoriesParamModel param) throws Exception {
        String tempDir = null;
        if (param.getDirectoryCode() != null) {
            //ディレクトリ参照
            tempDir = decodeTempDir__(param.getDirectoryCode());
        } else {
            //ディレクトリ新規作成
            tempDir = createTempDir__();
        }
        if (tempDir != null) {
            try {
                for (FormFile formFile : param.getTmpFile()) {
                    if (formFile == null || StringUtil.isNullZeroString(formFile.getFileName())) {
                        continue;
                    }
                    //現在日付の文字列(YYYYMMDD)を取得
                    String dateStr = (new UDate()).getDateString();

                    //ファイルの連番を取得する
                    int fileNum = 1;
                    //TEMPディレクトリ内のファイル数から
                    //連番を取得する
                    fileNum = Cmn110Biz.getFileNumber(tempDir, dateStr);
                    fileNum++;

                    //添付ファイル名
                    String fileName = (new File(formFile.getFileName())).getName();
                    //添付ファイル(本体)のパスを取得
                    File saveFilePath = Cmn110Biz.getSaveFilePath(tempDir, dateStr, fileNum);

                    //添付ファイルアップロード
                    TempFileUtil.upload(formFile, tempDir, saveFilePath.getName());

                    //オブジェクトファイルを設定
                    File objFilePath = Cmn110Biz.getObjFilePath(tempDir, dateStr, fileNum);
                    Cmn110FileModel fileMdl = new Cmn110FileModel();
                    fileMdl.setFileName(fileName);
                    fileMdl.setSaveFileName(saveFilePath.getName());
                    fileMdl.setUpdateKbn(0);
                    ObjectFile objFile
                        = new ObjectFile(objFilePath.getParent(), objFilePath.getName());
                    objFile.save(fileMdl);
                }
            } catch (Exception e) {
                throw new RuntimeException("ファイル保管に失敗", e);
            }
        }

        //リザルト作成
        CmnTransactionsTemporariesDirectoriesPostResultModel result
            = new CmnTransactionsTemporariesDirectoriesPostResultModel();
        //ディレクトリ識別文字列
        result.setDirectoryCodeText(directoryCode__);
        //ファイル情報
        List<CmnRestapiFileModel> fileArray = new ArrayList<CmnRestapiFileModel>();
        CommonBiz cmnBiz = new CommonBiz();
        List<TempFileModel> tempFileList = cmnBiz.getTempFiles(tempDir);
        for (int i = 0; i < tempFileList.size(); i++) {
            CmnRestapiFileModel fileMdl = new CmnRestapiFileModel();
            fileMdl.setIndexNum(i);
            fileMdl.setFileName(tempFileList.get(i).getFileName());
            fileMdl.setFileSizeByteNum(tempFileList.get(i).getFile().length());
            fileArray.add(fileMdl);
        }
        result.setFileArray(fileArray);
        result__ = result;
    }
    /**
     * <br>[機  能] ディレクトリ識別文字列からディレクトリを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param directoryCode ディレクトリ識別文字列
     * @return tempDir
     */
    private String decodeTempDir__(String directoryCode) throws Exception {
        String tempDir = null;
        try {
            byte[] codeByte = Base64.decodeBase64(directoryCode);
            String dirName = Blowfish.decrypt("gsFileDirMake", codeByte);
            tempDir = tempPathModel__.getTempPath() + dirName + "/";
            File useDir = new File(tempDir);
            if (!useDir.exists()) {
                return null;
            }
        } catch (Exception e) {
            throw new Exception("ディレクトリの指定に失敗", e);
        }
        directoryCode__ = directoryCode;
        return tempDir;
    }
    /**
     * <br>[機  能] ディレクトリを生成する
     * <br>[解  説] 重複した場合は再実行する
     * <br>[備  考]
     * @return tempDir
     */
    private String createTempDir__() throws Exception {
        UDate now = new UDate();
        String dirName = now.getTimeStamp() + now.getStrMilliSecond();
        String tempDir = tempPathModel__.getTempPath() + dirName + "/";

        File makeDir = new File(tempDir);
        try {
            if (!makeDir.exists()) {
                makeDir.mkdirs();
                byte[] enStr = Blowfish.encrypt("gsFileDirMake", dirName);
                directoryCode__ = new String(Base64.encodeBase64URLSafeString(enStr));
                return tempDir;
            }
            Thread.sleep(10);
        } catch (Exception e) {
            throw new Exception("ディレクトリの作成に失敗", e);
        }
        return createTempDir__();
    }
}
