package jp.groupsession.v2.convert.convert490.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;

/**
 *
 * <br>[機  能] 既存のWEBメールの管理者設定がない場合に初期データ登録
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class WmlAconfInitDataDao {
    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(WmlAconfInitDataDao.class);

    /**
     *
     * <br>[機  能] コンバート処理
     * <br>[解  説] テンプレート参照が不正な稟議が登録可能の間に作成された不正な稟議を削除
     * <br>[備  考]
     * @param con コネクション
     * @throws SQLException SQL実行時例外
     */
    public void convert(Connection con) throws SQLException {
        /*--------------No741 TLD制限対応----*/
        int count = __selectCount(con);
        if (count > 0) {
            log__.info("WEBメール 管理者設定あり: 追加フィールドの更新のみ");
            __update(con);
        } else {
            log__.info("WEBメール 管理者設定なし: データ新規作成");
            __insert(con);
        }
        /*-------------------------------*/
    }

    /**
     * <p>Insert WML_ADM_CONF Data Bindding JavaBean
     * @param con コネクション
     * @throws SQLException SQL実行例外
     */
    private void __insert(Connection con) throws SQLException {

        PreparedStatement pstmt = null;

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" WML_ADM_CONF(");
            sql.addSql("   WAD_ACNT_MAKE,");
            sql.addSql("   WAD_ACCT_SENDFORMAT,");
            sql.addSql("   WAD_ACCT_LOG_REGIST,");
            sql.addSql("   WAD_PERMIT_KBN,");
            sql.addSql("   WAD_AUTO_RECEIVE_TIME,");
            sql.addSql("   WAD_DISK,");
            sql.addSql("   WAD_DISK_SIZE,");
            sql.addSql("   WAD_DISK_COMP,");
            sql.addSql("   WAD_DELRECEIVE,");
            sql.addSql("   WAD_AUTORECEIVE,");
            sql.addSql("   WAD_SEND_HOST,");
            sql.addSql("   WAD_SEND_PORT,");
            sql.addSql("   WAD_SEND_SSL,");
            sql.addSql("   WAD_RECEIVE_HOST,");
            sql.addSql("   WAD_RECEIVE_PORT,");
            sql.addSql("   WAD_RECEIVE_SSL,");
            sql.addSql("   WAD_CHECK_ADDRESS,");
            sql.addSql("   WAD_CHECK_FILE,");
            sql.addSql("   WAD_COMPRESS_FILE,");
            sql.addSql("   WAD_TIMESENT,");
            sql.addSql("   WAD_SEND_LIMIT,");
            sql.addSql("   WAD_SEND_LIMIT_SIZE,");
            sql.addSql("   WAD_FWLIMIT,");
            sql.addSql("   WAD_BCC,");
            sql.addSql("   WAD_BCC_TH,");
            sql.addSql("   WAD_WARN_DISK,");
            sql.addSql("   WAD_WARN_DISK_TH,");
            sql.addSql("   WAD_SETTING_SERVER,");
            sql.addSql("   WAD_PROXY_USER,");
            sql.addSql("   WAD_COMPRESS_FILE_DEF,");
            sql.addSql("   WAD_TIMESENT_DEF,");
            sql.addSql("   WAD_LINK_LIMIT,");
            sql.addSql("   WAD_TLD_LIMIT,");
            sql.addSql("   WAD_TLD_LIMIT_TEXT");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   0,"); // WAD_ACNT_MAKE
            sql.addSql("   0,"); // WAD_ACCT_SENDFORMAT
            sql.addSql("   0,"); // WAD_ACCT_LOG_REGIST
            sql.addSql("   0,"); // WAD_PERMIT_KBN
            sql.addSql("   5,"); // WAD_AUTO_RECEIVE_TIME
            sql.addSql("   0,"); // WAD_DISK
            sql.addSql("   0,"); // WAD_DISK_SIZE
            sql.addSql("   0,"); // WAD_DISK_COMP
            sql.addSql("   0,"); // WAD_DELRECEIVE
            sql.addSql("   0,"); // WAD_AUTORECEIVE
            sql.addSql("   NULL,"); // WAD_SEND_HOST
            sql.addSql("   0,"); // WAD_SEND_PORT
            sql.addSql("   0,"); // WAD_SEND_SSL
            sql.addSql("   NULL,"); // WAD_RECEIVE_HOST
            sql.addSql("   0,"); // WAD_RECEIVE_PORT
            sql.addSql("   0,"); // WAD_RECEIVE_SSL
            sql.addSql("   0,"); // WAD_CHECK_ADDRESS
            sql.addSql("   0,"); // WAD_CHECK_FILE
            sql.addSql("   0,"); // WAD_COMPRESS_FILE
            sql.addSql("   0,"); // WAD_TIMESENT
            sql.addSql("   0,"); // WAD_SEND_LIMIT
            sql.addSql("   0,"); // WAD_SEND_LIMIT_SIZE
            sql.addSql("   0,"); // WAD_FWLIMIT
            sql.addSql("   0,"); // WAD_BCC
            sql.addSql("   0,"); // WAD_BCC_TH
            sql.addSql("   0,"); // WAD_WARN_DISK
            sql.addSql("   0,"); // WAD_WARN_DISK_TH
            sql.addSql("   0,"); // WAD_SETTING_SERVER
            sql.addSql("   0,"); // WAD_PROXY_USER
            sql.addSql("   0,"); // WAD_COMPRESS_FILE_DEF
            sql.addSql("   0,"); // WAD_TIMESENT_DEF
            sql.addSql("   0,"); // WAD_LINK_LIMIT
            sql.addSql("   0,"); // WAD_TLD_LIMIT
            sql.addSql("   '" + __getTldList() + "'"); // WAD_TLD_LIMIT_TEXT
            sql.addSql(" )");


            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update WML_ADM_CONF Data Bindding JavaBean
     * @param con コネクション
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    private int __update(Connection con) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            // TLD許可リスト
            sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   WML_ADM_CONF ");
            sql.addSql(" set");
            sql.addSql("   WAD_TLD_LIMIT = 0,");
            sql.addSql("   WAD_TLD_LIMIT_TEXT = '" + __getTldList() + "'");

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <br>[機  能] レコード件数を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param con コネクション
     * @return 件数
     * @throws SQLException SQL実行例外
     */
    private int __selectCount(Connection con) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int count = 0;

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   count(*) as CNT");
            sql.addSql(" from ");
            sql.addSql("   WML_ADM_CONF");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt("CNT");
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }


    /**
     * <br>[機  能] TLD許可リストを取得する
     * <br>[解  説]
     * <br>[備  考] db_init の WML_ADM_CONF - WAD_TLD_LIMIT_TEXT と同じ値
     * @return 許可リスト
     */
    private String __getTldList() {
        return "aaa\r\n"
             + "aarp\r\n"
             + "abb\r\n"
             + "abbott\r\n"
             + "abogado\r\n"
             + "ac\r\n"
             + "academy\r\n"
             + "accenture\r\n"
             + "accountant\r\n"
             + "accountants\r\n"
             + "aco\r\n"
             + "active\r\n"
             + "actor\r\n"
             + "ad\r\n"
             + "ads\r\n"
             + "adult\r\n"
             + "ae\r\n"
             + "aeg\r\n"
             + "aero\r\n"
             + "af\r\n"
             + "afl\r\n"
             + "ag\r\n"
             + "agency\r\n"
             + "ai\r\n"
             + "aig\r\n"
             + "airforce\r\n"
             + "airtel\r\n"
             + "al\r\n"
             + "alibaba\r\n"
             + "alipay\r\n"
             + "allfinanz\r\n"
             + "alsace\r\n"
             + "am\r\n"
             + "amica\r\n"
             + "amsterdam\r\n"
             + "analytics\r\n"
             + "android\r\n"
             + "ao\r\n"
             + "apartments\r\n"
             + "app\r\n"
             + "apple\r\n"
             + "aq\r\n"
             + "aquarelle\r\n"
             + "ar\r\n"
             + "aramco\r\n"
             + "archi\r\n"
             + "army\r\n"
             + "arpa\r\n"
             + "arte\r\n"
             + "as\r\n"
             + "asia\r\n"
             + "associates\r\n"
             + "at\r\n"
             + "attorney\r\n"
             + "au\r\n"
             + "auction\r\n"
             + "audi\r\n"
             + "audio\r\n"
             + "author\r\n"
             + "auto\r\n"
             + "autos\r\n"
             + "aw\r\n"
             + "ax\r\n"
             + "axa\r\n"
             + "az\r\n"
             + "azure\r\n"
             + "ba\r\n"
             + "baidu\r\n"
             + "band\r\n"
             + "bank\r\n"
             + "bar\r\n"
             + "barcelona\r\n"
             + "barclaycard\r\n"
             + "barclays\r\n"
             + "bargains\r\n"
             + "bauhaus\r\n"
             + "bayern\r\n"
             + "bb\r\n"
             + "bbc\r\n"
             + "bbva\r\n"
             + "bcn\r\n"
             + "bd\r\n"
             + "be\r\n"
             + "beats\r\n"
             + "beer\r\n"
             + "bentley\r\n"
             + "berlin\r\n"
             + "best\r\n"
             + "bet\r\n"
             + "bf\r\n"
             + "bg\r\n"
             + "bh\r\n"
             + "bharti\r\n"
             + "bi\r\n"
             + "bible\r\n"
             + "bid\r\n"
             + "bike\r\n"
             + "bing\r\n"
             + "bingo\r\n"
             + "bio\r\n"
             + "biz\r\n"
             + "bj\r\n"
             + "black\r\n"
             + "blackfriday\r\n"
             + "bloomberg\r\n"
             + "blue\r\n"
             + "bm\r\n"
             + "bms\r\n"
             + "bmw\r\n"
             + "bn\r\n"
             + "bnl\r\n"
             + "bnpparibas\r\n"
             + "bo\r\n"
             + "boats\r\n"
             + "boehringer\r\n"
             + "bom\r\n"
             + "bond\r\n"
             + "boo\r\n"
             + "book\r\n"
             + "boots\r\n"
             + "bosch\r\n"
             + "bostik\r\n"
             + "bot\r\n"
             + "boutique\r\n"
             + "br\r\n"
             + "bradesco\r\n"
             + "bridgestone\r\n"
             + "broadway\r\n"
             + "broker\r\n"
             + "brother\r\n"
             + "brussels\r\n"
             + "bs\r\n"
             + "bt\r\n"
             + "budapest\r\n"
             + "bugatti\r\n"
             + "build\r\n"
             + "builders\r\n"
             + "business\r\n"
             + "buy\r\n"
             + "buzz\r\n"
             + "bv\r\n"
             + "bw\r\n"
             + "by\r\n"
             + "bz\r\n"
             + "bzh\r\n"
             + "ca\r\n"
             + "cab\r\n"
             + "cafe\r\n"
             + "cal\r\n"
             + "call\r\n"
             + "camera\r\n"
             + "camp\r\n"
             + "cancerresearch\r\n"
             + "canon\r\n"
             + "capetown\r\n"
             + "capital\r\n"
             + "car\r\n"
             + "caravan\r\n"
             + "cards\r\n"
             + "care\r\n"
             + "career\r\n"
             + "careers\r\n"
             + "cars\r\n"
             + "cartier\r\n"
             + "casa\r\n"
             + "cash\r\n"
             + "casino\r\n"
             + "cat\r\n"
             + "catering\r\n"
             + "cba\r\n"
             + "cbn\r\n"
             + "cc\r\n"
             + "cd\r\n"
             + "ceb\r\n"
             + "center\r\n"
             + "ceo\r\n"
             + "cern\r\n"
             + "cf\r\n"
             + "cfa\r\n"
             + "cfd\r\n"
             + "cg\r\n"
             + "ch\r\n"
             + "chanel\r\n"
             + "channel\r\n"
             + "chat\r\n"
             + "cheap\r\n"
             + "chloe\r\n"
             + "christmas\r\n"
             + "chrome\r\n"
             + "church\r\n"
             + "ci\r\n"
             + "cipriani\r\n"
             + "circle\r\n"
             + "cisco\r\n"
             + "citic\r\n"
             + "city\r\n"
             + "cityeats\r\n"
             + "ck\r\n"
             + "cl\r\n"
             + "claims\r\n"
             + "cleaning\r\n"
             + "click\r\n"
             + "clinic\r\n"
             + "clinique\r\n"
             + "clothing\r\n"
             + "cloud\r\n"
             + "club\r\n"
             + "clubmed\r\n"
             + "cm\r\n"
             + "cn\r\n"
             + "co\r\n"
             + "coach\r\n"
             + "codes\r\n"
             + "coffee\r\n"
             + "college\r\n"
             + "cologne\r\n"
             + "com\r\n"
             + "commbank\r\n"
             + "community\r\n"
             + "company\r\n"
             + "compare\r\n"
             + "computer\r\n"
             + "comsec\r\n"
             + "condos\r\n"
             + "construction\r\n"
             + "consulting\r\n"
             + "contact\r\n"
             + "contractors\r\n"
             + "cooking\r\n"
             + "cool\r\n"
             + "coop\r\n"
             + "corsica\r\n"
             + "country\r\n"
             + "coupons\r\n"
             + "courses\r\n"
             + "cr\r\n"
             + "credit\r\n"
             + "creditcard\r\n"
             + "creditunion\r\n"
             + "cricket\r\n"
             + "crown\r\n"
             + "crs\r\n"
             + "cruises\r\n"
             + "csc\r\n"
             + "cu\r\n"
             + "cuisinella\r\n"
             + "cv\r\n"
             + "cw\r\n"
             + "cx\r\n"
             + "cy\r\n"
             + "cymru\r\n"
             + "cyou\r\n"
             + "cz\r\n"
             + "dabur\r\n"
             + "dad\r\n"
             + "dance\r\n"
             + "date\r\n"
             + "dating\r\n"
             + "datsun\r\n"
             + "day\r\n"
             + "dclk\r\n"
             + "de\r\n"
             + "dealer\r\n"
             + "deals\r\n"
             + "degree\r\n"
             + "delivery\r\n"
             + "dell\r\n"
             + "delta\r\n"
             + "democrat\r\n"
             + "dental\r\n"
             + "dentist\r\n"
             + "desi\r\n"
             + "design\r\n"
             + "dev\r\n"
             + "diamonds\r\n"
             + "diet\r\n"
             + "digital\r\n"
             + "direct\r\n"
             + "directory\r\n"
             + "discount\r\n"
             + "dj\r\n"
             + "dk\r\n"
             + "dm\r\n"
             + "dnp\r\n"
             + "do\r\n"
             + "docs\r\n"
             + "dog\r\n"
             + "doha\r\n"
             + "domains\r\n"
             + "doosan\r\n"
             + "download\r\n"
             + "drive\r\n"
             + "dubai\r\n"
             + "durban\r\n"
             + "dvag\r\n"
             + "dz\r\n"
             + "earth\r\n"
             + "eat\r\n"
             + "ec\r\n"
             + "edu\r\n"
             + "education\r\n"
             + "ee\r\n"
             + "eg\r\n"
             + "email\r\n"
             + "emerck\r\n"
             + "energy\r\n"
             + "engineer\r\n"
             + "engineering\r\n"
             + "enterprises\r\n"
             + "epson\r\n"
             + "equipment\r\n"
             + "er\r\n"
             + "erni\r\n"
             + "es\r\n"
             + "esq\r\n"
             + "estate\r\n"
             + "et\r\n"
             + "eu\r\n"
             + "eurovision\r\n"
             + "eus\r\n"
             + "events\r\n"
             + "everbank\r\n"
             + "exchange\r\n"
             + "expert\r\n"
             + "exposed\r\n"
             + "express\r\n"
             + "fage\r\n"
             + "fail\r\n"
             + "fairwinds\r\n"
             + "faith\r\n"
             + "family\r\n"
             + "fan\r\n"
             + "fans\r\n"
             + "farm\r\n"
             + "fashion\r\n"
             + "fast\r\n"
             + "feedback\r\n"
             + "ferrero\r\n"
             + "fi\r\n"
             + "film\r\n"
             + "final\r\n"
             + "finance\r\n"
             + "financial\r\n"
             + "firestone\r\n"
             + "firmdale\r\n"
             + "fish\r\n"
             + "fishing\r\n"
             + "fit\r\n"
             + "fitness\r\n"
             + "fj\r\n"
             + "fk\r\n"
             + "flights\r\n"
             + "florist\r\n"
             + "flowers\r\n"
             + "flsmidth\r\n"
             + "fly\r\n"
             + "fm\r\n"
             + "fo\r\n"
             + "foo\r\n"
             + "football\r\n"
             + "ford\r\n"
             + "forex\r\n"
             + "forsale\r\n"
             + "forum\r\n"
             + "foundation\r\n"
             + "fox\r\n"
             + "fr\r\n"
             + "fresenius\r\n"
             + "frl\r\n"
             + "frogans\r\n"
             + "fund\r\n"
             + "furniture\r\n"
             + "futbol\r\n"
             + "fyi\r\n"
             + "ga\r\n"
             + "gal\r\n"
             + "gallery\r\n"
             + "game\r\n"
             + "garden\r\n"
             + "gb\r\n"
             + "gbiz\r\n"
             + "gd\r\n"
             + "gdn\r\n"
             + "ge\r\n"
             + "gea\r\n"
             + "gent\r\n"
             + "genting\r\n"
             + "gf\r\n"
             + "gg\r\n"
             + "ggee\r\n"
             + "gh\r\n"
             + "gi\r\n"
             + "gift\r\n"
             + "gifts\r\n"
             + "gives\r\n"
             + "giving\r\n"
             + "gl\r\n"
             + "glass\r\n"
             + "gle\r\n"
             + "global\r\n"
             + "globo\r\n"
             + "gm\r\n"
             + "gmail\r\n"
             + "gmo\r\n"
             + "gmx\r\n"
             + "gn\r\n"
             + "gold\r\n"
             + "goldpoint\r\n"
             + "golf\r\n"
             + "goo\r\n"
             + "goog\r\n"
             + "google\r\n"
             + "gop\r\n"
             + "got\r\n"
             + "gov\r\n"
             + "gp\r\n"
             + "gq\r\n"
             + "gr\r\n"
             + "grainger\r\n"
             + "graphics\r\n"
             + "gratis\r\n"
             + "green\r\n"
             + "gripe\r\n"
             + "group\r\n"
             + "gs\r\n"
             + "gt\r\n"
             + "gu\r\n"
             + "gucci\r\n"
             + "guge\r\n"
             + "guide\r\n"
             + "guitars\r\n"
             + "guru\r\n"
             + "gw\r\n"
             + "gy\r\n"
             + "hamburg\r\n"
             + "hangout\r\n"
             + "haus\r\n"
             + "healthcare\r\n"
             + "help\r\n"
             + "here\r\n"
             + "hermes\r\n"
             + "hiphop\r\n"
             + "hitachi\r\n"
             + "hiv\r\n"
             + "hk\r\n"
             + "hm\r\n"
             + "hn\r\n"
             + "hockey\r\n"
             + "holdings\r\n"
             + "holiday\r\n"
             + "homedepot\r\n"
             + "homes\r\n"
             + "honda\r\n"
             + "horse\r\n"
             + "host\r\n"
             + "hosting\r\n"
             + "hoteles\r\n"
             + "hotmail\r\n"
             + "house\r\n"
             + "how\r\n"
             + "hr\r\n"
             + "hsbc\r\n"
             + "ht\r\n"
             + "hu\r\n"
             + "hyundai\r\n"
             + "ibm\r\n"
             + "icbc\r\n"
             + "ice\r\n"
             + "icu\r\n"
             + "id\r\n"
             + "ie\r\n"
             + "ifm\r\n"
             + "iinet\r\n"
             + "il\r\n"
             + "im\r\n"
             + "immo\r\n"
             + "immobilien\r\n"
             + "in\r\n"
             + "industries\r\n"
             + "infiniti\r\n"
             + "info\r\n"
             + "ing\r\n"
             + "ink\r\n"
             + "institute\r\n"
             + "insurance\r\n"
             + "insure\r\n"
             + "int\r\n"
             + "international\r\n"
             + "investments\r\n"
             + "io\r\n"
             + "ipiranga\r\n"
             + "iq\r\n"
             + "ir\r\n"
             + "irish\r\n"
             + "is\r\n"
             + "iselect\r\n"
             + "ist\r\n"
             + "istanbul\r\n"
             + "it\r\n"
             + "itau\r\n"
             + "iwc\r\n"
             + "jaguar\r\n"
             + "java\r\n"
             + "jcb\r\n"
             + "je\r\n"
             + "jetzt\r\n"
             + "jewelry\r\n"
             + "jlc\r\n"
             + "jll\r\n"
             + "jm\r\n"
             + "jmp\r\n"
             + "jo\r\n"
             + "jobs\r\n"
             + "joburg\r\n"
             + "jot\r\n"
             + "joy\r\n"
             + "jp\r\n"
             + "jprs\r\n"
             + "juegos\r\n"
             + "kaufen\r\n"
             + "kddi\r\n"
             + "ke\r\n"
             + "kfh\r\n"
             + "kg\r\n"
             + "kh\r\n"
             + "ki\r\n"
             + "kia\r\n"
             + "kim\r\n"
             + "kinder\r\n"
             + "kitchen\r\n"
             + "kiwi\r\n"
             + "km\r\n"
             + "kn\r\n"
             + "koeln\r\n"
             + "komatsu\r\n"
             + "kp\r\n"
             + "kpn\r\n"
             + "kr\r\n"
             + "krd\r\n"
             + "kred\r\n"
             + "kw\r\n"
             + "ky\r\n"
             + "kyoto\r\n"
             + "kz\r\n"
             + "la\r\n"
             + "lacaixa\r\n"
             + "lamborghini\r\n"
             + "lamer\r\n"
             + "lancaster\r\n"
             + "land\r\n"
             + "landrover\r\n"
             + "lasalle\r\n"
             + "lat\r\n"
             + "latrobe\r\n"
             + "law\r\n"
             + "lawyer\r\n"
             + "lb\r\n"
             + "lc\r\n"
             + "lds\r\n"
             + "lease\r\n"
             + "leclerc\r\n"
             + "legal\r\n"
             + "lexus\r\n"
             + "lgbt\r\n"
             + "li\r\n"
             + "liaison\r\n"
             + "lidl\r\n"
             + "life\r\n"
             + "lifestyle\r\n"
             + "lighting\r\n"
             + "like\r\n"
             + "limited\r\n"
             + "limo\r\n"
             + "lincoln\r\n"
             + "linde\r\n"
             + "link\r\n"
             + "live\r\n"
             + "living\r\n"
             + "lixil\r\n"
             + "lk\r\n"
             + "loan\r\n"
             + "loans\r\n"
             + "lol\r\n"
             + "london\r\n"
             + "lotte\r\n"
             + "lotto\r\n"
             + "love\r\n"
             + "lr\r\n"
             + "ls\r\n"
             + "lt\r\n"
             + "ltd\r\n"
             + "ltda\r\n"
             + "lu\r\n"
             + "lupin\r\n"
             + "luxe\r\n"
             + "luxury\r\n"
             + "lv\r\n"
             + "ly\r\n"
             + "ma\r\n"
             + "madrid\r\n"
             + "maif\r\n"
             + "maison\r\n"
             + "makeup\r\n"
             + "man\r\n"
             + "management\r\n"
             + "mango\r\n"
             + "market\r\n"
             + "marketing\r\n"
             + "markets\r\n"
             + "marriott\r\n"
             + "mba\r\n"
             + "mc\r\n"
             + "md\r\n"
             + "me\r\n"
             + "med\r\n"
             + "media\r\n"
             + "meet\r\n"
             + "melbourne\r\n"
             + "meme\r\n"
             + "memorial\r\n"
             + "men\r\n"
             + "menu\r\n"
             + "meo\r\n"
             + "mg\r\n"
             + "mh\r\n"
             + "miami\r\n"
             + "microsoft\r\n"
             + "mil\r\n"
             + "mini\r\n"
             + "mk\r\n"
             + "ml\r\n"
             + "mm\r\n"
             + "mma\r\n"
             + "mn\r\n"
             + "mo\r\n"
             + "mobi\r\n"
             + "mobily\r\n"
             + "moda\r\n"
             + "moe\r\n"
             + "moi\r\n"
             + "mom\r\n"
             + "monash\r\n"
             + "money\r\n"
             + "montblanc\r\n"
             + "mormon\r\n"
             + "mortgage\r\n"
             + "moscow\r\n"
             + "motorcycles\r\n"
             + "mov\r\n"
             + "movie\r\n"
             + "movistar\r\n"
             + "mp\r\n"
             + "mq\r\n"
             + "mr\r\n"
             + "ms\r\n"
             + "mt\r\n"
             + "mtn\r\n"
             + "mtpc\r\n"
             + "mtr\r\n"
             + "mu\r\n"
             + "museum\r\n"
             + "mutuelle\r\n"
             + "mv\r\n"
             + "mw\r\n"
             + "mx\r\n"
             + "my\r\n"
             + "mz\r\n"
             + "na\r\n"
             + "nadex\r\n"
             + "nagoya\r\n"
             + "name\r\n"
             + "navy\r\n"
             + "nc\r\n"
             + "ne\r\n"
             + "nec\r\n"
             + "net\r\n"
             + "netbank\r\n"
             + "network\r\n"
             + "neustar\r\n"
             + "new\r\n"
             + "news\r\n"
             + "nexus\r\n"
             + "nf\r\n"
             + "ng\r\n"
             + "ngo\r\n"
             + "nhk\r\n"
             + "ni\r\n"
             + "nico\r\n"
             + "ninja\r\n"
             + "nissan\r\n"
             + "nl\r\n"
             + "no\r\n"
             + "nokia\r\n"
             + "norton\r\n"
             + "nowruz\r\n"
             + "np\r\n"
             + "nr\r\n"
             + "nra\r\n"
             + "nrw\r\n"
             + "ntt\r\n"
             + "nu\r\n"
             + "nyc\r\n"
             + "nz\r\n"
             + "obi\r\n"
             + "office\r\n"
             + "okinawa\r\n"
             + "om\r\n"
             + "omega\r\n"
             + "one\r\n"
             + "ong\r\n"
             + "onl\r\n"
             + "online\r\n"
             + "ooo\r\n"
             + "oracle\r\n"
             + "orange\r\n"
             + "org\r\n"
             + "organic\r\n"
             + "origins\r\n"
             + "osaka\r\n"
             + "otsuka\r\n"
             + "ovh\r\n"
             + "pa\r\n"
             + "page\r\n"
             + "panerai\r\n"
             + "paris\r\n"
             + "pars\r\n"
             + "partners\r\n"
             + "parts\r\n"
             + "party\r\n"
             + "pe\r\n"
             + "pet\r\n"
             + "pf\r\n"
             + "pg\r\n"
             + "ph\r\n"
             + "pharmacy\r\n"
             + "philips\r\n"
             + "photo\r\n"
             + "photography\r\n"
             + "photos\r\n"
             + "physio\r\n"
             + "piaget\r\n"
             + "pics\r\n"
             + "pictet\r\n"
             + "pictures\r\n"
             + "pid\r\n"
             + "pin\r\n"
             + "ping\r\n"
             + "pink\r\n"
             + "pizza\r\n"
             + "pk\r\n"
             + "pl\r\n"
             + "place\r\n"
             + "play\r\n"
             + "playstation\r\n"
             + "plumbing\r\n"
             + "plus\r\n"
             + "pm\r\n"
             + "pn\r\n"
             + "pohl\r\n"
             + "poker\r\n"
             + "porn\r\n"
             + "post\r\n"
             + "pr\r\n"
             + "praxi\r\n"
             + "press\r\n"
             + "pro\r\n"
             + "prod\r\n"
             + "productions\r\n"
             + "prof\r\n"
             + "promo\r\n"
             + "properties\r\n"
             + "property\r\n"
             + "protection\r\n"
             + "ps\r\n"
             + "pt\r\n"
             + "pub\r\n"
             + "pw\r\n"
             + "py\r\n"
             + "qa\r\n"
             + "qpon\r\n"
             + "quebec\r\n"
             + "racing\r\n"
             + "re\r\n"
             + "read\r\n"
             + "realtor\r\n"
             + "realty\r\n"
             + "recipes\r\n"
             + "red\r\n"
             + "redstone\r\n"
             + "redumbrella\r\n"
             + "rehab\r\n"
             + "reise\r\n"
             + "reisen\r\n"
             + "reit\r\n"
             + "ren\r\n"
             + "rent\r\n"
             + "rentals\r\n"
             + "repair\r\n"
             + "report\r\n"
             + "republican\r\n"
             + "rest\r\n"
             + "restaurant\r\n"
             + "review\r\n"
             + "reviews\r\n"
             + "rexroth\r\n"
             + "rich\r\n"
             + "ricoh\r\n"
             + "rio\r\n"
             + "rip\r\n"
             + "ro\r\n"
             + "rocher\r\n"
             + "rocks\r\n"
             + "rodeo\r\n"
             + "room\r\n"
             + "rs\r\n"
             + "rsvp\r\n"
             + "ru\r\n"
             + "ruhr\r\n"
             + "run\r\n"
             + "rw\r\n"
             + "rwe\r\n"
             + "ryukyu\r\n"
             + "sa\r\n"
             + "saarland\r\n"
             + "safe\r\n"
             + "safety\r\n"
             + "sakura\r\n"
             + "sale\r\n"
             + "salon\r\n"
             + "samsung\r\n"
             + "sandvik\r\n"
             + "sandvikcoromant\r\n"
             + "sanofi\r\n"
             + "sap\r\n"
             + "sapo\r\n"
             + "sarl\r\n"
             + "sas\r\n"
             + "saxo\r\n"
             + "sb\r\n"
             + "sbs\r\n"
             + "sc\r\n"
             + "sca\r\n"
             + "scb\r\n"
             + "schaeffler\r\n"
             + "schmidt\r\n"
             + "scholarships\r\n"
             + "school\r\n"
             + "schule\r\n"
             + "schwarz\r\n"
             + "science\r\n"
             + "scor\r\n"
             + "scot\r\n"
             + "sd\r\n"
             + "se\r\n"
             + "seat\r\n"
             + "security\r\n"
             + "seek\r\n"
             + "select\r\n"
             + "sener\r\n"
             + "services\r\n"
             + "seven\r\n"
             + "sew\r\n"
             + "sex\r\n"
             + "sexy\r\n"
             + "sfr\r\n"
             + "sg\r\n"
             + "sh\r\n"
             + "sharp\r\n"
             + "shell\r\n"
             + "shia\r\n"
             + "shiksha\r\n"
             + "shoes\r\n"
             + "show\r\n"
             + "shriram\r\n"
             + "si\r\n"
             + "singles\r\n"
             + "site\r\n"
             + "sj\r\n"
             + "sk\r\n"
             + "ski\r\n"
             + "skin\r\n"
             + "sky\r\n"
             + "skype\r\n"
             + "sl\r\n"
             + "sm\r\n"
             + "smile\r\n"
             + "sn\r\n"
             + "sncf\r\n"
             + "so\r\n"
             + "soccer\r\n"
             + "social\r\n"
             + "softbank\r\n"
             + "software\r\n"
             + "sohu\r\n"
             + "solar\r\n"
             + "solutions\r\n"
             + "sony\r\n"
             + "soy\r\n"
             + "space\r\n"
             + "spiegel\r\n"
             + "spreadbetting\r\n"
             + "sr\r\n"
             + "srl\r\n"
             + "st\r\n"
             + "stada\r\n"
             + "star\r\n"
             + "starhub\r\n"
             + "statefarm\r\n"
             + "statoil\r\n"
             + "stc\r\n"
             + "stcgroup\r\n"
             + "stockholm\r\n"
             + "storage\r\n"
             + "studio\r\n"
             + "study\r\n"
             + "style\r\n"
             + "su\r\n"
             + "sucks\r\n"
             + "supplies\r\n"
             + "supply\r\n"
             + "support\r\n"
             + "surf\r\n"
             + "surgery\r\n"
             + "suzuki\r\n"
             + "sv\r\n"
             + "swatch\r\n"
             + "swiss\r\n"
             + "sx\r\n"
             + "sy\r\n"
             + "sydney\r\n"
             + "symantec\r\n"
             + "systems\r\n"
             + "sz\r\n"
             + "tab\r\n"
             + "taipei\r\n"
             + "tatamotors\r\n"
             + "tatar\r\n"
             + "tattoo\r\n"
             + "tax\r\n"
             + "taxi\r\n"
             + "tc\r\n"
             + "tci\r\n"
             + "td\r\n"
             + "team\r\n"
             + "tech\r\n"
             + "technology\r\n"
             + "tel\r\n"
             + "telefonica\r\n"
             + "temasek\r\n"
             + "tennis\r\n"
             + "tf\r\n"
             + "tg\r\n"
             + "th\r\n"
             + "thd\r\n"
             + "theater\r\n"
             + "theatre\r\n"
             + "tickets\r\n"
             + "tienda\r\n"
             + "tips\r\n"
             + "tires\r\n"
             + "tirol\r\n"
             + "tj\r\n"
             + "tk\r\n"
             + "tl\r\n"
             + "tm\r\n"
             + "tn\r\n"
             + "to\r\n"
             + "today\r\n"
             + "tokyo\r\n"
             + "tools\r\n"
             + "top\r\n"
             + "toray\r\n"
             + "toshiba\r\n"
             + "tours\r\n"
             + "town\r\n"
             + "toyota\r\n"
             + "toys\r\n"
             + "tr\r\n"
             + "trade\r\n"
             + "trading\r\n"
             + "training\r\n"
             + "travel\r\n"
             + "travelers\r\n"
             + "travelersinsurance\r\n"
             + "trust\r\n"
             + "trv\r\n"
             + "tt\r\n"
             + "tube\r\n"
             + "tui\r\n"
             + "tushu\r\n"
             + "tv\r\n"
             + "tw\r\n"
             + "tz\r\n"
             + "ua\r\n"
             + "ubs\r\n"
             + "ug\r\n"
             + "uk\r\n"
             + "university\r\n"
             + "uno\r\n"
             + "uol\r\n"
             + "us\r\n"
             + "uy\r\n"
             + "uz\r\n"
             + "va\r\n"
             + "vacations\r\n"
             + "vana\r\n"
             + "vc\r\n"
             + "ve\r\n"
             + "vegas\r\n"
             + "ventures\r\n"
             + "verisign\r\n"
             + "versicherung\r\n"
             + "vet\r\n"
             + "vg\r\n"
             + "vi\r\n"
             + "viajes\r\n"
             + "video\r\n"
             + "villas\r\n"
             + "vin\r\n"
             + "vip\r\n"
             + "virgin\r\n"
             + "vision\r\n"
             + "vista\r\n"
             + "vistaprint\r\n"
             + "viva\r\n"
             + "vlaanderen\r\n"
             + "vn\r\n"
             + "vodka\r\n"
             + "volkswagen\r\n"
             + "vote\r\n"
             + "voting\r\n"
             + "voto\r\n"
             + "voyage\r\n"
             + "vu\r\n"
             + "wales\r\n"
             + "walter\r\n"
             + "wang\r\n"
             + "wanggou\r\n"
             + "watch\r\n"
             + "watches\r\n"
             + "weather\r\n"
             + "webcam\r\n"
             + "weber\r\n"
             + "website\r\n"
             + "wed\r\n"
             + "wedding\r\n"
             + "weir\r\n"
             + "wf\r\n"
             + "whoswho\r\n"
             + "wien\r\n"
             + "wiki\r\n"
             + "williamhill\r\n"
             + "win\r\n"
             + "windows\r\n"
             + "wine\r\n"
             + "wme\r\n"
             + "work\r\n"
             + "works\r\n"
             + "world\r\n"
             + "ws\r\n"
             + "wtc\r\n"
             + "wtf\r\n"
             + "xbox\r\n"
             + "xerox\r\n"
             + "xin\r\n"
             + "xn--11b4c3d\r\n"
             + "xn--1qqw23a\r\n"
             + "xn--30rr7y\r\n"
             + "xn--3bst00m\r\n"
             + "xn--3ds443g\r\n"
             + "xn--3e0b707e\r\n"
             + "xn--3pxu8k\r\n"
             + "xn--42c2d9a\r\n"
             + "xn--45brj9c\r\n"
             + "xn--45q11c\r\n"
             + "xn--4gbrim\r\n"
             + "xn--55qw42g\r\n"
             + "xn--55qx5d\r\n"
             + "xn--6frz82g\r\n"
             + "xn--6qq986b3xl\r\n"
             + "xn--80adxhks\r\n"
             + "xn--80ao21a\r\n"
             + "xn--80asehdb\r\n"
             + "xn--80aswg\r\n"
             + "xn--90a3ac\r\n"
             + "xn--90ais\r\n"
             + "xn--9dbq2a\r\n"
             + "xn--9et52u\r\n"
             + "xn--b4w605ferd\r\n"
             + "xn--c1avg\r\n"
             + "xn--c2br7g\r\n"
             + "xn--cg4bki\r\n"
             + "xn--clchc0ea0b2g2a9gcd\r\n"
             + "xn--czr694b\r\n"
             + "xn--czrs0t\r\n"
             + "xn--czru2d\r\n"
             + "xn--d1acj3b\r\n"
             + "xn--d1alf\r\n"
             + "xn--eckvdtc9d\r\n"
             + "xn--efvy88h\r\n"
             + "xn--estv75g\r\n"
             + "xn--fhbei\r\n"
             + "xn--fiq228c5hs\r\n"
             + "xn--fiq64b\r\n"
             + "xn--fiqs8s\r\n"
             + "xn--fiqz9s\r\n"
             + "xn--fjq720a\r\n"
             + "xn--flw351e\r\n"
             + "xn--fpcrj9c3d\r\n"
             + "xn--fzc2c9e2c\r\n"
             + "xn--g2xx48c\r\n"
             + "xn--gecrj9c\r\n"
             + "xn--h2brj9c\r\n"
             + "xn--hxt814e\r\n"
             + "xn--i1b6b1a6a2e\r\n"
             + "xn--imr513n\r\n"
             + "xn--io0a7i\r\n"
             + "xn--j1aef\r\n"
             + "xn--j1amh\r\n"
             + "xn--j6w193g\r\n"
             + "xn--jlq61u9w7b\r\n"
             + "xn--kcrx77d1x4a\r\n"
             + "xn--kprw13d\r\n"
             + "xn--kpry57d\r\n"
             + "xn--kpu716f\r\n"
             + "xn--kput3i\r\n"
             + "xn--l1acc\r\n"
             + "xn--lgbbat1ad8j\r\n"
             + "xn--mgb9awbf\r\n"
             + "xn--mgba3a3ejt\r\n"
             + "xn--mgba3a4f16a\r\n"
             + "xn--mgbaam7a8h\r\n"
             + "xn--mgbab2bd\r\n"
             + "xn--mgbayh7gpa\r\n"
             + "xn--mgbb9fbpob\r\n"
             + "xn--mgbbh1a71e\r\n"
             + "xn--mgbc0a9azcg\r\n"
             + "xn--mgberp4a5d4ar\r\n"
             + "xn--mgbpl2fh\r\n"
             + "xn--mgbt3dhd\r\n"
             + "xn--mgbtx2b\r\n"
             + "xn--mgbx4cd0ab\r\n"
             + "xn--mk1bu44c\r\n"
             + "xn--mxtq1m\r\n"
             + "xn--ngbc5azd\r\n"
             + "xn--ngbe9e0a\r\n"
             + "xn--node\r\n"
             + "xn--nqv7f\r\n"
             + "xn--nqv7fs00ema\r\n"
             + "xn--nyqy26a\r\n"
             + "xn--o3cw4h\r\n"
             + "xn--ogbpf8fl\r\n"
             + "xn--p1acf\r\n"
             + "xn--p1ai\r\n"
             + "xn--pbt977c\r\n"
             + "xn--pgbs0dh\r\n"
             + "xn--pssy2u\r\n"
             + "xn--q9jyb4c\r\n"
             + "xn--qcka1pmc\r\n"
             + "xn--qxam\r\n"
             + "xn--rhqv96g\r\n"
             + "xn--s9brj9c\r\n"
             + "xn--ses554g\r\n"
             + "xn--t60b56a\r\n"
             + "xn--tckwe\r\n"
             + "xn--unup4y\r\n"
             + "xn--vermgensberater-ctb\r\n"
             + "xn--vermgensberatung-pwb\r\n"
             + "xn--vhquv\r\n"
             + "xn--vuq861b\r\n"
             + "xn--wgbh1c\r\n"
             + "xn--wgbl6a\r\n"
             + "xn--xhq521b\r\n"
             + "xn--xkc2al3hye2a\r\n"
             + "xn--xkc2dl3a5ee0h\r\n"
             + "xn--y9a3aq\r\n"
             + "xn--yfro4i67o\r\n"
             + "xn--ygbi2ammx\r\n"
             + "xn--zfr164b\r\n"
             + "xperia\r\n"
             + "xxx\r\n"
             + "xyz\r\n"
             + "yachts\r\n"
             + "yamaxun\r\n"
             + "yandex\r\n"
             + "ye\r\n"
             + "yodobashi\r\n"
             + "yoga\r\n"
             + "yokohama\r\n"
             + "youtube\r\n"
             + "yt\r\n"
             + "za\r\n"
             + "zara\r\n"
             + "zero\r\n"
             + "zip\r\n"
             + "zm\r\n"
             + "zone\r\n"
             + "zuerich\r\n"
             + "zw\r\n"
             + "local";
    }
}
