package jp.groupsession.v2.convert.convert570.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.StringUtilHtml;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cmn.DBUtilFactory;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.IDbUtil;
import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.model.base.CmnDatausedModel;
import jp.groupsession.v2.man.model.base.ManDatausedSumModel;

/**
 * <br>[機  能] alter tableなどのDBの編集を行うDAOクラス
 * <br>[解  説] v5.7.0へコンバートする際に使用する
 * <br>[備  考]
 */
public class ConvTableDao extends AbstractDao {
    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(ConvTableDao.class);

    /**
     * コンストラクタ
     * @param con
     */
    public ConvTableDao(Connection con) {
        super(con);
    }
    /**
     * コンバートを行う
     * @param saiban
     * @throws SQLException
    */
    public void convert(MlCountMtController saiban) throws SQLException {
        log__.debug("-- DBコンバート開始 --");
        //create Table or alter table
        createTable(saiban);
        //インフォメーションのソート順を設定
        __setInfoSort();
        __changeKaigyoBr();

        //連携可能API情報の登録
        __insertGsApi();

        //連携可能APIパラメータ情報の登録
        __insertGsApiParam();

        //六曜情報の登録
        ConvRokuyo0514Dao rky0514Dao = new ConvRokuyo0514Dao();
        rky0514Dao.convert(getCon());
        ConvRokuyo1524Dao rky1524Dao = new ConvRokuyo1524Dao();
        rky1524Dao.convert(getCon());
        ConvRokuyo2534Dao rky2534Dao = new ConvRokuyo2534Dao();
        rky2534Dao.convert(getCon());
        ConvRokuyo3540Dao rky2540Dao = new ConvRokuyo3540Dao();
        rky2540Dao.convert(getCon());

        //メインプラグインの使用データサイズに六曜情報のデータサイズを反映
        __setRokuyoDataSize();

        //WEBメールフィルターのラベル情報を別テーブル化
        __insertWmlLabelData();
        //WEBメールフィルターからラベル情報フィールドを削除
        __deleteWmlLabel();
        //WEBメール メールに付いているラベル情報から不正なデータを削除
        __deleteInvalidLabel();
    }

    /**
     * <br>[機  能] 新規テーブルのcreate、insertを行う
     * <br>[解  説]
     * <br>[備  考]
     * @param saiban 採番コントローラー
     * @throws SQLException SQL実行例外
     */
    public void createTable(
            MlCountMtController saiban) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {

            //SQL生成
            List<SqlBuffer> sqlList = __createSQL(saiban);

            for (SqlBuffer sql : sqlList) {
                log__.info(sql.toLogString());
                pstmt = con.prepareStatement(sql.toSqlString());
                sql.setParameter(pstmt);
                pstmt.executeUpdate();
            }

        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] SQLを生成する
     * <br>[解  説]
     * <br>[備  考]
     * @param saiban 採番コントローラー
     * @return List in SqlBuffer
     * @throws SQLException SQL実行時例外
     */
    private List<SqlBuffer> __createSQL(
            MlCountMtController saiban) throws SQLException {
        ArrayList<SqlBuffer> sqlList = new ArrayList<SqlBuffer>();

        //インフォメーション 内容の中の画像バイナリテーブルを作成
        SqlBuffer sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("create table CMN_INFO_MSG_BIN");
        sqlBuffer.addSql("(");
        sqlBuffer.addSql("     IMS_SID     integer  not null,");
        sqlBuffer.addSql("     IMSB_SID    integer   not null,");
        sqlBuffer.addSql("     BIN_SID     bigint   not null,");
        sqlBuffer.addSql("     primary key (IMS_SID, IMSB_SID)");
        sqlBuffer.addSql(");");
        sqlList.add(sqlBuffer);

        //インフォメーション 並び順を追加
        __addSql(sqlList,
            "alter table CMN_INFO_MSG add column IMS_SORT integer not null default 0;");
        //インフォメーション 内容の型を変更
        __addSql(sqlList,
            "alter table CMN_INFO_MSG alter column IMS_VALUE type text;");

        //連携API特例実行ユーザ情報テーブルを作成
        __addSql(sqlList,
            "create table CMN_API_SPUSER("
                + " USR_SID integer not null,"
                + " primary key (USR_SID)"
                + " );");

        //連携API情報の追加
        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("create table CMN_API_CONNECT");
        sqlBuffer.addSql("(");
        sqlBuffer.addSql("     CAC_SID            integer       not null,");
        sqlBuffer.addSql("     CAC_NAME           varchar(50)   not null,");
        sqlBuffer.addSql("     CAC_DESCRIPTION    varchar(1000),");
        sqlBuffer.addSql("     CAG_SID            integer       not null,");
        sqlBuffer.addSql("     CAG_VERSION        integer       not null,");
        sqlBuffer.addSql("     CAC_URL            text          not null,");
        sqlBuffer.addSql("     CAC_METHOD_KBN     integer       not null,");
        sqlBuffer.addSql("     CAC_AUTH_KBN       integer       not null,");
        sqlBuffer.addSql("     CAC_AUTH_TOKEN     varchar(1000),");
        sqlBuffer.addSql("     CAC_AUTH_ID        varchar(256),");
        sqlBuffer.addSql("     CAC_AUTH_PASS      varchar(352),");
        sqlBuffer.addSql("     CAC_CONTENT_KBN    integer       not null,");
        sqlBuffer.addSql("     CAC_CONTENT_MANUAL varchar(150),");
        sqlBuffer.addSql("     CAC_BODY           text,");
        sqlBuffer.addSql("     CAC_AUID           integer       not null,");
        sqlBuffer.addSql("     CAC_ADATE          timestamp     not null,");
        sqlBuffer.addSql("     CAC_EUID           integer       not null,");
        sqlBuffer.addSql("     CAC_EDATE          timestamp     not null,");
        sqlBuffer.addSql("     CAC_JKBN           integer       not null,");
        sqlBuffer.addSql("     primary key (CAC_SID)");
        sqlBuffer.addSql(");");
        sqlList.add(sqlBuffer);

        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("create table CMN_API_CONNECT_PARAM");
        sqlBuffer.addSql("(");
        sqlBuffer.addSql("     CAC_SID           integer      not null,");
        sqlBuffer.addSql("     CACP_KBN          integer      not null,");
        sqlBuffer.addSql("     CACP_PARAM_TYPE   integer      not null,");
        sqlBuffer.addSql("     CACP_NAME         varchar(150)  not null,");
        sqlBuffer.addSql("     CACP_NAME_DISP    varchar(50)  not null,");
        sqlBuffer.addSql("     CACP_BIKO         varchar(100),");
        sqlBuffer.addSql("     CACP_REQUIRED_KBN integer      not null,");
        sqlBuffer.addSql("     CACP_LIST_KBN     integer      not null,");
        sqlBuffer.addSql("     primary key(CAC_SID, CACP_KBN, CACP_NAME)");
        sqlBuffer.addSql(");");
        sqlList.add(sqlBuffer);

        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("create table CMN_API_CONNECT_HEADER");
        sqlBuffer.addSql("(");
        sqlBuffer.addSql("     CAC_SID    integer      not null,");
        sqlBuffer.addSql("     CACH_SORT  integer      not null,");
        sqlBuffer.addSql("     CACH_KEY   varchar(100) not null,");
        sqlBuffer.addSql("     CACH_VALUE varchar(300) not null,");
        sqlBuffer.addSql("     primary key (CAC_SID, CACH_SORT)");
        sqlBuffer.addSql(");");
        sqlList.add(sqlBuffer);

        //連携可能API情報の追加
        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("create table CMN_API_CONNECT_GSAPI");
        sqlBuffer.addSql("(");
        sqlBuffer.addSql("     CAG_SID         integer       not null,");
        sqlBuffer.addSql("     CAG_PLUGIN      varchar(20)   not null,");
        sqlBuffer.addSql("     CAG_OPERATION   varchar(100)  not null,");
        sqlBuffer.addSql("     CAG_PATH        varchar(1000) not null,");
        sqlBuffer.addSql("     CAG_METHOD_KBN  integer       not null,");
        sqlBuffer.addSql("     CAG_AUTH_KBN    integer       not null,");
        sqlBuffer.addSql("     CAC_CONTENT_KBN integer       not null,");
        sqlBuffer.addSql("     CAG_BODY        text,");
        sqlBuffer.addSql("     CAG_VERSION     integer       not null,");
        sqlBuffer.addSql("     primary key (CAG_SID)");
        sqlBuffer.addSql(");");
        sqlList.add(sqlBuffer);

        //連携可能APIパラメータ情報の追加
        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("create table CMN_API_CONNECT_GSPARAM");
        sqlBuffer.addSql("(");
        sqlBuffer.addSql("     CAG_SID            integer     not null,");
        sqlBuffer.addSql("     CAGP_KBN           integer     not null,");
        sqlBuffer.addSql("     CAGP_PARAM_TYPE    integer     not null,");
        sqlBuffer.addSql("     CAGP_NAME          varchar(150) not null,");
        sqlBuffer.addSql("     CAGP_NAME_DISP     varchar(50) not null,");
        sqlBuffer.addSql("     CAGP_BIKO          varchar(100),");
        sqlBuffer.addSql("     CAGP_REQUIRED_KBN  integer     not null,");
        sqlBuffer.addSql("     CAGP_LIST_KBN      integer     not null,");
        sqlBuffer.addSql("     primary key (CAG_SID, CAGP_KBN, CAGP_NAME)");
        sqlBuffer.addSql(");");
        sqlList.add(sqlBuffer);

        //決裁後アクション情報テーブルを作成
        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("create table RNG_TEMPLATE_ACTION");
        sqlBuffer.addSql("(");
        sqlBuffer.addSql("     RTPA_SID         integer       not null,");
        sqlBuffer.addSql("     RTP_SID          integer       not null,");
        sqlBuffer.addSql("     RTP_VER          integer       not null,");
        sqlBuffer.addSql("     RTPA_SORT        integer       not null,");
        sqlBuffer.addSql("     CAC_SID          integer       not null,");
        sqlBuffer.addSql("     RTPA_NAME        varchar(100),");
        sqlBuffer.addSql("     RTPA_REPEAT_KBN   integer       not null,");
        sqlBuffer.addSql("     RTPA_REPEAT_TYPE  integer       not null,");
        sqlBuffer.addSql("     RFT_ID           varchar(100),");
        sqlBuffer.addSql("     RTPA_USE_KBN     integer       not null,");
        sqlBuffer.addSql("     primary key (RTPA_SID)");
        sqlBuffer.addSql(");");
        sqlList.add(sqlBuffer);

        //アクションパラメータ情報テーブルを作成
        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("create table RNG_ACTIONPARAM");
        sqlBuffer.addSql("(");
        sqlBuffer.addSql("     RAP_SID             integer       not null,");
        sqlBuffer.addSql("     RTPA_SID            integer       not null,");
        sqlBuffer.addSql("     RAP_SORT            integer       not null,");
        sqlBuffer.addSql("     RAP_NAME            varchar(100)  not null,");
        sqlBuffer.addSql("     RAP_USE_KBN         integer       not null,");
        sqlBuffer.addSql("     RAP_CONDITION_JSON  text          not null,");
        sqlBuffer.addSql("     RAP_PARAM_JSON      text          not null,");
        sqlBuffer.addSql("     primary key (RAP_SID, RTPA_SID)");
        sqlBuffer.addSql(");");
        sqlList.add(sqlBuffer);

        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("create table RNG_ACTION_RESULT");
        sqlBuffer.addSql("(");
        sqlBuffer.addSql("     RNG_SID      integer      not null,");
        sqlBuffer.addSql("     RARS_SORT    integer      not null,");
        sqlBuffer.addSql("     RARS_NAME    varchar(100) not null,");
        sqlBuffer.addSql("     RARS_STATUS  integer      not null,");
        sqlBuffer.addSql("     primary key(RNG_SID, RARS_SORT)");
        sqlBuffer.addSql(");");
        sqlList.add(sqlBuffer);

        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("create table RNG_ACTION_RESULT_DATA");
        sqlBuffer.addSql("(");
        sqlBuffer.addSql("     RNG_SID      integer  not null,");
        sqlBuffer.addSql("     RARS_SORT    integer  not null,");
        sqlBuffer.addSql("     RARD_COUNT   integer  not null,");
        sqlBuffer.addSql("     RARD_STATUS  integer  not null,");
        sqlBuffer.addSql("     primary key(RNG_SID, RARS_SORT, RARD_COUNT)");
        sqlBuffer.addSql(");");
        sqlList.add(sqlBuffer);

        //稟議テンプレートから旧連携APIフィールドを削除
        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("alter table RNG_TEMPLATE drop column RTP_USE_APICONNECT;");
        sqlList.add(sqlBuffer);
        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("alter table RNG_TEMPLATE drop column RTP_APICONNECT_COMMENT;");
        sqlList.add(sqlBuffer);
        //稟議テンプレートに連携APIフィールドを削除
        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("alter table RNG_TEMPLATE add column RTP_ACTION_COMMENT varchar(100);");
        sqlList.add(sqlBuffer);

        //六曜情報テーブルを追加
        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("   create table CMN_ROKUYO");
        sqlBuffer.addSql("   (");
        sqlBuffer.addSql("     CRK_DATE date not null,");
        sqlBuffer.addSql("     CRK_KBN integer not null,");
        sqlBuffer.addSql("     primary key(CRK_DATE)");
        sqlBuffer.addSql("   );");
        sqlList.add(sqlBuffer);

        //メイン 使用データサイズ集計テーブルに六曜情報フィールドを追加
        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql(
            "alter table MAN_DATAUSED_SUM add CMN_ROKUYO_SIZE bigint not null default 0;");
        sqlList.add(sqlBuffer);

        //WEBメール フィルター 付与するラベルテーブルを追加
        sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql("create table WML_FILTER_LABEL");
        sqlBuffer.addSql("(");
        sqlBuffer.addSql("     WFT_SID  integer not null,");
        sqlBuffer.addSql("     WLB_SID  integer not null,");
        sqlBuffer.addSql("     primary key(WFT_SID, WLB_SID)");
        sqlBuffer.addSql(");");
        sqlList.add(sqlBuffer);

        return sqlList;
    }

    /**
     * <br>[機  能] 指定されたSQL文をSqlBufferに設定し、実行SQLリストへ追加する
     * <br>[解  説]
     * <br>[備  考]
     * @param sqlList 実行SQLリスト
     * @param sql SQL文
     */
    private void __addSql(ArrayList<SqlBuffer> sqlList, String sql) {
        SqlBuffer sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql(sql);
        sqlList.add(sqlBuffer);
    }

    /**
     * <br>[機  能] インフォメーションSIDをSID順に取得する
     * <br>[解  説]
     * <br>[備  考]
     * @return インフォメーションSID
     * @throws SQLException SQL実行例外
     */
    private List<Integer> __getInfoData() throws SQLException {

        List<Integer> ret = new ArrayList<Integer>();
        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();
        ResultSet rs = null;

        try {

            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("select ");
            sql.addSql("  IMS_SID ");
            sql.addSql("from ");
            sql.addSql("  CMN_INFO_MSG ");
            sql.addSql("order by ");
            sql.addSql("  IMS_SID;");

            log__.info(sql.toLogString());
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(rs.getInt("IMS_SID"));
            }

        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
            JDBCUtil.closeResultSet(rs);
        }
        return ret;
    }

    /**
     * <br>[機  能] インフォメーションのソート順を設定する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行例外
     */
    private void __setInfoSort() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        List<Integer> imsSidList = __getInfoData();
        Map<Integer, String> urlLinkMap = __getUrlLinkMap();

        try {

            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("update ");
            sql.addSql("  CMN_INFO_MSG ");
            sql.addSql("set ");
            sql.addSql("  IMS_SORT = ?, ");
            sql.addSql("  IMS_VALUE = ? ");
            sql.addSql("where ");
            sql.addSql("  IMS_SID = ?;");

            int imsSort = 1;
            pstmt = con.prepareStatement(sql.toSqlString());

            for (int imsSid : imsSidList) {
                log__.info(sql.toLogString());
                sql.addIntValue(imsSort);
                sql.addStrValue(urlLinkMap.get(imsSid));
                sql.addIntValue(imsSid);
                sql.setParameter(pstmt);
                pstmt.executeUpdate();

                sql.clearValue();
                imsSort++;
            }

        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] インフォメーションの改行コードを"<br>"に変換する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行例外
     */
    private void __changeKaigyoBr() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {

            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("update ");
            sql.addSql("  CMN_INFO_MSG ");
            sql.addSql("set ");
            IDbUtil dbUtil = DBUtilFactory.getInstance();
            if (dbUtil.getDbType() == GSConst.DBTYPE_POSTGRES) {
                sql.addSql(" IMS_VALUE = REPLACE(IMS_VALUE, '\r\n', '<br>');");
            } else {
                sql.addSql("  IMS_VALUE = REPLACE(IMS_VALUE, CHAR(10), '<br>') ");
            }

            pstmt = con.prepareStatement(sql.toSqlString());
            pstmt.executeUpdate();

        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] インフォメーションのURLリンクをtinyMceで表示可能にする
     * <br>[解  説]
     * <br>[備  考] リンクはStringUtilHtml.transToHTmlPlusAmparsantAndLinkにてaタグ化する
     * @return キー インフォメーションSID：値 変換後の内容を格納したマップ
     * @throws SQLException SQL実行例外
     */
    private Map<Integer, String> __getUrlLinkMap() throws SQLException {

        Map<Integer, String> ret = new HashMap<>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("select ");
            sql.addSql("  IMS_SID, ");
            sql.addSql("  IMS_VALUE ");
            sql.addSql("from ");
            sql.addSql("  CMN_INFO_MSG ");

            pstmt = con.prepareStatement(sql.toSqlString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.put(rs.getInt("IMS_SID"),
                    StringUtilHtml.transToHTmlPlusAmparsantAndLink(
                        rs.getString("IMS_VALUE")));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
            JDBCUtil.closeResultSet(rs);
        }

        return ret;
    }

    /**
     * <br>[機  能] 連携可能API情報を登録する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行例外
     */
    private void __insertGsApi() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        StringBuilder sb = new StringBuilder();
        sb.append("'--boundary\r\n");
        sb.append("Content-Disposition: form-data; name=fdrParentSid\r\n\r\n");
        sb.append("${fdrParentSid}\r\n");
        sb.append("--boundary\r\n");
        sb.append("Content-Disposition: form-data; name=fcbSid\r\n\r\n");
        sb.append("${fcbSid}\r\n");
        sb.append("--boundary\r\n");
        sb.append("Content-Disposition: form-data; name=uploadFile; filename=\"\"\r\n\r\n");
        sb.append("${uploadFile}\r\n");
        sb.append("--boundary\r\n");
        sb.append("Content-Disposition: form-data; name=fdrErrlDate\r\n\r\n");
        sb.append("${fdrErrlDate}\r\n");
        sb.append("--boundary\r\n");
        sb.append("Content-Disposition: form-data; name=fdrErrlTarget\r\n\r\n");
        sb.append("${fdrErrlTarget}\r\n");
        sb.append("--boundary\r\n");
        sb.append("Content-Disposition: form-data; name=fdrErrlMoney\r\n\r\n");
        sb.append("${fdrErrlMoney}\r\n");
        sb.append("--boundary\r\n");
        sb.append("Content-Disposition: form-data; name=fdrErrlMoneyType\r\n\r\n");
        sb.append("${fdrErrlMoneyType}\r\n");
        sb.append("--boundary--'");

        try {
            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("insert into ");
            sql.addSql("  CMN_API_CONNECT_GSAPI ");
            sql.addSql("values ");
            sql.addSql("  (1, 'webmail', 'send',"
                + "'/api/webmail/mail/send.do?wacSid=${wacSid}&sendAdrTo=${sendAdrTo}"
                + "&title=${title}&body=${body}&sendType=0', 0, 1, 1, null, 1),");
            sql.addSql("  (2, 'schedule', 'add',"
                + "'/api/schedule/edit.do?title=${title}&from=${from}&to=${to}&userKbn=${userKbn}"
                + "&targetId=${targetId}&colorKbn=${colorKbn}&scdSid=-1', 0, 1, 1, null, 1),");
            sql.addSql("  (3, 'smail', 'send',"
                + "'/api/smail/mail/send.do?sacSid=${sacSid}"
                + "&sendTo=${sendTo}&title=${title}&body=${body}', 0, 1, 1, null, 1),");
            sql.addSql("  (4, 'file', 'addFolder',"
                + "'/api/file/addfolder.do?"
                + "fdrParentSid=${fdrParentSid}&fdrName=${fdrName}', 0, 1, 1, null, 1),");
            sql.addSql("  (5, 'file', 'addFile',"
                + "'/api/file/add.do', 1, 1, 5, " + sb.toString() + ", 1),");
            sql.addSql("  (6, 'timecard', 'add',"
                + "'/api/timecard/edit.do?"
                + "userId=${userId}&targetDate=${targetDate}&stampStartTime=${stampStartTime}"
                + "&stampEndTime=${stampEndTime}&startTime=${startTime}&endTime=${endTime}"
                + "&chikokuFlg=${chikokuFlg}&soutaiFlg=${soutaiFlg}&holidayType=${holidayType}"
                + "&holidayNum=${holidayNum}&holidayText=${holidayText}', 0, 1, 1, null, 1),");
            sql.addSql("  (7, 'nippou', 'addNippou',"
                + "'/api/ntp/nippouEdit.do?"
                + "usrSid=${usrSid}&nipDate=${nipDate}&nipFrTime=${nipFrTime}"
                + "&nipToTime=${nipToTime}&nipTitle=${nipTitle}&nipSid=-1&cmd=addNtp', "
                + "0, 1, 1, null, 1),");
            sql.addSql("  (8, 'nippou', 'addAnken',"
                + "'/api/ntp/ankenEdit.do?"
                + "nanCode=${nanCode}&nanName=${nanName}&nanSid=-1', "
                + "0, 1, 1, null, 1),");
            sql.addSql("  (9, 'chat', 'send',"
                + "'/api/chat/send.do?"
                + "sendKbn=${sendKbn}&selectId=${selectId}&body=${body}', "
                + "0, 1, 1, null, 1)");

            log__.info(sql.toLogString());
            pstmt = con.prepareStatement(sql.toSqlString());
            pstmt.executeUpdate();

        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] 連携可能APIパラメータ情報を登録する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行例外
     */
    private void __insertGsApiParam() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("insert into ");
            sql.addSql("  CMN_API_CONNECT_GSPARAM ");
            sql.addSql("values ");
            sql.addSql("  (1, 1, 0, 'wacSid', 'アカウントSID', '', 1, 0),");
            sql.addSql("  (1, 1, 0, 'sendAdrTo', '宛先メールアドレス', '', 1, 1),");
            sql.addSql("  (1, 1, 0, 'title', 'タイトル', '', 1, 0),");
            sql.addSql("  (1, 1, 0, 'body', '本文', '', 1, 0),");
            sql.addSql("  (2, 1, 0, 'title', 'タイトル', '', 1, 0),");
            sql.addSql("  (2, 1, 0, 'from', '開始日時', 'yyyy/MM/dd hh:mm形式', 1, 0),");
            sql.addSql("  (2, 1, 0, 'to', '終了日時', 'yyyy/MM/dd hh:mm形式', 1, 0),");
            sql.addSql("  (2, 1, 0, 'userKbn', 'ユーザ区分', '0:ユーザ, 1:グループ', 1, 0),");
            sql.addSql("  (2, 1, 0, 'targetId', '登録対象者ID',"
                + "'ユーザ区分に対応したユーザIDまたはグループID', 1, 0),");
            sql.addSql("  (2, 1, 0, 'colorKbn', 'タイトル色', '1:青 2:赤 3:緑 4:黄 5:黒', 1, 0),");
            sql.addSql("  (3, 1, 0, 'sacSid', 'アカウントSID', '', 1, 0),");
            sql.addSql("  (3, 1, 0, 'sendTo', '宛先アカウントSID', '', 1, 1),");
            sql.addSql("  (3, 1, 0, 'title', '件名', '', 1, 0),");
            sql.addSql("  (3, 1, 0, 'body', '本文', '', 1, 0),");

            sql.addSql("  (4, 1, 0, 'fdrParentSid', '親ディレクトリSID', '登録対象の親ディレクトリSID', 1, 0),");
            sql.addSql("  (4, 1, 0, 'fdrName', 'フォルダ名', '登録するフォルダの名称', 1, 0),");
            sql.addSql("  (5, 2, 0, 'fdrParentSid', '親ディレクトリSID', "
                + "'保存先が「保存先振り分け機能を無効化した電帳法キャビネット」または「電帳法キャビネット以外」の場合に保存先のディレクトリSIDを指定', 0, 0),");
            sql.addSql("  (5, 2, 0, 'fcbSid', 'キャビネットSID', "
                + "'保存先が「保存先振り分け機能を有効化した電帳法キャビネット」の場合に保存先キャビネットSIDを指定', 0, 0),");
            sql.addSql("  (5, 2, 1, 'uploadFile', '添付ファイル情報', '登録するファイル情報', 1, 0),");
            sql.addSql("  (5, 2, 0, 'fdrErrlDate', '取引年月日', 'yyyy/MM/dd形式。電帳法キャビネットのみ使用。', 0, 0),");
            sql.addSql("  (5, 2, 0, 'fdrErrlTarget', '取引先', '電帳法キャビネットのみ使用', 0, 0),");
            sql.addSql("  (5, 2, 0, 'fdrErrlMoney', '取引金額', '電帳法キャビネットのみ使用', 0, 0),");
            sql.addSql("  (5, 2, 0, 'fdrErrlMoneyType', '外貨名', '電帳法キャビネットのみ使用', 0, 0),");
            sql.addSql("  (6, 1, 0, 'userId', 'ユーザID', '', 1, 0),");
            sql.addSql("  (6, 1, 0, 'targetDate', '登録日', 'yyyy/MM/dd形式', 1, 0),");
            sql.addSql("  (6, 1, 0, 'stampStartTime', '打刻始業時間', 'hh:mm形式', 0, 0),");
            sql.addSql("  (6, 1, 0, 'stampEndTime', '打刻終業時間', 'hh:mm形式', 0, 0),");
            sql.addSql("  (6, 1, 0, 'startTime', '始業時間', 'hh:mm形式', 0, 0),");
            sql.addSql("  (6, 1, 0, 'endTime', '終業時間', 'hh:mm形式', 0, 0),");
            sql.addSql("  (6, 1, 0, 'chikokuFlg', '遅刻区分', '0:指定なし, 1:遅刻', 0, 0),");
            sql.addSql("  (6, 1, 0, 'soutaiFlg', '早退区分', '0:指定なし, 1:早退', 0, 0),");
            sql.addSql("  (6, 1, 0, 'holidayType', '休日区分', '', 0, 0),");
            sql.addSql("  (6, 1, 0, 'holidayNum', '休日日数', '', 0, 0),");
            sql.addSql("  (6, 1, 0, 'holidayText', '休日内容', '休日内容が設定できる休日区分を選択時に使用', 0, 0),");
            sql.addSql("  (7, 1, 0, 'usrSid', 'ユーザSID', '', 1, 0),");
            sql.addSql("  (7, 1, 0, 'nipDate', '報告日', 'yyyy/MM/dd形式', 1, 0),");
            sql.addSql("  (7, 1, 0, 'nipFrTime', '開始時間', 'hh:mm形式', 1, 0),");
            sql.addSql("  (7, 1, 0, 'nipToTime', '終了時間', 'hh:mm形式', 1, 0),");
            sql.addSql("  (7, 1, 0, 'nipTitle', 'タイトル', '', 1, 0),");
            sql.addSql("  (8, 1, 0, 'nanCode', '案件コード', '', 1, 0),");
            sql.addSql("  (8, 1, 0, 'nanName', '案件名', '', 1, 0),");
            sql.addSql("  (9, 1, 0, 'sendKbn', 'チャット区分', '1:ユーザ, 2:グループ', 1, 0),");
            sql.addSql("  (9, 1, 0, 'selectId', '区分ID', "
                + "'送信先のIDとしてチャット区分に対応したユーザSIDまたはグループIDを指定', 1, 0),");
            sql.addSql("  (9, 1, 0, 'body', 'メッセージ', '', 1, 0);");

            log__.info(sql.toLogString());
            pstmt = con.prepareStatement(sql.toSqlString());
            pstmt.executeUpdate();

        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] メインプラグインの使用データサイズに六曜情報のデータサイズを反映
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行例外
     */
    private void __setRokuyoDataSize() throws SQLException {

        //メイン 使用データサイズ集計の合計データに六曜情報のデータサイズを反映
        ManDatausedSumModel mdsMdl = __getManDatausedSum();
        if (mdsMdl != null) {
            __updateManDatausedSum();
        } else {
            __insertManDatausedSum();
        }

        //使用データサイズ集計のメインプラグインの合計データに六曜情報のデータサイズを反映
        CmnDatausedModel cduMdl = __getCmnDataused();
        if (cduMdl != null) {
            long dataSize = cduMdl.getCduSize();
            dataSize += 289278;
            __updateCmnDataused(dataSize);
        } else {
            __insertCmnDataused();
        }
    }

    /**
     * <br>[機  能] メイン 使用データサイズ集計の合計データを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @return メイン 使用データサイズ集計モデル
     * @throws SQLException SQL実行例外
     */
    private ManDatausedSumModel __getManDatausedSum() throws SQLException {

        ManDatausedSumModel ret = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   SUM_TYPE,");
            sql.addSql("   CMN_LOG_SIZE,");
            sql.addSql("   CMN_LOGIN_HISTORY_SIZE,");
            sql.addSql("   CMN_ROKUYO_SIZE");
            sql.addSql(" from");
            sql.addSql("   MAN_DATAUSED_SUM");
            sql.addSql(" where");
            sql.addSql("   SUM_TYPE = 0;");

            log__.info(sql.toLogString());
            pstmt = con.prepareStatement(sql.toSqlString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = new ManDatausedSumModel();
                ret.setSumType(rs.getInt("SUM_TYPE"));
                ret.setCmnLogSize(rs.getLong("CMN_LOG_SIZE"));
                ret.setCmnLoginHistorySize(rs.getLong("CMN_LOGIN_HISTORY_SIZE"));
                ret.setCmnRokuyoSize(rs.getLong("CMN_ROKUYO_SIZE"));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
            JDBCUtil.closeResultSet(rs);
        }
        return ret;
    }

    /**
     * <br>[機  能] メイン 使用データサイズ集計の合計データに六曜情報のデータサイズを反映
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行例外
     */
    private void __updateManDatausedSum() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   MAN_DATAUSED_SUM");
            sql.addSql(" set");
            sql.addSql("   CMN_ROKUYO_SIZE = 289278");
            sql.addSql(" where");
            sql.addSql("   SUM_TYPE = 0;");

            log__.info(sql.toLogString());
            pstmt = con.prepareStatement(sql.toSqlString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] メイン 使用データサイズ集計の合計データを追加
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行例外
     */
    private void __insertManDatausedSum() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert into");
            sql.addSql("   MAN_DATAUSED_SUM");
            sql.addSql("     (SUM_TYPE, CMN_LOG_SIZE, CMN_LOGIN_HISTORY_SIZE, CMN_ROKUYO_SIZE)");
            sql.addSql("   values");
            sql.addSql("     (0, 0, 0, 289278);");

            log__.info(sql.toLogString());
            pstmt = con.prepareStatement(sql.toSqlString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] 使用データサイズ集計のメインプラグインの合計データを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @return メイン 使用データサイズ集計モデル
     * @throws SQLException SQL実行例外
     */
    private CmnDatausedModel __getCmnDataused() throws SQLException {

        CmnDatausedModel ret = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CDU_PLUGIN,");
            sql.addSql("   CDU_SIZE");
            sql.addSql(" from");
            sql.addSql("   CMN_DATAUSED");
            sql.addSql(" where");
            sql.addSql("   CDU_PLUGIN = 'main';");

            log__.info(sql.toLogString());
            pstmt = con.prepareStatement(sql.toSqlString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = new CmnDatausedModel();
                ret.setCduPlugin(rs.getString("CDU_PLUGIN"));
                ret.setCduSize(rs.getLong("CDU_SIZE"));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
            JDBCUtil.closeResultSet(rs);
        }
        return ret;
    }

    /**
     * <br>[機  能] 使用データサイズ集計のメインプラグインの合計データに六曜情報のデータサイズを反映
     * <br>[解  説]
     * <br>[備  考]
     * @param dataSize メインプラグインの使用データサイズ
     * @throws SQLException SQL実行例外
     */
    private void __updateCmnDataused(long dataSize) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CMN_DATAUSED");
            sql.addSql(" set");
            sql.addSql("   CDU_SIZE = ?");
            sql.addSql(" where");
            sql.addSql("   CDU_PLUGIN = 'main';");

            log__.info(sql.toLogString());
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addLongValue(dataSize);
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] 使用データサイズ集計のメインプラグインの合計データを追加
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行例外
     */
    private void __insertCmnDataused() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert into");
            sql.addSql("   CMN_DATAUSED");
            sql.addSql("     (CDU_PLUGIN, CDU_SIZE)");
            sql.addSql("   values");
            sql.addSql("     ('main', 289278);");

            log__.info(sql.toLogString());
            pstmt = con.prepareStatement(sql.toSqlString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }


    /**
     * <br>[機  能] WEBメール フィルター情報から、フィルターSIDとラベルSIDの組み合わせを取得する
     * <br>[解  説]
     * <br>[備  考] フィルタの動作に"ラベルを付ける"が選択されているレコードのみを対象にする
     * @throws SQLException SQL実行例外
     */
    private void __insertWmlLabelData() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" WML_FILTER_LABEL(");
            sql.addSql("   WFT_SID,");
            sql.addSql("   WLB_SID");
            sql.addSql(" )");
            sql.addSql(" select ");
            sql.addSql("   WML_FILTER.WFT_SID,");
            sql.addSql("   WML_FILTER.WLB_SID");
            sql.addSql(" from ");
            sql.addSql("   WML_FILTER, ");
            sql.addSql("   WML_LABEL ");
            sql.addSql(" where ");
            sql.addSql("   WML_FILTER.WFT_ACTION_LABEL = 1");
            sql.addSql(" and ");
            sql.addSql("   WML_FILTER.WLB_SID = WML_LABEL.WLB_SID");

            log__.info(sql.toLogString());
            pstmt = con.prepareStatement(sql.toSqlString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }
    /**
     * <br>[機  能] WEBメールのフィルターテーブルからラベルSIDフィールドを削除する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行例外
     */
    private void __deleteWmlLabel() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {

            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("alter table ");
            sql.addSql("  WML_FILTER ");
            sql.addSql("drop column ");
            sql.addSql("  WLB_SID ");

            pstmt = con.prepareStatement(sql.toSqlString());
            pstmt.executeUpdate();

        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] WEBメール メールに付いているラベルから、存在しないラベルSIDを削除する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行例外
     */
    private void __deleteInvalidLabel() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {

            //SQL生成
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("delete from ");
            sql.addSql("  WML_LABEL_RELATION ");
            sql.addSql("where ");
            sql.addSql("  WLB_SID not in ( ");
            sql.addSql("    select ");
            sql.addSql("      WLB_SID ");
            sql.addSql("    from ");
            sql.addSql("      WML_LABEL ");
            sql.addSql("  ) ");

            pstmt = con.prepareStatement(sql.toSqlString());
            pstmt.executeUpdate();

        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }
}