package jp.groupsession.v2.convert.convert571.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cmn.dao.MlCountMtController;

/**
 * <br>[機  能] alter tableなどのDBの編集を行うDAOクラス
 * <br>[解  説] v5.7.1へコンバートする際に使用する
 * <br>[備  考]
 */
public class ConvTableDao extends AbstractDao {
    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(ConvTableDao.class);

    /**
    * コンストラクタ
    * @param con
    */
    public ConvTableDao(Connection con) {
        super(con);
    }
    /**
    * コンバートを行う
    * @param saiban
    * @throws SQLException
    */
    public void convert(MlCountMtController saiban) throws SQLException {
        log__.debug("-- DBコンバート開始 --");

        createTable();

        //稟議テンプレートカテゴリアクセス権限情報テーブルを削除
        __dropRngTemplatecategoryAccess();

        // 外部ページ表示制限設定が未設定の時、初期値を設定
        __insertCmnExtPageInitData();
    }

    /**
     * <br>[機  能] 新規テーブルのcreate、insertを行う
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {

            //SQL生成
            List<SqlBuffer> sqlList = __createSQL();

            for (SqlBuffer sql : sqlList) {
                log__.info(sql.toLogString());
                pstmt = con.prepareStatement(sql.toSqlString());
                sql.setParameter(pstmt);
                pstmt.executeUpdate();
            }

        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] SQLを生成する
     * <br>[解  説]
     * <br>[備  考]
     * @return List in SqlBuffer
     * @throws SQLException SQL実行時例外
     */
    private List<SqlBuffer> __createSQL() throws SQLException {
        ArrayList<SqlBuffer> sqlList = new ArrayList<SqlBuffer>();

        //ショートメール受信未読件数，受信件数取得SQLのチューニング
        SqlBuffer sqlBuffer = new SqlBuffer();
        sqlBuffer.addSql(
            "create index SML_JMEIS_INDEX3 on SML_JMEIS(SAC_SID, SMJ_OPKBN, SMJ_JKBN);");
        sqlList.add(sqlBuffer);
        return sqlList;
    }

    /**
     * <br>[機  能] 稟議テンプレートカテゴリアクセス権限情報テーブルを削除する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     */
    private void __dropRngTemplatecategoryAccess() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" drop table RNG_TEMPLATECATEGORY_ACCESS");

            log__.info(sql.toLogString());
            pstmt = con.prepareStatement(sql.toSqlString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] 外部ページ表示制限設定が設定されているか判定する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     * @return 結果（true:設定されている, false:未設定）
     */
    private boolean __isExistCmnExtPageData() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean ret = false;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   count(CEP_LIMIT_DSP) as cnt");
            sql.addSql("  from  ");
            sql.addSql("    CMN_EXT_PAGE");

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                if (rs.getInt("cnt") > 0) {
                    ret = true;
                }
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 外部ページ表示制限設定が未設定の時、初期値を設定する。
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     */
    private void __insertCmnExtPageInitData() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            if (!__isExistCmnExtPageData()) {
                //SQL生成
                SqlBuffer sql = new SqlBuffer();
                sql.addSql(" insert ");
                sql.addSql(" into ");
                sql.addSql(" CMN_EXT_PAGE(");
                sql.addSql("   CEP_LIMIT_DSP,");
                sql.addSql("   CEP_AUID,");
                sql.addSql("   CEP_ADATE,");
                sql.addSql("   CEP_EUID,");
                sql.addSql("   CEP_EDATE");
                sql.addSql(" )");
                sql.addSql(" values");
                sql.addSql(" (");
                sql.addSql("   ?,");
                sql.addSql("   ?,");
                sql.addSql("   ?,");
                sql.addSql("   ?,");
                sql.addSql("   ?");
                sql.addSql(" )");

                pstmt = con.prepareStatement(sql.toSqlString());
                UDate now = new UDate();
                sql.addIntValue(0);
                sql.addIntValue(0);
                sql.addDateValue(now);
                sql.addIntValue(0);
                sql.addDateValue(now);

                log__.info(sql.toLogString());
                pstmt = con.prepareStatement(sql.toSqlString());
                sql.setParameter(pstmt);
                pstmt.executeUpdate();
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }
}