package jp.groupsession.v2.man.man310;

import java.sql.Connection;
import java.sql.SQLException;

import jp.co.sjts.util.NullDefault;
import jp.groupsession.v2.cmn.dao.base.CmnInfoBinDao;
import jp.groupsession.v2.cmn.dao.base.CmnInfoMsgBinDao;
import jp.groupsession.v2.cmn.dao.base.CmnInfoMsgDao;
import jp.groupsession.v2.cmn.model.base.CmnInfoMsgBinModel;
import jp.groupsession.v2.cmn.model.base.CmnInfoMsgModel;

/**
 * <br>[機  能] メイン インフォメーション詳細画面のビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Man310Biz {

    /**
     * <br>[機  能] 初期表示画面情報を設定します
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param con コネクション
     * @throws SQLException SQL実行時例外
     */
    public void setInitData(Man310ParamModel paramMdl, Connection con)
    throws SQLException {

        int imsSid = NullDefault.getInt(paramMdl.getMan310SelectedSid(), -1);
        CmnInfoMsgDao infoDao = new CmnInfoMsgDao(con);
        CmnInfoMsgModel infoMdl = infoDao.select(imsSid);
        if (infoMdl == null) {
            return;
        }

        //メッセージ・内容文字生成
        paramMdl.setMan310Msg(infoMdl.getImsMsg());

        //インフォメーション内の画像ファイル取得URLを書き換える
        String imgStr = "src=\"man290.do?"
                + "CMD=getBodyFile&amp;man290TempSaveId=";
        String replaceStr = "src=\"man310.do?"
                + "CMD=getBodyFile&imssid=" + imsSid + "&amp;man310ImsbSid=";
        String infoValue = NullDefault.getString(infoMdl.getImsValue(), "");
        paramMdl.setMan310Value(infoValue.replace(imgStr, replaceStr));

        //添付ファイル一覧
        CmnInfoBinDao binDao = new CmnInfoBinDao(con);
        paramMdl.setTmpFileList(binDao.getBinList(imsSid));
    }

    /**
     * <br>[機  能] 指定したインフォメーション情報の添付ファイルが存在するかを判定する
     * <br>[解  説]
     * <br>[備  考]
     * @param con コネクション
     * @param imsSid インフォメーションSID
     * @param binSid バイナリ―SID
     * @return true: 存在する false: 存在しない
     * @throws SQLException SQL実行時例外
     */
    public boolean existInfoBinData(Connection con, int imsSid, long binSid) throws SQLException {
        boolean result = false;

        CmnInfoMsgDao infoDao = new CmnInfoMsgDao(con);
        CmnInfoMsgModel infoMdl = infoDao.select(imsSid);
        if (infoMdl != null) {
            CmnInfoBinDao binDao = new CmnInfoBinDao(con);
            result = binDao.select(imsSid, binSid) != null;
        }

        return result;
    }

    /**
     * <br>[機  能] 内容の中の画像ファイルのバイナリSIDを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param con コネクション
     * @param imsSid インフォメーションSID
     * @param imsbSid インフォメーション画像SID
     * @return バイナリSID
     * @throws SQLException SQL実行時例外
     */
    public long getMessageBinSid(Connection con, int imsSid, int imsbSid) throws SQLException {

        long ret = -1;

        CmnInfoMsgBinDao binDao = new CmnInfoMsgBinDao(con);
        CmnInfoMsgBinModel binMdl = binDao.select(imsSid, imsbSid);
        if (binMdl != null) {
            ret = binMdl.getBinSid();
        }

        return ret;
    }
}
