package jp.groupsession.v2.restapi.filter.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
/**
 * IActionFilterインタフェースの実装クラスにつけるアノテーション。
 * AddFilterで追加されるフィルタにはつける必要がない。
 * アノテーションで実行される条件となるURLやパラメータを設定し、
 * 一致するリクエストの場合のみにフィルタが実行されるようにする。
 * 1クラスに対して複数設定し、複数のURLで実行させることができる。
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Repeatable(ActionFilter.Holder.class)
public @interface ActionFilter {
    /** @return 実行メソッド名 */
    String runner() default "doFilter";
    /** @return 対象URL */
    String path() default "";
    /** @return 対象HTTPメソッド */
    String method() default "";

    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.TYPE)
    @interface Holder {
        /** @return 複数指定用 実体*/
        ActionFilter[] value();
    }
}
