package jp.groupsession.v2.restapi.msg;

import java.text.MessageFormat;
import java.util.Locale;

import org.apache.struts.util.MessageResources;
import org.apache.struts.util.PropertyMessageResources;

import jp.co.sjts.util.StringUtilHtml;

/**
 * <br>[機  能]
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RestapiMessageResources extends PropertyMessageResources {

    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param mr メッセージリソース
     */
    public RestapiMessageResources(MessageResources mr) {
        super(mr.getFactory(), mr.getConfig());
    }

    /**
     * <br>[機  能] <br>を\r\nに置き換えたメッセージを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param locale ロケール
     * @param key メッセージキー
     * @param args メッセージキーの中で使用する文字列
     */
    @SuppressWarnings("unchecked")
    @Override
    public String getMessage(Locale locale, String key, Object[] args) {
        if (locale == null) {
            locale = this.defaultLocale;
        }

        MessageFormat format = null;
        String formatKey = this.messageKey(locale, key);
        synchronized (this.formats) {
            format = (MessageFormat) this.formats.get(formatKey);
            if (format == null) {
                String formatString = this.getMessage(locale, key);
                if (formatString == null) {
                    return this.returnNull ? null : "???" + formatKey + "???";
                }
                formatString = StringUtilHtml.transBRtoCRLF(formatString);
                format = new MessageFormat(this.escape(formatString));
                format.setLocale(locale);
                this.formats.put(formatKey, format);
            }
        }

        return format.format(args);
    }
}
